/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.plan.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.api.exception.ApiDeprecatedException;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.audit.domain_service.AuditDomainService;
import io.gravitee.apim.core.audit.model.ApiAuditLogEntity;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.AuditProperties;
import io.gravitee.apim.core.audit.model.event.PlanAuditEvent;
import io.gravitee.apim.core.flow.crud_service.FlowCrudService;
import io.gravitee.apim.core.flow.domain_service.FlowValidationDomainService;
import io.gravitee.apim.core.plan.crud_service.PlanCrudService;
import io.gravitee.apim.core.plan.domain_service.PlanValidatorDomainService;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.apim.core.plan.model.PlanWithFlows;
import io.gravitee.common.utils.TimeProvider;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.flow.Flow;
import io.gravitee.definition.model.v4.listener.Listener;
import io.gravitee.rest.api.service.common.UuidString;
import java.sql.Date;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

@DomainService
public class CreatePlanDomainService {
    private final PlanValidatorDomainService planValidatorDomainService;
    private final FlowValidationDomainService flowValidationDomainService;
    private final PlanCrudService planCrudService;
    private final FlowCrudService flowCrudService;
    private final AuditDomainService auditService;

    public CreatePlanDomainService(PlanValidatorDomainService planValidatorDomainService, FlowValidationDomainService flowValidationDomainService, PlanCrudService planCrudService, FlowCrudService flowCrudService, AuditDomainService auditDomainService) {
        this.planValidatorDomainService = planValidatorDomainService;
        this.flowValidationDomainService = flowValidationDomainService;
        this.planCrudService = planCrudService;
        this.flowCrudService = flowCrudService;
        this.auditService = auditDomainService;
    }

    public PlanWithFlows create(Plan plan, List<Flow> flows, Api api, AuditInfo auditInfo) {
        return switch (api.getDefinitionVersion()) {
            case DefinitionVersion.V4 -> this.createV4ApiPlan(plan, flows, api, auditInfo);
            case DefinitionVersion.FEDERATED -> this.createFederatedApiPlan(plan, auditInfo);
            default -> throw new IllegalStateException(api.getDefinitionVersion() + " is not supported");
        };
    }

    private PlanWithFlows createV4ApiPlan(Plan plan, List<Flow> flows, Api api, AuditInfo auditInfo) {
        if (api.isDeprecated()) {
            throw new ApiDeprecatedException(plan.getApiId());
        }
        if (api.getApiDefinitionV4().getListeners() != null) {
            this.planValidatorDomainService.validatePlanSecurityAgainstEntrypoints(plan.getPlanSecurity(), api.getApiDefinitionV4().getListeners().stream().map(Listener::getType).toList());
        }
        this.planValidatorDomainService.validatePlanSecurity(plan, auditInfo.organizationId(), auditInfo.environmentId());
        this.planValidatorDomainService.validatePlanTagsAgainstApiTags(plan.getPlanDefinitionV4().getTags(), api.getTags());
        this.planValidatorDomainService.validateGeneralConditionsPageStatus(plan);
        List<Flow> sanitizedFlows = this.flowValidationDomainService.validateAndSanitize(api.getType(), flows);
        this.flowValidationDomainService.validatePathParameters(api.getType(), api.getApiDefinitionV4().getFlows() != null ? api.getApiDefinitionV4().getFlows().stream() : Stream.empty(), sanitizedFlows.stream());
        Plan createdPlan = this.planCrudService.create((Plan)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)plan.toBuilder().id(plan.getId() != null ? plan.getId() : UuidString.generateRandom())).apiId(api.getId())).createdAt(TimeProvider.now())).updatedAt(TimeProvider.now())).needRedeployAt(Date.from(TimeProvider.instantNow()))).publishedAt(plan.isPublished() ? TimeProvider.now() : null)).build());
        List<Flow> createdFlows = this.flowCrudService.savePlanFlows(createdPlan.getId(), sanitizedFlows);
        this.createAuditLog(createdPlan, auditInfo);
        return this.toPlanWithFlows(createdPlan, createdFlows);
    }

    private PlanWithFlows createFederatedApiPlan(Plan plan, AuditInfo auditInfo) {
        Plan createdPlan = this.planCrudService.create(plan);
        this.createAuditLog(createdPlan, auditInfo);
        return this.toPlanWithFlows(plan, Collections.emptyList());
    }

    private void createAuditLog(Plan createdPlan, AuditInfo auditInfo) {
        this.auditService.createApiAuditLog(ApiAuditLogEntity.builder().organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).apiId(createdPlan.getApiId()).event(PlanAuditEvent.PLAN_CREATED).actor(auditInfo.actor()).newValue(createdPlan).createdAt(createdPlan.getCreatedAt()).properties(Map.of(AuditProperties.PLAN, createdPlan.getId())).build());
    }

    private PlanWithFlows toPlanWithFlows(Plan plan, List<Flow> flows) {
        return ((PlanWithFlows.PlanWithFlowsBuilder)((PlanWithFlows.PlanWithFlowsBuilder)((PlanWithFlows.PlanWithFlowsBuilder)((PlanWithFlows.PlanWithFlowsBuilder)((PlanWithFlows.PlanWithFlowsBuilder)((PlanWithFlows.PlanWithFlowsBuilder)((PlanWithFlows.PlanWithFlowsBuilder)((PlanWithFlows.PlanWithFlowsBuilder)((PlanWithFlows.PlanWithFlowsBuilder)((PlanWithFlows.PlanWithFlowsBuilder)((PlanWithFlows.PlanWithFlowsBuilder)((PlanWithFlows.PlanWithFlowsBuilder)((PlanWithFlows.PlanWithFlowsBuilder)((PlanWithFlows.PlanWithFlowsBuilder)((PlanWithFlows.PlanWithFlowsBuilder)((PlanWithFlows.PlanWithFlowsBuilder)((PlanWithFlows.PlanWithFlowsBuilder)((PlanWithFlows.PlanWithFlowsBuilder)((PlanWithFlows.PlanWithFlowsBuilder)((PlanWithFlows.PlanWithFlowsBuilder)((Plan.PlanBuilder)PlanWithFlows.builder().flows(flows)).id(plan.getId())).crossId(plan.getCrossId())).name(plan.getName())).description(plan.getDescription())).createdAt(plan.getCreatedAt())).updatedAt(plan.getUpdatedAt())).publishedAt(plan.getPublishedAt())).closedAt(plan.getClosedAt())).needRedeployAt(plan.getNeedRedeployAt())).validation(plan.getValidation())).type(plan.getType())).planDefinitionV4(plan.getPlanDefinitionV4())).planDefinitionV2(plan.getPlanDefinitionV2())).apiId(plan.getApiId())).order(plan.getOrder())).characteristics(plan.getCharacteristics())).excludedGroups(plan.getExcludedGroups())).commentRequired(plan.isCommentRequired())).commentMessage(plan.getCommentMessage())).generalConditions(plan.getGeneralConditions())).build();
    }
}

