/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.search.lucene.transformer;

import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.search.Indexable;
import io.gravitee.rest.api.service.impl.search.lucene.DocumentTransformer;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.TokenizerFactory;
import org.apache.lucene.analysis.core.LowerCaseFilterFactory;
import org.apache.lucene.analysis.custom.CustomAnalyzer;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilterFactory;
import org.apache.lucene.analysis.util.CharTokenizer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.AttributeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserDocumentTransformer
implements DocumentTransformer<UserEntity> {
    private static final String FIELD_ID = "id";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_TYPE_VALUE = "user";
    private static final String FIELD_DISPLAYNAME = "displayname";
    private static final String FIELD_DISPLAYNAME_REVERTED = "displayname_reverted";
    private static final String FIELD_EMAIL = "email";
    private static final String FIELD_SOURCE = "source";
    private static final String FIELD_REFERENCE = "reference";
    private static final String FIELD_CUSTOM = "custom";
    private static final String FIELD_CUSTOM_SPLIT = "custom_split";
    private final Logger logger = LoggerFactory.getLogger(UserDocumentTransformer.class);
    @Autowired
    private Analyzer defaultAnalyzer;

    private Analyzer userFieldAnalyzer() {
        try {
            return CustomAnalyzer.builder().withTokenizer(SingleTokenTokenizerFactory.class, new String[0]).addTokenFilter(LowerCaseFilterFactory.class, new String[0]).addTokenFilter(ASCIIFoldingFilterFactory.class, new String[0]).build();
        }
        catch (IOException e) {
            return this.defaultAnalyzer;
        }
    }

    @Override
    public Document transform(UserEntity user) {
        Document doc = new Document();
        doc.add((IndexableField)new StringField(FIELD_ID, user.getId(), Field.Store.YES));
        doc.add((IndexableField)new StringField(FIELD_TYPE, FIELD_TYPE_VALUE, Field.Store.YES));
        if (user.getReferenceId() != null) {
            doc.add((IndexableField)new StringField("reference_type", user.getReferenceType(), Field.Store.NO));
            doc.add((IndexableField)new StringField("reference_id", user.getReferenceId(), Field.Store.NO));
        }
        if (user.getSource() != null) {
            doc.add((IndexableField)new StringField(FIELD_SOURCE, user.getSource(), Field.Store.NO));
        }
        if (user.getSourceId() != null) {
            String sourceId = user.getSourceId().contains("@") ? user.getSourceId().substring(0, user.getSourceId().indexOf(64)) : user.getSourceId();
            doc.add((IndexableField)new StringField(FIELD_REFERENCE, sourceId, Field.Store.NO));
        }
        if (user.getDisplayName() != null) {
            TextField displayName = new TextField(FIELD_DISPLAYNAME, this.toLowerCaseAndStripAccents(user.getDisplayName()), Field.Store.NO);
            displayName.setTokenStream(this.userFieldAnalyzer().tokenStream(FIELD_DISPLAYNAME, this.toLowerCaseAndStripAccents(user.getDisplayName())));
            doc.add((IndexableField)displayName);
            if (!StringUtils.isEmpty((CharSequence)user.getLastname()) && !StringUtils.isEmpty((CharSequence)user.getFirstname())) {
                String reverted = this.toLowerCaseAndStripAccents(String.format("%s %s", user.getLastname(), user.getFirstname()));
                TextField displayNameReverted = new TextField(FIELD_DISPLAYNAME_REVERTED, reverted, Field.Store.NO);
                displayNameReverted.setTokenStream(this.userFieldAnalyzer().tokenStream(FIELD_DISPLAYNAME_REVERTED, reverted));
                doc.add((IndexableField)displayNameReverted);
            }
        }
        if (user.getEmail() != null && user.getEmail().length() > 0) {
            if (user.getEmail().indexOf(64) < 0) {
                this.logger.warn("Email of the user {} is not valid", (Object)user.getId());
            } else {
                doc.add((IndexableField)new StringField(FIELD_EMAIL, user.getEmail().substring(0, user.getEmail().indexOf(64)).toLowerCase(), Field.Store.NO));
            }
        }
        if (user.getCustomFields() != null && !user.getCustomFields().isEmpty()) {
            user.getCustomFields().values().stream().filter(Objects::nonNull).map(Object::toString).filter(Predicate.not(String::isEmpty).and(value -> !value.startsWith("data:"))).forEach(customValue -> {
                doc.add((IndexableField)new StringField(FIELD_CUSTOM, this.toLowerCaseAndStripAccents((String)customValue), Field.Store.NO));
                doc.add((IndexableField)new TextField(FIELD_CUSTOM_SPLIT, this.toLowerCaseAndStripAccents((String)customValue), Field.Store.NO));
            });
        }
        return doc;
    }

    @Override
    public boolean handle(Class<? extends Indexable> source) {
        return UserEntity.class.isAssignableFrom(source);
    }

    private String toLowerCaseAndStripAccents(String toTransform) {
        if (!StringUtils.isEmpty((CharSequence)toTransform)) {
            return StringUtils.stripAccents((String)toTransform.toLowerCase());
        }
        return toTransform;
    }

    public static class SingleTokenTokenizerFactory
    extends TokenizerFactory {
        public SingleTokenTokenizerFactory(Map<String, String> args) {
            super(args);
        }

        public Tokenizer create(AttributeFactory attributeFactory) {
            return new CharTokenizer(){

                protected boolean isTokenChar(int i) {
                    return true;
                }
            };
        }
    }
}

