/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.command.handler;

import io.gravitee.cockpit.api.command.v1.CockpitCommandType;
import io.gravitee.cockpit.api.command.v1.installation.InstallationCommand;
import io.gravitee.cockpit.api.command.v1.installation.InstallationCommandPayload;
import io.gravitee.cockpit.api.command.v1.installation.InstallationReply;
import io.gravitee.exchange.api.command.CommandHandler;
import io.gravitee.rest.api.service.InstallationService;
import io.reactivex.rxjava3.core.Single;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class InstallationCommandHandler
implements CommandHandler<InstallationCommand, InstallationReply> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InstallationCommandHandler.class);
    private final InstallationService installationService;

    public String supportType() {
        return CockpitCommandType.INSTALLATION.name();
    }

    public Single<InstallationReply> handle(InstallationCommand command) {
        InstallationCommandPayload installationPayload = (InstallationCommandPayload)command.getPayload();
        Map additionalInformation = this.installationService.getOrInitialize().getAdditionalInformation();
        additionalInformation.put("COCKPIT_INSTALLATION_STATUS", installationPayload.status());
        try {
            this.installationService.setAdditionalInformation(additionalInformation);
            log.info("Installation status is [{}].", (Object)installationPayload.status());
            return Single.just((Object)new InstallationReply(command.getId()));
        }
        catch (Exception ex) {
            String errorDetails = "Error occurred when updating installation status.";
            log.info(errorDetails, (Throwable)ex);
            return Single.just((Object)new InstallationReply(command.getId(), errorDetails));
        }
    }

    @Generated
    public InstallationCommandHandler(InstallationService installationService) {
        this.installationService = installationService;
    }
}

