/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.domain_service.api;

import io.gravitee.apim.core.api.domain_service.OAIDomainService;
import io.gravitee.apim.core.api.model.import_definition.ImportDefinition;
import io.gravitee.apim.infra.converter.oai.OAIToImportDefinitionConverter;
import io.gravitee.rest.api.model.ImportSwaggerDescriptorEntity;
import io.gravitee.rest.api.service.exceptions.SwaggerDescriptorException;
import io.gravitee.rest.api.service.impl.swagger.parser.OAIParser;
import io.gravitee.rest.api.service.impl.swagger.policy.PolicyOperationVisitorManager;
import io.gravitee.rest.api.service.impl.swagger.visitor.v3.OAIOperationVisitor;
import io.gravitee.rest.api.service.swagger.OAIDescriptor;
import io.swagger.v3.parser.core.models.ParseOptions;
import java.util.Collection;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class OAIDomainServiceImpl
implements OAIDomainService {
    private final PolicyOperationVisitorManager policyOperationVisitorManager;

    @Override
    public ImportDefinition convert(String organizationId, String environmentId, ImportSwaggerDescriptorEntity importSwaggerDescriptor) {
        OAIDescriptor descriptor = this.toOAIDescriptor(importSwaggerDescriptor.getPayload());
        Collection<? extends OAIOperationVisitor> visitors = this.getVisitors(importSwaggerDescriptor);
        return OAIToImportDefinitionConverter.INSTANCE.toImportDefinition(descriptor.getSpecification(), visitors);
    }

    private OAIDescriptor toOAIDescriptor(String payload) {
        ParseOptions options = new ParseOptions();
        options.setResolveFully(true);
        if (payload == null || payload.isEmpty()) {
            throw new SwaggerDescriptorException("Payload cannot be null");
        }
        OAIDescriptor descriptor = new OAIParser().parse(payload, options);
        if (descriptor == null || descriptor.getSpecification() == null) {
            throw new SwaggerDescriptorException("The API specification is not valid");
        }
        if (descriptor.getSpecification().getInfo() == null) {
            throw new SwaggerDescriptorException("The API specification must contain an info section");
        }
        return descriptor;
    }

    private Collection<? extends OAIOperationVisitor> getVisitors(ImportSwaggerDescriptorEntity importSwaggerDescriptor) {
        return this.policyOperationVisitorManager.getPolicyVisitors().stream().filter(operationVisitor -> importSwaggerDescriptor.getWithPolicies() != null && importSwaggerDescriptor.getWithPolicies().contains(operationVisitor.getId())).map(operationVisitor -> this.policyOperationVisitorManager.getOAIOperationVisitor(operationVisitor.getId())).collect(Collectors.toList());
    }

    @Generated
    public OAIDomainServiceImpl(PolicyOperationVisitorManager policyOperationVisitorManager) {
        this.policyOperationVisitorManager = policyOperationVisitorManager;
    }
}

