/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.crud_service.theme;

import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.apim.core.theme.crud_service.ThemeCrudService;
import io.gravitee.apim.core.theme.exception.ThemeNotFoundException;
import io.gravitee.apim.infra.adapter.ThemeAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ThemeRepository;
import io.gravitee.repository.management.model.Theme;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ThemeCrudServiceImpl
implements ThemeCrudService {
    private final ThemeRepository themeRepository;

    public ThemeCrudServiceImpl(@Lazy ThemeRepository themeRepository) {
        this.themeRepository = themeRepository;
    }

    @Override
    public io.gravitee.apim.core.theme.model.Theme create(io.gravitee.apim.core.theme.model.Theme theme) {
        try {
            Theme createdTheme = (Theme)this.themeRepository.create((Object)ThemeAdapter.INSTANCE.map(theme));
            return ThemeAdapter.INSTANCE.map(createdTheme);
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException("Error during theme creation", e);
        }
    }

    @Override
    public io.gravitee.apim.core.theme.model.Theme update(io.gravitee.apim.core.theme.model.Theme theme) {
        try {
            Theme updatedTheme = (Theme)this.themeRepository.update((Object)ThemeAdapter.INSTANCE.map(theme));
            return ThemeAdapter.INSTANCE.map(updatedTheme);
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException("Error during theme update", e);
        }
    }

    @Override
    public io.gravitee.apim.core.theme.model.Theme get(String id) {
        try {
            return this.themeRepository.findById((Object)id).map(ThemeAdapter.INSTANCE::map).orElseThrow(() -> new ThemeNotFoundException(id));
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException("Error during get", e);
        }
    }
}

