/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.theme.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.parameters.domain_service.ParametersDomainService;
import io.gravitee.apim.core.theme.domain_service.ThemeDomainService;
import io.gravitee.apim.core.theme.domain_service.ThemePortalNextAssetsDomainService;
import io.gravitee.apim.core.theme.domain_service.ThemeServiceLegacyWrapper;
import io.gravitee.apim.core.theme.exception.ThemeTypeNotSupportedException;
import io.gravitee.apim.core.theme.model.NewTheme;
import io.gravitee.apim.core.theme.model.Theme;
import io.gravitee.apim.core.theme.model.ThemeType;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.theme.portalnext.ThemeDefinition;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;

@DomainService
public class DefaultThemeDomainService {
    private final ParametersDomainService parametersDomainService;
    private final ThemeDomainService themeDomainService;
    private final ThemeServiceLegacyWrapper themeServiceLegacyWrapper;
    private final ThemePortalNextAssetsDomainService themePortalNextAssetsDomainService;
    private static final List<Key> PORTAL_NEXT_THEME_KEYS = List.of(Key.PORTAL_NEXT_THEME_COLOR_PRIMARY, Key.PORTAL_NEXT_THEME_COLOR_SECONDARY, Key.PORTAL_NEXT_THEME_COLOR_TERTIARY, Key.PORTAL_NEXT_THEME_COLOR_ERROR, Key.PORTAL_NEXT_THEME_COLOR_BACKGROUND_PAGE, Key.PORTAL_NEXT_THEME_COLOR_BACKGROUND_CARD, Key.PORTAL_NEXT_THEME_CUSTOM_CSS, Key.PORTAL_NEXT_THEME_FONT_FAMILY);

    public Theme getDefaultTheme(ThemeType themeType, ExecutionContext executionContext) {
        if (Objects.requireNonNull(themeType) == ThemeType.PORTAL_NEXT) {
            return this.getPortalNextDefaultTheme(executionContext);
        }
        throw new ThemeTypeNotSupportedException(themeType.name());
    }

    public Theme createAndEnableDefaultTheme(ThemeType themeType, ExecutionContext executionContext) {
        if (ThemeType.PORTAL_NEXT.equals((Object)themeType)) {
            Theme defaultTheme = this.getDefaultTheme(themeType, executionContext);
            return this.themeDomainService.create(NewTheme.builder().referenceId(defaultTheme.getReferenceId()).referenceType(defaultTheme.getReferenceType()).name(defaultTheme.getName()).definitionPortalNext(defaultTheme.getDefinitionPortalNext()).type(ThemeType.PORTAL_NEXT).enabled(true).logo(defaultTheme.getLogo()).favicon(defaultTheme.getFavicon()).build());
        }
        if (ThemeType.PORTAL.equals((Object)themeType)) {
            return this.themeServiceLegacyWrapper.getCurrentOrCreateDefaultPortalTheme(executionContext);
        }
        throw new ThemeTypeNotSupportedException(themeType.name());
    }

    private Theme getPortalNextDefaultTheme(ExecutionContext executionContext) {
        Map<Key, String> parameters = this.parametersDomainService.getEnvironmentParameters(executionContext, PORTAL_NEXT_THEME_KEYS);
        return Theme.builder().type(ThemeType.PORTAL_NEXT).name("Default Portal Next Theme").referenceId(executionContext.getEnvironmentId()).referenceType(Theme.ReferenceType.ENVIRONMENT).logo(this.themePortalNextAssetsDomainService.getPortalNextLogo()).favicon(this.themePortalNextAssetsDomainService.getPortalNextFavicon()).definitionPortalNext(ThemeDefinition.builder().color(ThemeDefinition.Color.builder().primary(parameters.get(Key.PORTAL_NEXT_THEME_COLOR_PRIMARY)).secondary(parameters.get(Key.PORTAL_NEXT_THEME_COLOR_SECONDARY)).tertiary(parameters.get(Key.PORTAL_NEXT_THEME_COLOR_TERTIARY)).error(parameters.get(Key.PORTAL_NEXT_THEME_COLOR_ERROR)).background(ThemeDefinition.Background.builder().card(parameters.get(Key.PORTAL_NEXT_THEME_COLOR_BACKGROUND_CARD)).page(parameters.get(Key.PORTAL_NEXT_THEME_COLOR_BACKGROUND_PAGE)).build()).build()).customCss(parameters.get(Key.PORTAL_NEXT_THEME_CUSTOM_CSS)).font(ThemeDefinition.Font.builder().fontFamily(parameters.get(Key.PORTAL_NEXT_THEME_FONT_FAMILY)).build()).build()).build();
    }

    @Generated
    public DefaultThemeDomainService(ParametersDomainService parametersDomainService, ThemeDomainService themeDomainService, ThemeServiceLegacyWrapper themeServiceLegacyWrapper, ThemePortalNextAssetsDomainService themePortalNextAssetsDomainService) {
        this.parametersDomainService = parametersDomainService;
        this.themeDomainService = themeDomainService;
        this.themeServiceLegacyWrapper = themeServiceLegacyWrapper;
        this.themePortalNextAssetsDomainService = themePortalNextAssetsDomainService;
    }
}

