/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.domain_service.UpdateApiDomainService;
import io.gravitee.apim.core.audit.domain_service.AuditDomainService;
import io.gravitee.apim.core.audit.model.ApiAuditLogEntity;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.event.ApiAuditEvent;
import io.gravitee.apim.core.event.query_service.EventQueryService;
import io.gravitee.apim.core.plan.domain_service.ClosePlanDomainService;
import io.gravitee.apim.core.plan.domain_service.CreatePlanDomainService;
import io.gravitee.apim.core.plan.domain_service.UpdatePlanDomainService;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.apim.core.plan.query_service.PlanQueryService;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.Api;
import io.gravitee.definition.model.v4.plan.PlanStatus;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;

@UseCase
public class RollbackApiUseCase {
    private final EventQueryService eventQueryService;
    private final ApiCrudService apiCrudService;
    private final UpdateApiDomainService updateApiDomainService;
    private final PlanQueryService planQueryService;
    private final CreatePlanDomainService createPlanDomainService;
    private final UpdatePlanDomainService updatePlanDomainService;
    private final ClosePlanDomainService closePlanDomainService;
    private final AuditDomainService auditService;

    public void execute(Input input) {
        io.gravitee.apim.core.api.model.Api api = this.eventQueryService.findApiFromPublishApiEvent(input.eventId).orElseThrow(() -> new IllegalStateException("Cannot rollback an event that is not a publish event!"));
        this.ensureApiDefinitionVersionForRollback(api, input.eventId());
        Api apiDefinition = api.getApiDefinitionV4();
        io.gravitee.apim.core.api.model.Api toRollback = this.apiCrudService.get(apiDefinition.getId());
        io.gravitee.apim.core.api.model.Api rollbackedApi = toRollback.rollbackTo(apiDefinition);
        rollbackedApi.setDescription(api.getDescription());
        io.gravitee.apim.core.api.model.Api apiUpdated = this.updateApiDomainService.updateV4(rollbackedApi, input.auditInfo);
        this.rollbackPlansV4(apiDefinition.getPlans(), apiUpdated, input.auditInfo);
        this.createAuditLog(input.auditInfo, apiUpdated.getId(), apiUpdated.getUpdatedAt());
    }

    private void ensureApiDefinitionVersionForRollback(io.gravitee.apim.core.api.model.Api api, String eventId) {
        if (api.getDefinitionVersion() == null) {
            throw new IllegalStateException("Cannot determine API definition version from event" + eventId);
        }
        if (api.getDefinitionVersion().equals((Object)DefinitionVersion.FEDERATED)) {
            throw new IllegalStateException("Cannot rollback a federated API");
        }
        if (!api.getDefinitionVersion().equals((Object)DefinitionVersion.V4)) {
            throw new IllegalStateException("Cannot rollback an API that is not a V4 API");
        }
    }

    private void rollbackPlansV4(List<io.gravitee.definition.model.v4.plan.Plan> apiDefinitionPlans, io.gravitee.apim.core.api.model.Api api, AuditInfo auditInfo) {
        if (apiDefinitionPlans == null) {
            return;
        }
        HashSet<Plan> plansToAdd = new HashSet<Plan>();
        HashSet<Plan> plansToUpdate = new HashSet<Plan>();
        Map existingPlans = this.planQueryService.findAllByApiId(api.getId()).stream().collect(Collectors.toMap(Plan::getId, Function.identity()));
        for (io.gravitee.definition.model.v4.plan.Plan apiDefinitionPlan : apiDefinitionPlans) {
            Plan existingPlan2;
            Plan plan = existingPlan2 = apiDefinitionPlan.getId() != null ? (Plan)existingPlans.get(apiDefinitionPlan.getId()) : null;
            if (existingPlan2 == null) {
                plansToAdd.add(new Plan(api.getId(), apiDefinitionPlan));
                continue;
            }
            plansToUpdate.add(existingPlan2.rollbackTo(apiDefinitionPlan));
        }
        plansToAdd.forEach(planToAdd -> this.createPlanDomainService.create((Plan)planToAdd, planToAdd.getPlanDefinitionV4().getFlows() == null ? List.of() : planToAdd.getPlanDefinitionV4().getFlows(), api, auditInfo));
        Map existingPlanStatuses = Map.of();
        plansToUpdate.forEach(planToUpdate -> this.updatePlanDomainService.update((Plan)planToUpdate, planToUpdate.getPlanDefinitionV4().getFlows() == null ? List.of() : planToUpdate.getPlanDefinitionV4().getFlows(), existingPlanStatuses, api, auditInfo));
        existingPlans.values().stream().filter(existingPlan -> existingPlan.getPlanStatus() != PlanStatus.CLOSED && !plansToUpdate.stream().map(Plan::getId).collect(Collectors.toSet()).contains(existingPlan.getId())).forEach(existingPlan -> this.closePlanDomainService.close(existingPlan.getId(), auditInfo));
    }

    private void createAuditLog(AuditInfo auditInfo, String apiId, ZonedDateTime auditCreatedAt) {
        this.auditService.createApiAuditLog(ApiAuditLogEntity.builder().organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).apiId(apiId).event(ApiAuditEvent.API_ROLLBACKED).actor(auditInfo.actor()).createdAt(auditCreatedAt).properties(Collections.emptyMap()).build());
    }

    @Generated
    public RollbackApiUseCase(EventQueryService eventQueryService, ApiCrudService apiCrudService, UpdateApiDomainService updateApiDomainService, PlanQueryService planQueryService, CreatePlanDomainService createPlanDomainService, UpdatePlanDomainService updatePlanDomainService, ClosePlanDomainService closePlanDomainService, AuditDomainService auditService) {
        this.eventQueryService = eventQueryService;
        this.apiCrudService = apiCrudService;
        this.updateApiDomainService = updateApiDomainService;
        this.planQueryService = planQueryService;
        this.createPlanDomainService = createPlanDomainService;
        this.updatePlanDomainService = updatePlanDomainService;
        this.closePlanDomainService = closePlanDomainService;
        this.auditService = auditService;
    }

    public record Input(String eventId, AuditInfo auditInfo) {
    }
}

