/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.upgrader;

import io.gravitee.node.api.upgrader.Upgrader;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiCategoryOrderRepository;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.CategoryRepository;
import io.gravitee.repository.management.api.search.ApiCriteria;
import io.gravitee.repository.management.api.search.ApiFieldFilter;
import io.gravitee.repository.management.model.ApiCategoryOrder;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ApiCategoryOrderUpgrader
implements Upgrader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiCategoryOrderUpgrader.class);
    private final ApiRepository apiRepository;
    private final CategoryRepository categoryRepository;
    private final ApiCategoryOrderRepository apiCategoryOrderRepository;

    @Autowired
    public ApiCategoryOrderUpgrader(@Lazy ApiRepository apiRepository, @Lazy CategoryRepository categoryRepository, @Lazy ApiCategoryOrderRepository apiCategoryOrderRepository) {
        this.apiRepository = apiRepository;
        this.categoryRepository = categoryRepository;
        this.apiCategoryOrderRepository = apiCategoryOrderRepository;
    }

    public int getOrder() {
        return 702;
    }

    public boolean upgrade() {
        try {
            this.fillApiCategoryOrderTable();
        }
        catch (Exception e) {
            log.error("error occurred while applying upgrader {}", (Object)this.getClass().getSimpleName());
            return false;
        }
        return true;
    }

    private void fillApiCategoryOrderTable() throws TechnicalException {
        this.categoryRepository.findAll().forEach(category -> {
            AtomicInteger order = new AtomicInteger(0);
            this.apiRepository.search(new ApiCriteria.Builder().category(category.getId()).build(), ApiFieldFilter.defaultFields()).forEach(api -> {
                try {
                    this.apiCategoryOrderRepository.create(ApiCategoryOrder.builder().apiId(api.getId()).categoryId(category.getId()).order(order.getAndIncrement()).build());
                }
                catch (TechnicalException e) {
                    log.error("Unable to create api category order for API [{}] and Category [{}]", new Object[]{api.getId(), category.getId(), e});
                    throw new RuntimeException(e);
                }
            });
        });
    }
}

