/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.configuration.identity;

import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.IdentityProviderActivationRepository;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.IdentityProvider;
import io.gravitee.repository.management.model.IdentityProviderActivation;
import io.gravitee.rest.api.model.configuration.identity.IdentityProviderActivationEntity;
import io.gravitee.rest.api.model.configuration.identity.IdentityProviderActivationReferenceType;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.configuration.identity.IdentityProviderActivationService;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.impl.configuration.identity.IdentityProviderActivationNotFoundException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class IdentityProviderActivationServiceImpl
extends AbstractService
implements IdentityProviderActivationService {
    private final Logger LOGGER = LoggerFactory.getLogger(IdentityProviderActivationServiceImpl.class);
    @Lazy
    @Autowired
    private IdentityProviderActivationRepository identityProviderActivationRepository;
    @Autowired
    private AuditService auditService;

    @Override
    public Set<IdentityProviderActivationEntity> activateIdpOnTargets(ExecutionContext executionContext, String identityProviderId, IdentityProviderActivationService.ActivationTarget ... targetsToAdd) {
        this.LOGGER.debug("Activate identity provider {} on targets {} ", (Object)identityProviderId, (Object)targetsToAdd);
        try {
            HashSet<IdentityProviderActivationEntity> createdActivations = new HashSet<IdentityProviderActivationEntity>();
            for (IdentityProviderActivationService.ActivationTarget target : targetsToAdd) {
                IdentityProviderActivation createdIdentityProviderActivation = this.createIdentityProviderActivation(executionContext, identityProviderId, target);
                createdActivations.add(this.convert(createdIdentityProviderActivation));
            }
            return createdActivations;
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to Activate identity provider {} on targets {}", new Object[]{identityProviderId, targetsToAdd, ex});
            throw new TechnicalManagementException("An error occurs while trying to Activate identity provider " + identityProviderId + " on targets " + Arrays.toString(targetsToAdd), ex);
        }
    }

    @Override
    public Set<IdentityProviderActivationEntity> addIdpsOnTarget(ExecutionContext executionContext, IdentityProviderActivationService.ActivationTarget target, String ... identityProviderIdsToAdd) {
        this.LOGGER.debug("Add identity providers {} on target {} ", (Object)identityProviderIdsToAdd, (Object)target);
        try {
            HashSet<IdentityProviderActivationEntity> createdActivations = new HashSet<IdentityProviderActivationEntity>();
            for (String identityProviderId : identityProviderIdsToAdd) {
                IdentityProviderActivation createdIdentityProviderActivation = this.createIdentityProviderActivation(executionContext, identityProviderId, target);
                createdActivations.add(this.convert(createdIdentityProviderActivation));
            }
            return createdActivations;
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to add identity providers {} on target {}", new Object[]{identityProviderIdsToAdd, target, ex});
            throw new TechnicalManagementException("An error occurs while trying to add identity providers " + Arrays.toString(identityProviderIdsToAdd) + " on target " + target, ex);
        }
    }

    @Override
    public Set<IdentityProviderActivationEntity> findAllByIdentityProviderId(String identityProviderId) {
        this.LOGGER.debug("Find all activations for identity provider {}", (Object)identityProviderId);
        try {
            return this.identityProviderActivationRepository.findAllByIdentityProviderId(identityProviderId).stream().map(this::convert).collect(Collectors.toSet());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find all activations for identity provider {}", (Object)identityProviderId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find all activations for identity provider " + identityProviderId, ex);
        }
    }

    @Override
    public Set<IdentityProviderActivationEntity> findAllByTarget(IdentityProviderActivationService.ActivationTarget target) {
        this.LOGGER.debug("Find all activations for target {}", (Object)target);
        try {
            return this.identityProviderActivationRepository.findAllByReferenceIdAndReferenceType(target.getReferenceId(), this.convert(target.getReferenceType())).stream().map(this::convert).collect(Collectors.toSet());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find all activations for target {}", (Object)target, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find all activations for target " + target, ex);
        }
    }

    @Override
    public void deactivateIdpOnTargets(ExecutionContext executionContext, String identityProviderId, IdentityProviderActivationService.ActivationTarget ... targetsToRemove) {
        this.LOGGER.debug("Deactivate identity provider {} on targets {} ", (Object)identityProviderId, (Object)targetsToRemove);
        try {
            for (IdentityProviderActivationService.ActivationTarget target : targetsToRemove) {
                this.deleteIdentityProviderActivation(executionContext, identityProviderId, target);
            }
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to deactivate identity provider {} on targets {}", new Object[]{identityProviderId, targetsToRemove, ex});
            throw new TechnicalManagementException("An error occurs while trying to deactivate identity provider " + identityProviderId + " on targets " + Arrays.toString(targetsToRemove), ex);
        }
    }

    @Override
    public void removeIdpsFromTarget(ExecutionContext executionContext, IdentityProviderActivationService.ActivationTarget target, String ... identityProviderIdsToRemove) {
        this.LOGGER.debug("Remove identity providers {} from target {} ", (Object)identityProviderIdsToRemove, (Object)target);
        try {
            for (String identityProviderId : identityProviderIdsToRemove) {
                this.deleteIdentityProviderActivation(executionContext, identityProviderId, target);
            }
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to remove identity providers {} from target {}", new Object[]{identityProviderIdsToRemove, target, ex});
            throw new TechnicalManagementException("An error occurs while trying to remove identity providers " + Arrays.toString(identityProviderIdsToRemove) + " from target " + target, ex);
        }
    }

    @Override
    public void deactivateIdpOnAllTargets(ExecutionContext executionContext, String identityProviderId) {
        this.LOGGER.debug("Deactivate identity provider {} on all targets", (Object)identityProviderId);
        try {
            Set iPAsToRemove = this.identityProviderActivationRepository.findAllByIdentityProviderId(identityProviderId);
            this.identityProviderActivationRepository.deleteByIdentityProviderId(identityProviderId);
            for (IdentityProviderActivation ipa : iPAsToRemove) {
                this.auditService.createAuditLog(executionContext, Audit.AuditReferenceType.valueOf((String)ipa.getReferenceType().name()), ipa.getReferenceId(), Collections.singletonMap(Audit.AuditProperties.IDENTITY_PROVIDER, ipa.getIdentityProviderId()), (Audit.AuditEvent)IdentityProvider.AuditEvent.IDENTITY_PROVIDER_DEACTIVATED, new Date(), ipa, null);
            }
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to deactivate identity provider {} on all targets", (Object)identityProviderId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to deactivate identity provider " + identityProviderId + " on all targets", ex);
        }
    }

    @Override
    public void removeAllIdpsFromTarget(ExecutionContext executionContext, IdentityProviderActivationService.ActivationTarget target) {
        this.LOGGER.debug("Remove all identity providers from target {} ", (Object)target);
        try {
            Set iPAsToRemove = this.identityProviderActivationRepository.findAllByReferenceIdAndReferenceType(target.getReferenceId(), this.convert(target.getReferenceType()));
            this.identityProviderActivationRepository.deleteByReferenceIdAndReferenceType(target.getReferenceId(), this.convert(target.getReferenceType()));
            for (IdentityProviderActivation ipa : iPAsToRemove) {
                this.auditService.createAuditLog(executionContext, Audit.AuditReferenceType.valueOf((String)ipa.getReferenceType().name()), ipa.getReferenceId(), Collections.singletonMap(Audit.AuditProperties.IDENTITY_PROVIDER, ipa.getReferenceId()), (Audit.AuditEvent)IdentityProvider.AuditEvent.IDENTITY_PROVIDER_DEACTIVATED, new Date(), ipa, null);
            }
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to remove all identity providers from target {}", (Object)target, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to remove all identity providers from target " + target, ex);
        }
    }

    @Override
    public void updateTargetIdp(ExecutionContext executionContext, IdentityProviderActivationService.ActivationTarget target, List<String> identityProviderIds) {
        Set<IdentityProviderActivationEntity> allTargetActivations = this.findAllByTarget(target);
        allTargetActivations.forEach(ipa -> {
            if (!identityProviderIds.contains(ipa.getIdentityProvider())) {
                this.removeIdpsFromTarget(executionContext, target, ipa.getIdentityProvider());
            } else {
                identityProviderIds.remove(ipa.getIdentityProvider());
            }
        });
        if (!identityProviderIds.isEmpty()) {
            this.addIdpsOnTarget(executionContext, target, identityProviderIds.toArray(new String[identityProviderIds.size()]));
        }
    }

    @NotNull
    private IdentityProviderActivation createIdentityProviderActivation(ExecutionContext executionContext, String identityProviderId, IdentityProviderActivationService.ActivationTarget target) throws TechnicalException {
        IdentityProviderActivation createdIdentityProviderActivation = this.identityProviderActivationRepository.create(this.convert(identityProviderId, target, new Date()));
        this.auditService.createAuditLog(executionContext, Audit.AuditReferenceType.valueOf((String)target.getReferenceType().name()), target.getReferenceId(), Collections.singletonMap(Audit.AuditProperties.IDENTITY_PROVIDER, createdIdentityProviderActivation.getIdentityProviderId()), (Audit.AuditEvent)IdentityProvider.AuditEvent.IDENTITY_PROVIDER_ACTIVATED, createdIdentityProviderActivation.getCreatedAt(), null, createdIdentityProviderActivation);
        return createdIdentityProviderActivation;
    }

    private void deleteIdentityProviderActivation(ExecutionContext executionContext, String identityProviderId, IdentityProviderActivationService.ActivationTarget target) throws TechnicalException {
        Optional optIPAToRemove = this.identityProviderActivationRepository.findById(identityProviderId, target.getReferenceId(), this.convert(target.getReferenceType()));
        if (!optIPAToRemove.isPresent()) {
            throw new IdentityProviderActivationNotFoundException(identityProviderId, target.getReferenceId(), target.getReferenceType());
        }
        this.identityProviderActivationRepository.delete(identityProviderId, target.getReferenceId(), this.convert(target.getReferenceType()));
        this.auditService.createAuditLog(executionContext, Audit.AuditReferenceType.valueOf((String)target.getReferenceType().name()), target.getReferenceId(), Collections.singletonMap(Audit.AuditProperties.IDENTITY_PROVIDER, identityProviderId), (Audit.AuditEvent)IdentityProvider.AuditEvent.IDENTITY_PROVIDER_DEACTIVATED, new Date(), optIPAToRemove.get(), null);
    }

    private IdentityProviderActivation convert(String identityProviderId, IdentityProviderActivationService.ActivationTarget target, Date createdAt) {
        IdentityProviderActivation identityProviderActivation = new IdentityProviderActivation();
        identityProviderActivation.setIdentityProviderId(identityProviderId);
        identityProviderActivation.setReferenceId(target.getReferenceId());
        identityProviderActivation.setReferenceType(this.convert(target.getReferenceType()));
        identityProviderActivation.setCreatedAt(createdAt);
        return identityProviderActivation;
    }

    private IdentityProviderActivationEntity convert(IdentityProviderActivation identityProviderActivation) {
        IdentityProviderActivationEntity identityProviderActivationEntity = new IdentityProviderActivationEntity();
        identityProviderActivationEntity.setIdentityProvider(identityProviderActivation.getIdentityProviderId());
        identityProviderActivationEntity.setReferenceId(identityProviderActivation.getReferenceId());
        identityProviderActivationEntity.setReferenceType(this.convert(identityProviderActivation.getReferenceType()));
        identityProviderActivationEntity.setCreatedAt(identityProviderActivation.getCreatedAt());
        return identityProviderActivationEntity;
    }

    private io.gravitee.repository.management.model.IdentityProviderActivationReferenceType convert(IdentityProviderActivationReferenceType referenceType) {
        return io.gravitee.repository.management.model.IdentityProviderActivationReferenceType.valueOf((String)referenceType.name());
    }

    private IdentityProviderActivationReferenceType convert(io.gravitee.repository.management.model.IdentityProviderActivationReferenceType referenceType) {
        return IdentityProviderActivationReferenceType.valueOf((String)referenceType.name());
    }
}

