/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.query_service.async_job;

import io.gravitee.apim.core.async_job.model.AsyncJob;
import io.gravitee.apim.core.async_job.query_service.AsyncJobQueryService;
import io.gravitee.apim.infra.adapter.AsyncJobAdapter;
import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.AsyncJobRepository;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class AsyncJobQueryServiceImpl
extends AbstractService
implements AsyncJobQueryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncJobQueryServiceImpl.class);
    private final AsyncJobRepository asyncJobRepository;

    public AsyncJobQueryServiceImpl(@Lazy AsyncJobRepository asyncJobRepository) {
        this.asyncJobRepository = asyncJobRepository;
    }

    @Override
    public Optional<AsyncJob> findPendingJobFor(String sourceId) {
        try {
            return this.asyncJobRepository.findPendingJobFor(sourceId).map(AsyncJobAdapter.INSTANCE::toEntity);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("An error occurred while finding pending AsyncJob for: " + sourceId, e);
        }
    }

    @Override
    public Page<AsyncJob> listAsyncJobs(AsyncJobQueryService.ListQuery query, Pageable pageable) {
        try {
            return this.asyncJobRepository.search(this.toSearchCriteria(query), AsyncJobQueryServiceImpl.convert(pageable)).map(AsyncJobAdapter.INSTANCE::toEntity);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("An error occurred while searching AsyncJob with: " + query, e);
        }
    }

    private AsyncJobRepository.SearchCriteria toSearchCriteria(AsyncJobQueryService.ListQuery query) {
        return new AsyncJobRepository.SearchCriteria(query.environmentId(), query.initiatorId(), query.type().map(Enum::name), query.status().map(Enum::name), query.sourceId());
    }
}

