/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.domain_service.api;

import io.gravitee.apim.core.api.domain_service.CategoryDomainService;
import io.gravitee.apim.core.api.domain_service.ValidateApiDomainService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.flow.domain_service.FlowValidationDomainService;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.apim.infra.adapter.ApiAdapter;
import io.gravitee.apim.infra.adapter.PrimaryOwnerAdapter;
import io.gravitee.definition.model.v4.flow.Flow;
import io.gravitee.rest.api.model.v4.api.NewApiEntity;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.v4.validation.ApiValidationService;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ValidateApiDomainServiceLegacyWrapper
implements ValidateApiDomainService {
    private final ApiValidationService apiValidationService;
    private final CategoryDomainService categoryDomainService;
    private final FlowValidationDomainService flowValidationDomainService;

    public ValidateApiDomainServiceLegacyWrapper(ApiValidationService apiValidationService, CategoryDomainService categoryDomainService, FlowValidationDomainService flowValidationDomainService) {
        this.apiValidationService = apiValidationService;
        this.categoryDomainService = categoryDomainService;
        this.flowValidationDomainService = flowValidationDomainService;
    }

    @Override
    public Api validateAndSanitizeForCreation(Api api, PrimaryOwnerEntity primaryOwner, String environmentId, String organizationId) {
        NewApiEntity newApiEntity = ApiAdapter.INSTANCE.toNewApiEntity(api);
        this.apiValidationService.validateAndSanitizeNewApi(new ExecutionContext(organizationId, environmentId), newApiEntity, PrimaryOwnerAdapter.INSTANCE.toRestEntity(primaryOwner));
        this.apiValidationService.validateDynamicProperties(api.getApiDefinitionV4().getServices() != null ? api.getApiDefinitionV4().getServices().getDynamicProperty() : null);
        api.setName(newApiEntity.getName());
        api.setVersion(newApiEntity.getApiVersion());
        api.setType(newApiEntity.getType());
        api.setDescription(newApiEntity.getDescription());
        api.setGroups(newApiEntity.getGroups());
        api.setTag(newApiEntity.getTags());
        api.setCategories(this.categoryDomainService.toCategoryId(api, environmentId));
        api.getApiDefinitionV4().setListeners(newApiEntity.getListeners());
        api.getApiDefinitionV4().setEndpointGroups(newApiEntity.getEndpointGroups());
        api.getApiDefinitionV4().setAnalytics(newApiEntity.getAnalytics());
        api.getApiDefinitionV4().setFlowExecution(newApiEntity.getFlowExecution());
        List<Flow> sanitizedFlows = this.flowValidationDomainService.validateAndSanitize(api.getType(), newApiEntity.getFlows());
        api.getApiDefinitionV4().setFlows(sanitizedFlows);
        api.getApiDefinitionV4().setFailover(newApiEntity.getFailover());
        api.getApiDefinitionV4().setResources(this.apiValidationService.validateAndSanitize(api.getApiDefinitionV4().getResources()));
        return api;
    }
}

