/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.crud_service.async_job;

import io.gravitee.apim.core.async_job.crud_service.AsyncJobCrudService;
import io.gravitee.apim.infra.adapter.AsyncJobAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.AsyncJobRepository;
import io.gravitee.repository.management.model.AsyncJob;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.Optional;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class AsyncJobCrudServiceImpl
implements AsyncJobCrudService {
    private final AsyncJobRepository asyncJobRepository;

    public AsyncJobCrudServiceImpl(@Lazy AsyncJobRepository asyncJobRepository) {
        this.asyncJobRepository = asyncJobRepository;
    }

    @Override
    public io.gravitee.apim.core.async_job.model.AsyncJob create(io.gravitee.apim.core.async_job.model.AsyncJob job) {
        try {
            AsyncJob created = (AsyncJob)this.asyncJobRepository.create((Object)AsyncJobAdapter.INSTANCE.toRepository(job));
            return AsyncJobAdapter.INSTANCE.toEntity(created);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("Error when creating AsyncJob for integration: " + job.getSourceId(), e);
        }
    }

    @Override
    public Optional<io.gravitee.apim.core.async_job.model.AsyncJob> findById(String id) {
        try {
            return this.asyncJobRepository.findById((Object)id).map(AsyncJobAdapter.INSTANCE::toEntity);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("An error occurs while trying to find the AsyncJob: " + id, e);
        }
    }

    @Override
    public io.gravitee.apim.core.async_job.model.AsyncJob update(io.gravitee.apim.core.async_job.model.AsyncJob job) {
        try {
            AsyncJob updated = (AsyncJob)this.asyncJobRepository.update((Object)AsyncJobAdapter.INSTANCE.toRepository(job));
            return AsyncJobAdapter.INSTANCE.toEntity(updated);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("An error occurred when updating AsyncJob: " + job.getId(), e);
        }
    }

    @Override
    public void delete(String id) {
        try {
            this.asyncJobRepository.delete((Object)id);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("Error when deleting AsyncJob: " + id, e);
        }
    }
}

