/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.integration.model.Integration;
import io.gravitee.apim.core.integration.model.IntegrationApi;
import io.gravitee.apim.core.metadata.model.Metadata;
import io.gravitee.apim.infra.adapter.IntegrationAdapter;
import io.gravitee.integration.api.model.Api;
import io.gravitee.integration.api.model.Metadata;
import io.gravitee.integration.api.model.Page;
import io.gravitee.integration.api.model.PageType;
import io.gravitee.integration.api.model.Plan;
import io.gravitee.integration.api.model.PlanSecurityType;
import io.gravitee.repository.management.model.Integration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IntegrationAdapterImpl
implements IntegrationAdapter {
    @Override
    public Integration toEntity(io.gravitee.repository.management.model.Integration integration) {
        Set set;
        if (integration == null) {
            return null;
        }
        Integration.IntegrationBuilder<?, ?> integration1 = Integration.builder();
        integration1.id(integration.getId());
        integration1.name(integration.getName());
        integration1.description(integration.getDescription());
        integration1.provider(integration.getProvider());
        integration1.environmentId(integration.getEnvironmentId());
        if (integration.getCreatedAt() != null) {
            integration1.createdAt(ZonedDateTime.ofInstant(integration.getCreatedAt().toInstant(), ZoneId.systemDefault()));
        }
        if (integration.getUpdatedAt() != null) {
            integration1.updatedAt(ZonedDateTime.ofInstant(integration.getUpdatedAt().toInstant(), ZoneId.systemDefault()));
        }
        if ((set = integration.getGroups()) != null) {
            integration1.groups(new LinkedHashSet<String>(set));
        }
        return integration1.build();
    }

    @Override
    public io.gravitee.repository.management.model.Integration toRepository(Integration integration) {
        Set<String> set;
        if (integration == null) {
            return null;
        }
        Integration.IntegrationBuilder integration1 = io.gravitee.repository.management.model.Integration.builder();
        integration1.id(integration.getId());
        integration1.name(integration.getName());
        integration1.description(integration.getDescription());
        integration1.provider(integration.getProvider());
        integration1.environmentId(integration.getEnvironmentId());
        if (integration.getCreatedAt() != null) {
            integration1.createdAt(Date.from(integration.getCreatedAt().toInstant()));
        }
        if (integration.getUpdatedAt() != null) {
            integration1.updatedAt(Date.from(integration.getUpdatedAt().toInstant()));
        }
        if ((set = integration.getGroups()) != null) {
            integration1.groups(new LinkedHashSet<String>(set));
        }
        return integration1.build();
    }

    @Override
    public IntegrationApi map(Api source, String integrationId) {
        if (source == null && integrationId == null) {
            return null;
        }
        IntegrationApi.IntegrationApiBuilder integrationApi = IntegrationApi.builder();
        if (source != null) {
            integrationApi.uniqueId(source.getUniqueId());
            integrationApi.id(source.getId());
            integrationApi.name(source.getName());
            integrationApi.description(source.getDescription());
            integrationApi.version(source.getVersion());
            Map map = source.getConnectionDetails();
            if (map != null) {
                integrationApi.connectionDetails(new LinkedHashMap<String, String>(map));
            }
            integrationApi.plans(this.planListToPlanList(source.getPlans()));
            integrationApi.pages(this.pageListToPageList(source.getPages()));
            integrationApi.metadata(this.metadataListToMetadataCollection(source.getMetadata()));
        }
        integrationApi.integrationId(integrationId);
        return integrationApi.build();
    }

    @Override
    public IntegrationApi.Plan map(Plan source) {
        if (source == null) {
            return null;
        }
        IntegrationApi.PlanType type = null;
        String id = null;
        String name = null;
        String description = null;
        ArrayList<String> characteristics = null;
        type = this.map(source.planSecurityType());
        id = source.id();
        name = source.name();
        description = source.description();
        List list = source.characteristics();
        if (list != null) {
            characteristics = new ArrayList<String>(list);
        }
        IntegrationApi.Plan plan = new IntegrationApi.Plan(id, name, description, type, characteristics);
        return plan;
    }

    @Override
    public IntegrationApi.PlanType map(PlanSecurityType source) {
        if (source == null) {
            return null;
        }
        return switch (source) {
            case PlanSecurityType.API_KEY -> IntegrationApi.PlanType.API_KEY;
            case PlanSecurityType.JWT -> null;
            case PlanSecurityType.OAUTH2 -> IntegrationApi.PlanType.OAUTH2;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + source);
        };
    }

    @Override
    public IntegrationApi.Page map(Page source) {
        if (source == null) {
            return null;
        }
        IntegrationApi.PageType pageType = null;
        String content = null;
        String filename = null;
        pageType = this.pageTypeToPageType(source.pageType());
        content = source.content();
        filename = source.filename();
        IntegrationApi.Page page = new IntegrationApi.Page(pageType, content, filename);
        return page;
    }

    protected List<IntegrationApi.Plan> planListToPlanList(List<Plan> list) {
        if (list == null) {
            return null;
        }
        ArrayList<IntegrationApi.Plan> list1 = new ArrayList<IntegrationApi.Plan>(list.size());
        for (Plan plan : list) {
            list1.add(this.map(plan));
        }
        return list1;
    }

    protected List<IntegrationApi.Page> pageListToPageList(List<Page> list) {
        if (list == null) {
            return null;
        }
        ArrayList<IntegrationApi.Page> list1 = new ArrayList<IntegrationApi.Page>(list.size());
        for (Page page : list) {
            list1.add(this.map(page));
        }
        return list1;
    }

    protected Metadata.MetadataFormat formatToMetadataFormat(Metadata.Format format) {
        if (format == null) {
            return null;
        }
        return switch (format) {
            case Metadata.Format.STRING -> Metadata.MetadataFormat.STRING;
            case Metadata.Format.NUMERIC -> Metadata.MetadataFormat.NUMERIC;
            case Metadata.Format.BOOLEAN -> Metadata.MetadataFormat.BOOLEAN;
            case Metadata.Format.DATE -> Metadata.MetadataFormat.DATE;
            case Metadata.Format.MAIL -> Metadata.MetadataFormat.MAIL;
            case Metadata.Format.URL -> Metadata.MetadataFormat.URL;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + format);
        };
    }

    protected IntegrationApi.Metadata metadataToMetadata(Metadata metadata) {
        if (metadata == null) {
            return null;
        }
        String name = null;
        String value = null;
        Metadata.MetadataFormat format = null;
        name = metadata.name();
        value = metadata.value();
        format = this.formatToMetadataFormat(metadata.format());
        IntegrationApi.Metadata metadata1 = new IntegrationApi.Metadata(name, value, format);
        return metadata1;
    }

    protected Collection<IntegrationApi.Metadata> metadataListToMetadataCollection(List<Metadata> list) {
        if (list == null) {
            return null;
        }
        ArrayList<IntegrationApi.Metadata> collection = new ArrayList<IntegrationApi.Metadata>(list.size());
        for (Metadata metadata : list) {
            collection.add(this.metadataToMetadata(metadata));
        }
        return collection;
    }

    protected IntegrationApi.PageType pageTypeToPageType(PageType pageType) {
        if (pageType == null) {
            return null;
        }
        return switch (pageType) {
            case PageType.ASCIIDOC -> IntegrationApi.PageType.ASCIIDOC;
            case PageType.ASYNCAPI -> IntegrationApi.PageType.ASYNCAPI;
            case PageType.MARKDOWN -> IntegrationApi.PageType.MARKDOWN;
            case PageType.MARKDOWN_TEMPLATE -> IntegrationApi.PageType.MARKDOWN_TEMPLATE;
            case PageType.SWAGGER -> IntegrationApi.PageType.SWAGGER;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + pageType);
        };
    }
}

