/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.plan.model;

import io.gravitee.apim.core.exception.ValidationDomainException;
import io.gravitee.common.utils.TimeProvider;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.federation.FederatedPlan;
import io.gravitee.definition.model.v4.plan.PlanMode;
import io.gravitee.definition.model.v4.plan.PlanSecurity;
import io.gravitee.definition.model.v4.plan.PlanStatus;
import io.gravitee.rest.api.model.v4.plan.GenericPlanEntity;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import lombok.Generated;

public class Plan
implements GenericPlanEntity {
    private String id;
    private DefinitionVersion definitionVersion;
    private String crossId;
    private String name;
    private String description;
    private ZonedDateTime createdAt;
    private ZonedDateTime updatedAt;
    private ZonedDateTime publishedAt;
    private ZonedDateTime closedAt;
    private Date needRedeployAt;
    private PlanValidationType validation;
    private PlanType type;
    private String apiId;
    private String environmentId;
    private int order;
    private List<String> characteristics;
    private List<String> excludedGroups;
    private boolean commentRequired;
    private String commentMessage;
    private String generalConditions;
    private io.gravitee.definition.model.v4.plan.Plan planDefinitionV4;
    private io.gravitee.definition.model.Plan planDefinitionV2;
    private FederatedPlan federatedPlanDefinition;

    public Plan(String apiId, io.gravitee.definition.model.v4.plan.Plan planDefinitionV4) {
        this.setDefinitionVersion(DefinitionVersion.V4);
        this.setPlanDefinitionV4(planDefinitionV4);
        this.setId(planDefinitionV4.getId());
        this.setName(planDefinitionV4.getName());
        this.setPlanMode(planDefinitionV4.getMode());
        this.setPlanStatus(planDefinitionV4.getStatus());
        this.setPlanTags(planDefinitionV4.getTags());
        this.setType(PlanType.API);
        this.setApiId(apiId);
    }

    public io.gravitee.rest.api.model.v4.plan.PlanType getPlanType() {
        return io.gravitee.rest.api.model.v4.plan.PlanType.valueOf((String)this.type.name());
    }

    public PlanSecurity getPlanSecurity() {
        return switch (this.definitionVersion) {
            default -> throw new IncompatibleClassChangeError();
            case DefinitionVersion.V4 -> this.planDefinitionV4.getSecurity();
            case DefinitionVersion.V1, DefinitionVersion.V2 -> new PlanSecurity(this.planDefinitionV2.getSecurity(), this.planDefinitionV2.getSecurityDefinition());
            case DefinitionVersion.FEDERATED -> this.federatedPlanDefinition.getSecurity();
        };
    }

    public PlanStatus getPlanStatus() {
        return switch (this.definitionVersion) {
            default -> throw new IncompatibleClassChangeError();
            case DefinitionVersion.V4 -> this.planDefinitionV4.getStatus();
            case DefinitionVersion.V1, DefinitionVersion.V2 -> PlanStatus.valueOf((String)this.planDefinitionV2.getStatus());
            case DefinitionVersion.FEDERATED -> this.federatedPlanDefinition.getStatus();
        };
    }

    public Plan setPlanStatus(PlanStatus planStatus) {
        switch (this.definitionVersion) {
            case V4: {
                this.planDefinitionV4.setStatus(planStatus);
                break;
            }
            case V1: 
            case V2: {
                this.planDefinitionV2.setStatus(planStatus.name());
                break;
            }
            case FEDERATED: {
                this.federatedPlanDefinition.setStatus(planStatus);
            }
        }
        return this;
    }

    public PlanMode getPlanMode() {
        return switch (this.definitionVersion) {
            default -> throw new IncompatibleClassChangeError();
            case DefinitionVersion.V4 -> this.planDefinitionV4.getMode();
            case DefinitionVersion.V1, DefinitionVersion.V2 -> PlanMode.STANDARD;
            case DefinitionVersion.FEDERATED -> this.federatedPlanDefinition.getMode();
        };
    }

    public Plan setPlanMode(PlanMode planMode) {
        if (this.definitionVersion == DefinitionVersion.V4) {
            this.planDefinitionV4.setMode(planMode);
        }
        return this;
    }

    public Plan setPlanId(String id) {
        this.id = id;
        switch (this.definitionVersion) {
            case V4: {
                this.planDefinitionV4.setId(id);
                break;
            }
            case V1: 
            case V2: {
                this.planDefinitionV2.setId(id);
                break;
            }
            case FEDERATED: {
                this.federatedPlanDefinition.setId(id);
            }
        }
        return this;
    }

    public Plan setGeneralConditions(String generalConditions) {
        this.generalConditions = generalConditions;
        return this;
    }

    public Plan setPlanTags(Set<String> tags) {
        switch (this.definitionVersion) {
            case V4: {
                this.planDefinitionV4.setTags(tags);
                break;
            }
            case V1: 
            case V2: {
                this.planDefinitionV2.setTags(tags);
                break;
            }
        }
        return this;
    }

    public io.gravitee.rest.api.model.v4.plan.PlanValidationType getPlanValidation() {
        return io.gravitee.rest.api.model.v4.plan.PlanValidationType.valueOf((String)this.validation.name());
    }

    public boolean isFederated() {
        return this.definitionVersion == DefinitionVersion.FEDERATED;
    }

    public boolean isApiKey() {
        return switch (this.definitionVersion) {
            case DefinitionVersion.V4 -> this.planDefinitionV4.isApiKey();
            case DefinitionVersion.FEDERATED -> this.federatedPlanDefinition.isApiKey();
            default -> this.planDefinitionV2.isApiKey();
        };
    }

    public boolean isClosed() {
        return this.getPlanStatus() == PlanStatus.CLOSED;
    }

    public boolean isDeprecated() {
        return this.getPlanStatus() == PlanStatus.DEPRECATED;
    }

    public boolean isPublished() {
        return this.getPlanStatus() == PlanStatus.PUBLISHED;
    }

    public Plan close() {
        if (this.isClosed()) {
            throw new ValidationDomainException("Plan " + this.id + " is already closed");
        }
        ZonedDateTime closeDateTime = TimeProvider.now();
        return ((Plan)((PlanBuilder)((PlanBuilder)((PlanBuilder)this.toBuilder().closedAt(closeDateTime)).updatedAt(closeDateTime)).needRedeployAt(Date.from(closeDateTime.toInstant()))).build()).setPlanStatus(PlanStatus.CLOSED);
    }

    public Plan update(Plan updated) {
        return ((PlanBuilder)((PlanBuilder)((PlanBuilder)((PlanBuilder)((PlanBuilder)((PlanBuilder)((PlanBuilder)((PlanBuilder)((PlanBuilder)((PlanBuilder)((PlanBuilder)((PlanBuilder)((PlanBuilder)((PlanBuilder)this.toBuilder().name(updated.name)).description(updated.description)).order(updated.order)).updatedAt(TimeProvider.now())).planDefinitionV4(updated.planDefinitionV4)).planDefinitionV2(updated.planDefinitionV2)).federatedPlanDefinition(updated.federatedPlanDefinition != null ? this.federatedPlanDefinition.update(updated.federatedPlanDefinition) : this.federatedPlanDefinition)).commentRequired(updated.commentRequired)).commentMessage(updated.commentMessage)).generalConditions(updated.generalConditions)).excludedGroups(updated.excludedGroups)).characteristics(updated.characteristics)).crossId(updated.crossId == null ? this.crossId : updated.crossId)).validation(updated.validation)).build();
    }

    public Plan copy() {
        return switch (this.definitionVersion) {
            default -> throw new IncompatibleClassChangeError();
            case DefinitionVersion.V4 -> ((PlanBuilder)this.toBuilder().planDefinitionV4(this.planDefinitionV4.toBuilder().build())).build();
            case DefinitionVersion.V1, DefinitionVersion.V2 -> ((PlanBuilder)this.toBuilder().planDefinitionV2(this.planDefinitionV2.toBuilder().build())).build();
            case DefinitionVersion.FEDERATED -> ((PlanBuilder)this.toBuilder().federatedPlanDefinition(this.federatedPlanDefinition.toBuilder().build())).build();
        };
    }

    public Plan rollbackTo(io.gravitee.definition.model.v4.plan.Plan planDefinitionV4) {
        io.gravitee.definition.model.v4.plan.Plan existingPlanDefinitionV4 = this.getPlanDefinitionV4();
        existingPlanDefinitionV4.setName(planDefinitionV4.getName());
        this.setName(planDefinitionV4.getName());
        existingPlanDefinitionV4.setTags(planDefinitionV4.getTags());
        existingPlanDefinitionV4.setSecurity(planDefinitionV4.getSecurity());
        existingPlanDefinitionV4.setFlows(planDefinitionV4.getFlows());
        existingPlanDefinitionV4.setSelectionRule(planDefinitionV4.getSelectionRule());
        if (this.getPlanStatus() != planDefinitionV4.getStatus()) {
            existingPlanDefinitionV4.setStatus(planDefinitionV4.getStatus());
            this.setClosedAt(null);
            this.setUpdatedAt(TimeProvider.now());
            this.setNeedRedeployAt(Date.from(this.getUpdatedAt().toInstant()));
        }
        return this;
    }

    @Generated
    private static PlanType $default$type() {
        return PlanType.API;
    }

    @Generated
    private static List<String> $default$characteristics() {
        return new ArrayList<String>();
    }

    @Generated
    private static List<String> $default$excludedGroups() {
        return new ArrayList<String>();
    }

    @Generated
    protected Plan(PlanBuilder<?, ?> b) {
        this.id = b.id;
        this.definitionVersion = b.definitionVersion;
        this.crossId = b.crossId;
        this.name = b.name;
        this.description = b.description;
        this.createdAt = b.createdAt;
        this.updatedAt = b.updatedAt;
        this.publishedAt = b.publishedAt;
        this.closedAt = b.closedAt;
        this.needRedeployAt = b.needRedeployAt;
        this.validation = b.validation;
        this.type = b.type$set ? b.type$value : Plan.$default$type();
        this.apiId = b.apiId;
        this.environmentId = b.environmentId;
        this.order = b.order;
        this.characteristics = b.characteristics$set ? b.characteristics$value : Plan.$default$characteristics();
        this.excludedGroups = b.excludedGroups$set ? b.excludedGroups$value : Plan.$default$excludedGroups();
        this.commentRequired = b.commentRequired;
        this.commentMessage = b.commentMessage;
        this.generalConditions = b.generalConditions;
        this.planDefinitionV4 = b.planDefinitionV4;
        this.planDefinitionV2 = b.planDefinitionV2;
        this.federatedPlanDefinition = b.federatedPlanDefinition;
    }

    @Generated
    public static PlanBuilder<?, ?> builder() {
        return new PlanBuilderImpl();
    }

    @Generated
    public PlanBuilder<?, ?> toBuilder() {
        return new PlanBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public DefinitionVersion getDefinitionVersion() {
        return this.definitionVersion;
    }

    @Generated
    public String getCrossId() {
        return this.crossId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public ZonedDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public ZonedDateTime getPublishedAt() {
        return this.publishedAt;
    }

    @Generated
    public ZonedDateTime getClosedAt() {
        return this.closedAt;
    }

    @Generated
    public Date getNeedRedeployAt() {
        return this.needRedeployAt;
    }

    @Generated
    public PlanValidationType getValidation() {
        return this.validation;
    }

    @Generated
    public PlanType getType() {
        return this.type;
    }

    @Generated
    public String getApiId() {
        return this.apiId;
    }

    @Generated
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public List<String> getCharacteristics() {
        return this.characteristics;
    }

    @Generated
    public List<String> getExcludedGroups() {
        return this.excludedGroups;
    }

    @Generated
    public boolean isCommentRequired() {
        return this.commentRequired;
    }

    @Generated
    public String getCommentMessage() {
        return this.commentMessage;
    }

    @Generated
    public String getGeneralConditions() {
        return this.generalConditions;
    }

    @Generated
    public io.gravitee.definition.model.v4.plan.Plan getPlanDefinitionV4() {
        return this.planDefinitionV4;
    }

    @Generated
    public io.gravitee.definition.model.Plan getPlanDefinitionV2() {
        return this.planDefinitionV2;
    }

    @Generated
    public FederatedPlan getFederatedPlanDefinition() {
        return this.federatedPlanDefinition;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Plan)) {
            return false;
        }
        Plan other = (Plan)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOrder() != other.getOrder()) {
            return false;
        }
        if (this.isCommentRequired() != other.isCommentRequired()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        DefinitionVersion this$definitionVersion = this.getDefinitionVersion();
        DefinitionVersion other$definitionVersion = other.getDefinitionVersion();
        if (this$definitionVersion == null ? other$definitionVersion != null : !this$definitionVersion.equals(other$definitionVersion)) {
            return false;
        }
        String this$crossId = this.getCrossId();
        String other$crossId = other.getCrossId();
        if (this$crossId == null ? other$crossId != null : !this$crossId.equals(other$crossId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        ZonedDateTime this$createdAt = this.getCreatedAt();
        ZonedDateTime other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        ZonedDateTime this$updatedAt = this.getUpdatedAt();
        ZonedDateTime other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        ZonedDateTime this$publishedAt = this.getPublishedAt();
        ZonedDateTime other$publishedAt = other.getPublishedAt();
        if (this$publishedAt == null ? other$publishedAt != null : !((Object)this$publishedAt).equals(other$publishedAt)) {
            return false;
        }
        ZonedDateTime this$closedAt = this.getClosedAt();
        ZonedDateTime other$closedAt = other.getClosedAt();
        if (this$closedAt == null ? other$closedAt != null : !((Object)this$closedAt).equals(other$closedAt)) {
            return false;
        }
        Date this$needRedeployAt = this.getNeedRedeployAt();
        Date other$needRedeployAt = other.getNeedRedeployAt();
        if (this$needRedeployAt == null ? other$needRedeployAt != null : !((Object)this$needRedeployAt).equals(other$needRedeployAt)) {
            return false;
        }
        PlanValidationType this$validation = this.getValidation();
        PlanValidationType other$validation = other.getValidation();
        if (this$validation == null ? other$validation != null : !((Object)((Object)this$validation)).equals((Object)other$validation)) {
            return false;
        }
        PlanType this$type = this.getType();
        PlanType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$apiId = this.getApiId();
        String other$apiId = other.getApiId();
        if (this$apiId == null ? other$apiId != null : !this$apiId.equals(other$apiId)) {
            return false;
        }
        String this$environmentId = this.getEnvironmentId();
        String other$environmentId = other.getEnvironmentId();
        if (this$environmentId == null ? other$environmentId != null : !this$environmentId.equals(other$environmentId)) {
            return false;
        }
        List<String> this$characteristics = this.getCharacteristics();
        List<String> other$characteristics = other.getCharacteristics();
        if (this$characteristics == null ? other$characteristics != null : !((Object)this$characteristics).equals(other$characteristics)) {
            return false;
        }
        List<String> this$excludedGroups = this.getExcludedGroups();
        List<String> other$excludedGroups = other.getExcludedGroups();
        if (this$excludedGroups == null ? other$excludedGroups != null : !((Object)this$excludedGroups).equals(other$excludedGroups)) {
            return false;
        }
        String this$commentMessage = this.getCommentMessage();
        String other$commentMessage = other.getCommentMessage();
        if (this$commentMessage == null ? other$commentMessage != null : !this$commentMessage.equals(other$commentMessage)) {
            return false;
        }
        String this$generalConditions = this.getGeneralConditions();
        String other$generalConditions = other.getGeneralConditions();
        if (this$generalConditions == null ? other$generalConditions != null : !this$generalConditions.equals(other$generalConditions)) {
            return false;
        }
        io.gravitee.definition.model.v4.plan.Plan this$planDefinitionV4 = this.getPlanDefinitionV4();
        io.gravitee.definition.model.v4.plan.Plan other$planDefinitionV4 = other.getPlanDefinitionV4();
        if (this$planDefinitionV4 == null ? other$planDefinitionV4 != null : !this$planDefinitionV4.equals(other$planDefinitionV4)) {
            return false;
        }
        io.gravitee.definition.model.Plan this$planDefinitionV2 = this.getPlanDefinitionV2();
        io.gravitee.definition.model.Plan other$planDefinitionV2 = other.getPlanDefinitionV2();
        if (this$planDefinitionV2 == null ? other$planDefinitionV2 != null : !this$planDefinitionV2.equals(other$planDefinitionV2)) {
            return false;
        }
        FederatedPlan this$federatedPlanDefinition = this.getFederatedPlanDefinition();
        FederatedPlan other$federatedPlanDefinition = other.getFederatedPlanDefinition();
        return !(this$federatedPlanDefinition == null ? other$federatedPlanDefinition != null : !this$federatedPlanDefinition.equals(other$federatedPlanDefinition));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Plan;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getOrder();
        result = result * 59 + (this.isCommentRequired() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        DefinitionVersion $definitionVersion = this.getDefinitionVersion();
        result = result * 59 + ($definitionVersion == null ? 43 : $definitionVersion.hashCode());
        String $crossId = this.getCrossId();
        result = result * 59 + ($crossId == null ? 43 : $crossId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        ZonedDateTime $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        ZonedDateTime $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        ZonedDateTime $publishedAt = this.getPublishedAt();
        result = result * 59 + ($publishedAt == null ? 43 : ((Object)$publishedAt).hashCode());
        ZonedDateTime $closedAt = this.getClosedAt();
        result = result * 59 + ($closedAt == null ? 43 : ((Object)$closedAt).hashCode());
        Date $needRedeployAt = this.getNeedRedeployAt();
        result = result * 59 + ($needRedeployAt == null ? 43 : ((Object)$needRedeployAt).hashCode());
        PlanValidationType $validation = this.getValidation();
        result = result * 59 + ($validation == null ? 43 : ((Object)((Object)$validation)).hashCode());
        PlanType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $apiId = this.getApiId();
        result = result * 59 + ($apiId == null ? 43 : $apiId.hashCode());
        String $environmentId = this.getEnvironmentId();
        result = result * 59 + ($environmentId == null ? 43 : $environmentId.hashCode());
        List<String> $characteristics = this.getCharacteristics();
        result = result * 59 + ($characteristics == null ? 43 : ((Object)$characteristics).hashCode());
        List<String> $excludedGroups = this.getExcludedGroups();
        result = result * 59 + ($excludedGroups == null ? 43 : ((Object)$excludedGroups).hashCode());
        String $commentMessage = this.getCommentMessage();
        result = result * 59 + ($commentMessage == null ? 43 : $commentMessage.hashCode());
        String $generalConditions = this.getGeneralConditions();
        result = result * 59 + ($generalConditions == null ? 43 : $generalConditions.hashCode());
        io.gravitee.definition.model.v4.plan.Plan $planDefinitionV4 = this.getPlanDefinitionV4();
        result = result * 59 + ($planDefinitionV4 == null ? 43 : $planDefinitionV4.hashCode());
        io.gravitee.definition.model.Plan $planDefinitionV2 = this.getPlanDefinitionV2();
        result = result * 59 + ($planDefinitionV2 == null ? 43 : $planDefinitionV2.hashCode());
        FederatedPlan $federatedPlanDefinition = this.getFederatedPlanDefinition();
        result = result * 59 + ($federatedPlanDefinition == null ? 43 : $federatedPlanDefinition.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Plan(id=" + this.getId() + ", definitionVersion=" + this.getDefinitionVersion() + ", crossId=" + this.getCrossId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", publishedAt=" + this.getPublishedAt() + ", closedAt=" + this.getClosedAt() + ", needRedeployAt=" + this.getNeedRedeployAt() + ", validation=" + this.getValidation() + ", type=" + this.getType() + ", apiId=" + this.getApiId() + ", environmentId=" + this.getEnvironmentId() + ", order=" + this.getOrder() + ", characteristics=" + this.getCharacteristics() + ", excludedGroups=" + this.getExcludedGroups() + ", commentRequired=" + this.isCommentRequired() + ", commentMessage=" + this.getCommentMessage() + ", generalConditions=" + this.getGeneralConditions() + ", planDefinitionV4=" + this.getPlanDefinitionV4() + ", planDefinitionV2=" + this.getPlanDefinitionV2() + ", federatedPlanDefinition=" + this.getFederatedPlanDefinition() + ")";
    }

    @Generated
    public Plan() {
        this.type = Plan.$default$type();
        this.characteristics = Plan.$default$characteristics();
        this.excludedGroups = Plan.$default$excludedGroups();
    }

    @Generated
    public Plan(String id, DefinitionVersion definitionVersion, String crossId, String name, String description, ZonedDateTime createdAt, ZonedDateTime updatedAt, ZonedDateTime publishedAt, ZonedDateTime closedAt, Date needRedeployAt, PlanValidationType validation, PlanType type, String apiId, String environmentId, int order, List<String> characteristics, List<String> excludedGroups, boolean commentRequired, String commentMessage, String generalConditions, io.gravitee.definition.model.v4.plan.Plan planDefinitionV4, io.gravitee.definition.model.Plan planDefinitionV2, FederatedPlan federatedPlanDefinition) {
        this.id = id;
        this.definitionVersion = definitionVersion;
        this.crossId = crossId;
        this.name = name;
        this.description = description;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.publishedAt = publishedAt;
        this.closedAt = closedAt;
        this.needRedeployAt = needRedeployAt;
        this.validation = validation;
        this.type = type;
        this.apiId = apiId;
        this.environmentId = environmentId;
        this.order = order;
        this.characteristics = characteristics;
        this.excludedGroups = excludedGroups;
        this.commentRequired = commentRequired;
        this.commentMessage = commentMessage;
        this.generalConditions = generalConditions;
        this.planDefinitionV4 = planDefinitionV4;
        this.planDefinitionV2 = planDefinitionV2;
        this.federatedPlanDefinition = federatedPlanDefinition;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setDefinitionVersion(DefinitionVersion definitionVersion) {
        this.definitionVersion = definitionVersion;
    }

    @Generated
    public void setCrossId(String crossId) {
        this.crossId = crossId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setCreatedAt(ZonedDateTime createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setUpdatedAt(ZonedDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Generated
    public void setPublishedAt(ZonedDateTime publishedAt) {
        this.publishedAt = publishedAt;
    }

    @Generated
    public void setClosedAt(ZonedDateTime closedAt) {
        this.closedAt = closedAt;
    }

    @Generated
    public void setNeedRedeployAt(Date needRedeployAt) {
        this.needRedeployAt = needRedeployAt;
    }

    @Generated
    public void setValidation(PlanValidationType validation) {
        this.validation = validation;
    }

    @Generated
    public void setType(PlanType type) {
        this.type = type;
    }

    @Generated
    public void setApiId(String apiId) {
        this.apiId = apiId;
    }

    @Generated
    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Generated
    public void setCharacteristics(List<String> characteristics) {
        this.characteristics = characteristics;
    }

    @Generated
    public void setExcludedGroups(List<String> excludedGroups) {
        this.excludedGroups = excludedGroups;
    }

    @Generated
    public void setCommentRequired(boolean commentRequired) {
        this.commentRequired = commentRequired;
    }

    @Generated
    public void setCommentMessage(String commentMessage) {
        this.commentMessage = commentMessage;
    }

    @Generated
    public void setPlanDefinitionV4(io.gravitee.definition.model.v4.plan.Plan planDefinitionV4) {
        this.planDefinitionV4 = planDefinitionV4;
    }

    @Generated
    public void setPlanDefinitionV2(io.gravitee.definition.model.Plan planDefinitionV2) {
        this.planDefinitionV2 = planDefinitionV2;
    }

    @Generated
    public void setFederatedPlanDefinition(FederatedPlan federatedPlanDefinition) {
        this.federatedPlanDefinition = federatedPlanDefinition;
    }

    public static enum PlanType {
        API,
        CATALOG;

    }

    public static enum PlanValidationType {
        AUTO,
        MANUAL;

    }

    public static abstract class PlanBuilder<C extends Plan, B extends PlanBuilder<C, B>> {
        @Generated
        private String id;
        @Generated
        private DefinitionVersion definitionVersion;
        @Generated
        private String crossId;
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private ZonedDateTime createdAt;
        @Generated
        private ZonedDateTime updatedAt;
        @Generated
        private ZonedDateTime publishedAt;
        @Generated
        private ZonedDateTime closedAt;
        @Generated
        private Date needRedeployAt;
        @Generated
        private PlanValidationType validation;
        @Generated
        private boolean type$set;
        @Generated
        private PlanType type$value;
        @Generated
        private String apiId;
        @Generated
        private String environmentId;
        @Generated
        private int order;
        @Generated
        private boolean characteristics$set;
        @Generated
        private List<String> characteristics$value;
        @Generated
        private boolean excludedGroups$set;
        @Generated
        private List<String> excludedGroups$value;
        @Generated
        private boolean commentRequired;
        @Generated
        private String commentMessage;
        @Generated
        private String generalConditions;
        @Generated
        private io.gravitee.definition.model.v4.plan.Plan planDefinitionV4;
        @Generated
        private io.gravitee.definition.model.Plan planDefinitionV2;
        @Generated
        private FederatedPlan federatedPlanDefinition;

        public B planDefinition(io.gravitee.definition.model.Plan planDefinition) {
            this.planDefinitionV2 = planDefinition;
            if (planDefinition != null) {
                this.definitionVersion = DefinitionVersion.V2;
            }
            return this.self();
        }

        public B planDefinitionV4(io.gravitee.definition.model.v4.plan.Plan planDefinitionV4) {
            this.planDefinitionV4 = planDefinitionV4;
            if (planDefinitionV4 != null) {
                this.definitionVersion = DefinitionVersion.V4;
            }
            return this.self();
        }

        public B federatedPlanDefinition(FederatedPlan federatedPlan) {
            this.federatedPlanDefinition = federatedPlan;
            if (federatedPlan != null) {
                this.definitionVersion = DefinitionVersion.FEDERATED;
            }
            return this.self();
        }

        @Generated
        protected B $fillValuesFrom(C instance) {
            PlanBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Plan instance, PlanBuilder<?, ?> b) {
            b.id(instance.id);
            b.definitionVersion(instance.definitionVersion);
            b.crossId(instance.crossId);
            b.name(instance.name);
            b.description(instance.description);
            b.createdAt(instance.createdAt);
            b.updatedAt(instance.updatedAt);
            b.publishedAt(instance.publishedAt);
            b.closedAt(instance.closedAt);
            b.needRedeployAt(instance.needRedeployAt);
            b.validation(instance.validation);
            b.type(instance.type);
            b.apiId(instance.apiId);
            b.environmentId(instance.environmentId);
            b.order(instance.order);
            b.characteristics(instance.characteristics);
            b.excludedGroups(instance.excludedGroups);
            b.commentRequired(instance.commentRequired);
            b.commentMessage(instance.commentMessage);
            b.generalConditions(instance.generalConditions);
            b.planDefinitionV4(instance.planDefinitionV4);
            b.planDefinitionV2(instance.planDefinitionV2);
            b.federatedPlanDefinition(instance.federatedPlanDefinition);
        }

        @Generated
        public B id(String id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B definitionVersion(DefinitionVersion definitionVersion) {
            this.definitionVersion = definitionVersion;
            return this.self();
        }

        @Generated
        public B crossId(String crossId) {
            this.crossId = crossId;
            return this.self();
        }

        @Generated
        public B name(String name) {
            this.name = name;
            return this.self();
        }

        @Generated
        public B description(String description) {
            this.description = description;
            return this.self();
        }

        @Generated
        public B createdAt(ZonedDateTime createdAt) {
            this.createdAt = createdAt;
            return this.self();
        }

        @Generated
        public B updatedAt(ZonedDateTime updatedAt) {
            this.updatedAt = updatedAt;
            return this.self();
        }

        @Generated
        public B publishedAt(ZonedDateTime publishedAt) {
            this.publishedAt = publishedAt;
            return this.self();
        }

        @Generated
        public B closedAt(ZonedDateTime closedAt) {
            this.closedAt = closedAt;
            return this.self();
        }

        @Generated
        public B needRedeployAt(Date needRedeployAt) {
            this.needRedeployAt = needRedeployAt;
            return this.self();
        }

        @Generated
        public B validation(PlanValidationType validation) {
            this.validation = validation;
            return this.self();
        }

        @Generated
        public B type(PlanType type) {
            this.type$value = type;
            this.type$set = true;
            return this.self();
        }

        @Generated
        public B apiId(String apiId) {
            this.apiId = apiId;
            return this.self();
        }

        @Generated
        public B environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this.self();
        }

        @Generated
        public B order(int order) {
            this.order = order;
            return this.self();
        }

        @Generated
        public B characteristics(List<String> characteristics) {
            this.characteristics$value = characteristics;
            this.characteristics$set = true;
            return this.self();
        }

        @Generated
        public B excludedGroups(List<String> excludedGroups) {
            this.excludedGroups$value = excludedGroups;
            this.excludedGroups$set = true;
            return this.self();
        }

        @Generated
        public B commentRequired(boolean commentRequired) {
            this.commentRequired = commentRequired;
            return this.self();
        }

        @Generated
        public B commentMessage(String commentMessage) {
            this.commentMessage = commentMessage;
            return this.self();
        }

        @Generated
        public B generalConditions(String generalConditions) {
            this.generalConditions = generalConditions;
            return this.self();
        }

        @Generated
        public B planDefinitionV2(io.gravitee.definition.model.Plan planDefinitionV2) {
            this.planDefinitionV2 = planDefinitionV2;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "Plan.PlanBuilder(id=" + this.id + ", definitionVersion=" + this.definitionVersion + ", crossId=" + this.crossId + ", name=" + this.name + ", description=" + this.description + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", publishedAt=" + this.publishedAt + ", closedAt=" + this.closedAt + ", needRedeployAt=" + this.needRedeployAt + ", validation=" + this.validation + ", type$value=" + this.type$value + ", apiId=" + this.apiId + ", environmentId=" + this.environmentId + ", order=" + this.order + ", characteristics$value=" + this.characteristics$value + ", excludedGroups$value=" + this.excludedGroups$value + ", commentRequired=" + this.commentRequired + ", commentMessage=" + this.commentMessage + ", generalConditions=" + this.generalConditions + ", planDefinitionV4=" + this.planDefinitionV4 + ", planDefinitionV2=" + this.planDefinitionV2 + ", federatedPlanDefinition=" + this.federatedPlanDefinition + ")";
        }
    }

    @Generated
    private static final class PlanBuilderImpl
    extends PlanBuilder<Plan, PlanBuilderImpl> {
        @Generated
        private PlanBuilderImpl() {
        }

        @Override
        @Generated
        protected PlanBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Plan build() {
            return new Plan(this);
        }
    }
}

