/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.api.model.crd.ApiCRDSpec;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.apim.infra.adapter.ApiAdapterDecorator;
import io.gravitee.apim.infra.adapter.GraviteeJacksonMapper;
import io.gravitee.apim.infra.adapter.PlanAdapter;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.federation.FederatedApi;
import io.gravitee.definition.model.v4.Api;
import io.gravitee.rest.api.model.federation.FederatedApiEntity;
import io.gravitee.rest.api.model.v4.api.ApiEntity;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.model.v4.api.NewApiEntity;
import io.gravitee.rest.api.model.v4.api.UpdateApiEntity;
import java.io.IOException;
import java.util.stream.Stream;
import org.mapstruct.DecoratedWith;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.ValueMapping;
import org.mapstruct.factory.Mappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mapper(uses={PlanAdapter.class})
@DecoratedWith(value=ApiAdapterDecorator.class)
public interface ApiAdapter {
    public static final Logger LOGGER = LoggerFactory.getLogger(ApiAdapter.class);
    public static final ApiAdapter INSTANCE = (ApiAdapter)Mappers.getMapper(ApiAdapter.class);

    @Mappings(value={@Mapping(target="apiDefinitionV4", expression="java(deserializeApiDefinitionV4(source))"), @Mapping(target="apiDefinition", expression="java(deserializeApiDefinitionV2(source))"), @Mapping(target="federatedApiDefinition", expression="java(deserializeFederatedApiDefinition(source))")})
    public io.gravitee.apim.core.api.model.Api toCoreModel(io.gravitee.repository.management.model.Api var1);

    public Stream<io.gravitee.apim.core.api.model.Api> toCoreModelStream(Stream<io.gravitee.repository.management.model.Api> var1);

    @Mapping(target="definition", expression="java(serializeApiDefinition(source))")
    public io.gravitee.repository.management.model.Api toRepository(io.gravitee.apim.core.api.model.Api var1);

    public Stream<io.gravitee.repository.management.model.Api> toRepositoryStream(Stream<io.gravitee.apim.core.api.model.Api> var1);

    @Mappings(value={@Mapping(target="apiVersion", source="version"), @Mapping(target="tags", source="apiDefinitionV4.tags"), @Mapping(target="listeners", source="apiDefinitionV4.listeners"), @Mapping(target="endpointGroups", source="apiDefinitionV4.endpointGroups"), @Mapping(target="analytics", source="apiDefinitionV4.analytics"), @Mapping(target="flowExecution", source="apiDefinitionV4.flowExecution"), @Mapping(target="flows", source="apiDefinitionV4.flows")})
    public NewApiEntity toNewApiEntity(io.gravitee.apim.core.api.model.Api var1);

    @Mapping(target="apiVersion", source="version")
    public Api toApiDefinition(ApiCRDSpec var1);

    @ValueMapping(source="<ANY_REMAINING>", target="<NULL>")
    @Mappings(value={@Mapping(source="version", target="apiVersion"), @Mapping(target="disableMembershipNotifications", expression="java(!spec.isNotifyMembers())"), @Mapping(target="listeners", expression="java((List<Listener>) spec.getListeners())"), @Mapping(target="endpointGroups", expression="java((List<EndpointGroup>) spec.getEndpointGroups())"), @Mapping(target="flows", expression="java((List<Flow>) spec.getFlows())")})
    public UpdateApiEntity toUpdateApiEntity(ApiCRDSpec var1);

    @ValueMapping(source="<ANY_REMAINING>", target="<NULL>")
    @Mappings(value={@Mapping(target="id", source="api.id"), @Mapping(target="name", source="api.name"), @Mapping(target="definitionVersion", source="api.definitionVersion"), @Mapping(target="type", source="api.type"), @Mapping(target="tags", source="api.tags"), @Mapping(target="apiVersion", source="api.version"), @Mapping(target="lifecycleState", source="api.apiLifecycleState")})
    public UpdateApiEntity toUpdateApiEntity(io.gravitee.apim.core.api.model.Api var1, Api var2);

    @ValueMapping(source="<ANY_REMAINING>", target="<NULL>")
    @Mappings(value={@Mapping(source="version", target="apiVersion"), @Mapping(target="metadata", ignore=true)})
    public ApiEntity toApiEntity(ApiCRDSpec var1);

    @ValueMapping(source="<ANY_REMAINING>", target="<NULL>")
    @Mappings(value={@Mapping(source="version", target="apiVersion"), @Mapping(target="metadata", ignore=true)})
    public ApiEntity toApiEntity(io.gravitee.apim.core.api.model.Api var1);

    @ValueMapping(source="<ANY_REMAINING>", target="<NULL>")
    @Mappings(value={@Mapping(source="source.version", target="apiVersion"), @Mapping(source="source.id", target="id"), @Mapping(target="primaryOwner", source="primaryOwnerEntity"), @Mapping(target="referenceId", source="source.environmentId"), @Mapping(target="referenceType", constant="ENVIRONMENT"), @Mapping(source="source.apiLifecycleState", target="lifecycleState")})
    public FederatedApiEntity toFederatedApiEntity(io.gravitee.repository.management.model.Api var1, PrimaryOwnerEntity var2);

    @Mappings(value={@Mapping(source="state", target="lifecycleState"), @Mapping(source="lifecycleState", target="apiLifecycleState")})
    @ValueMapping(source="<ANY_REMAINING>", target="<NULL>")
    public io.gravitee.apim.core.api.model.Api fromApiEntity(GenericApiEntity var1);

    default public <T> T deserialize(io.gravitee.repository.management.model.Api api, Class<T> clazz) {
        if (api.getDefinition() == null) {
            return null;
        }
        try {
            return (T)GraviteeJacksonMapper.getInstance().readValue(api.getDefinition(), clazz);
        }
        catch (IOException ioe) {
            LOGGER.error("Unexpected error while deserializing V4 API definition", (Throwable)ioe);
            return null;
        }
    }

    default public Api deserializeApiDefinitionV4(io.gravitee.repository.management.model.Api api) {
        return api.getDefinitionVersion() == DefinitionVersion.V4 ? this.deserialize(api, Api.class) : null;
    }

    default public io.gravitee.definition.model.Api deserializeApiDefinitionV2(io.gravitee.repository.management.model.Api api) {
        return api.getDefinitionVersion() != DefinitionVersion.V4 && api.getDefinitionVersion() != DefinitionVersion.FEDERATED ? this.deserialize(api, io.gravitee.definition.model.Api.class) : null;
    }

    default public FederatedApi deserializeFederatedApiDefinition(io.gravitee.repository.management.model.Api api) {
        return api.getDefinitionVersion() == DefinitionVersion.FEDERATED ? this.deserialize(api, FederatedApi.class) : null;
    }

    default public String serializeApiDefinition(io.gravitee.apim.core.api.model.Api api) {
        return switch (api.getDefinitionVersion()) {
            default -> throw new IncompatibleClassChangeError();
            case DefinitionVersion.V1, DefinitionVersion.V2 -> this.serialize(api.getApiDefinition(), "V2 API");
            case DefinitionVersion.V4 -> this.serialize(api.getApiDefinitionV4(), "V4 API");
            case DefinitionVersion.FEDERATED -> this.serialize(api.getFederatedApiDefinition(), "Federated API");
        };
    }

    default public <T> String serialize(T value, String name) {
        try {
            return GraviteeJacksonMapper.getInstance().writeValueAsString(value);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unexpected error while serializing " + name + " definition", ioe);
        }
    }
}

