/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.subscription.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.plan.crud_service.PlanCrudService;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.apim.core.subscription.crud_service.SubscriptionCrudService;
import io.gravitee.apim.core.subscription.domain_service.AcceptSubscriptionDomainService;
import io.gravitee.apim.core.subscription.model.SubscriptionEntity;
import io.gravitee.rest.api.service.exceptions.PlanAlreadyClosedException;
import io.gravitee.rest.api.service.exceptions.SubscriptionNotFoundException;
import java.time.ZonedDateTime;
import lombok.Generated;

@UseCase
public class AcceptSubscriptionUseCase {
    private final SubscriptionCrudService subscriptionCrudService;
    private final PlanCrudService planCrudService;
    private final AcceptSubscriptionDomainService acceptSubscriptionDomainService;

    public AcceptSubscriptionUseCase(SubscriptionCrudService subscriptionCrudService, PlanCrudService planCrudService, AcceptSubscriptionDomainService acceptSubscriptionDomainService) {
        this.subscriptionCrudService = subscriptionCrudService;
        this.planCrudService = planCrudService;
        this.acceptSubscriptionDomainService = acceptSubscriptionDomainService;
    }

    public Output execute(Input input) {
        SubscriptionEntity subscription = this.subscriptionCrudService.get(input.subscriptionId);
        if (!input.apiId.equalsIgnoreCase(subscription.getApiId())) {
            throw new SubscriptionNotFoundException(input.subscriptionId);
        }
        this.checkSubscriptionStatus(subscription);
        Plan plan = this.checkPlanStatus(subscription);
        return new Output(this.acceptSubscriptionDomainService.accept(subscription, plan, input.startingAt, input.endingAt, input.reasonMessage, input.customKey, input.auditInfo));
    }

    private void checkSubscriptionStatus(SubscriptionEntity subscriptionEntity) {
        if (!subscriptionEntity.isPending()) {
            throw new IllegalStateException("Cannot accept subscription");
        }
    }

    private Plan checkPlanStatus(SubscriptionEntity subscriptionEntity) {
        Plan plan = this.planCrudService.getById(subscriptionEntity.getPlanId());
        if (plan.isClosed()) {
            throw new PlanAlreadyClosedException(plan.getId());
        }
        return plan;
    }

    public record Input(String apiId, String subscriptionId, ZonedDateTime startingAt, ZonedDateTime endingAt, String reasonMessage, String customKey, AuditInfo auditInfo) {
        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private String apiId;
            @Generated
            private String subscriptionId;
            @Generated
            private ZonedDateTime startingAt;
            @Generated
            private ZonedDateTime endingAt;
            @Generated
            private String reasonMessage;
            @Generated
            private String customKey;
            @Generated
            private AuditInfo auditInfo;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder apiId(String apiId) {
                this.apiId = apiId;
                return this;
            }

            @Generated
            public InputBuilder subscriptionId(String subscriptionId) {
                this.subscriptionId = subscriptionId;
                return this;
            }

            @Generated
            public InputBuilder startingAt(ZonedDateTime startingAt) {
                this.startingAt = startingAt;
                return this;
            }

            @Generated
            public InputBuilder endingAt(ZonedDateTime endingAt) {
                this.endingAt = endingAt;
                return this;
            }

            @Generated
            public InputBuilder reasonMessage(String reasonMessage) {
                this.reasonMessage = reasonMessage;
                return this;
            }

            @Generated
            public InputBuilder customKey(String customKey) {
                this.customKey = customKey;
                return this;
            }

            @Generated
            public InputBuilder auditInfo(AuditInfo auditInfo) {
                this.auditInfo = auditInfo;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.apiId, this.subscriptionId, this.startingAt, this.endingAt, this.reasonMessage, this.customKey, this.auditInfo);
            }

            @Generated
            public String toString() {
                return "AcceptSubscriptionUseCase.Input.InputBuilder(apiId=" + this.apiId + ", subscriptionId=" + this.subscriptionId + ", startingAt=" + this.startingAt + ", endingAt=" + this.endingAt + ", reasonMessage=" + this.reasonMessage + ", customKey=" + this.customKey + ", auditInfo=" + this.auditInfo + ")";
            }
        }
    }

    public record Output(SubscriptionEntity subscription) {
    }
}

