/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.domain_service.ApiMetadataDomainService;
import io.gravitee.apim.core.api.domain_service.ApiStateDomainService;
import io.gravitee.apim.core.api.domain_service.CreateApiDomainService;
import io.gravitee.apim.core.api.domain_service.UpdateApiDomainService;
import io.gravitee.apim.core.api.domain_service.ValidateApiCRDDomainService;
import io.gravitee.apim.core.api.domain_service.ValidateApiDomainService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.ApiWithFlows;
import io.gravitee.apim.core.api.model.crd.ApiCRDSpec;
import io.gravitee.apim.core.api.model.crd.ApiCRDStatus;
import io.gravitee.apim.core.api.model.crd.PageCRD;
import io.gravitee.apim.core.api.model.crd.PlanCRD;
import io.gravitee.apim.core.api.model.factory.ApiModelFactory;
import io.gravitee.apim.core.api.query_service.ApiQueryService;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.documentation.crud_service.PageCrudService;
import io.gravitee.apim.core.documentation.domain_service.CreateApiDocumentationDomainService;
import io.gravitee.apim.core.documentation.domain_service.UpdateApiDocumentationDomainService;
import io.gravitee.apim.core.documentation.exception.InvalidPageParentException;
import io.gravitee.apim.core.documentation.model.Page;
import io.gravitee.apim.core.documentation.model.factory.PageModelFactory;
import io.gravitee.apim.core.documentation.query_service.PageQueryService;
import io.gravitee.apim.core.exception.AbstractDomainException;
import io.gravitee.apim.core.exception.ValidationDomainException;
import io.gravitee.apim.core.member.domain_service.CRDMembersDomainService;
import io.gravitee.apim.core.membership.domain_service.ApiPrimaryOwnerFactory;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.apim.core.plan.domain_service.CreatePlanDomainService;
import io.gravitee.apim.core.plan.domain_service.DeletePlanDomainService;
import io.gravitee.apim.core.plan.domain_service.ReorderPlanDomainService;
import io.gravitee.apim.core.plan.domain_service.UpdatePlanDomainService;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.apim.core.plan.query_service.PlanQueryService;
import io.gravitee.apim.core.subscription.domain_service.CloseSubscriptionDomainService;
import io.gravitee.apim.core.subscription.query_service.SubscriptionQueryService;
import io.gravitee.apim.core.validation.Validator;
import io.gravitee.common.utils.TimeProvider;
import io.gravitee.definition.model.v4.plan.PlanStatus;
import io.gravitee.rest.api.model.context.OriginContext;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseCase
public class ImportApiCRDUseCase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImportApiCRDUseCase.class);
    private final ApiQueryService apiQueryService;
    private final ApiPrimaryOwnerFactory apiPrimaryOwnerFactory;
    private final ValidateApiDomainService validateApiDomainService;
    private final CreateApiDomainService createApiDomainService;
    private final CreatePlanDomainService createPlanDomainService;
    private final ApiStateDomainService apiStateDomainService;
    private final UpdateApiDomainService updateApiDomainService;
    private final ApiCrudService apiCrudService;
    private final PlanQueryService planQueryService;
    private final PageQueryService pageQueryService;
    private final PageCrudService pageCrudService;
    private final UpdatePlanDomainService updatePlanDomainService;
    private final DeletePlanDomainService deletePlanDomainService;
    private final SubscriptionQueryService subscriptionQueryService;
    private final CloseSubscriptionDomainService closeSubscriptionDomainService;
    private final ReorderPlanDomainService reorderPlanDomainService;
    private final CRDMembersDomainService membersDomainService;
    private final ApiMetadataDomainService apiMetadataDomainService;
    private final CreateApiDocumentationDomainService createApiDocumentationDomainService;
    private final UpdateApiDocumentationDomainService updateApiDocumentationDomainService;
    private final ValidateApiCRDDomainService validateCRDDomainService;

    public ImportApiCRDUseCase(ApiCrudService apiCrudService, ApiQueryService apiQueryService, ApiPrimaryOwnerFactory apiPrimaryOwnerFactory, ValidateApiDomainService validateApiDomainService, CreateApiDomainService createApiDomainService, CreatePlanDomainService createPlanDomainService, ApiStateDomainService apiStateDomainService, UpdateApiDomainService updateApiDomainService, PlanQueryService planQueryService, UpdatePlanDomainService updatePlanDomainService, DeletePlanDomainService deletePlanDomainService, SubscriptionQueryService subscriptionQueryService, CloseSubscriptionDomainService closeSubscriptionDomainService, ReorderPlanDomainService reorderPlanDomainService, CRDMembersDomainService membersDomainService, ApiMetadataDomainService apiMetadataDomainService, PageQueryService pageQueryService, PageCrudService pageCrudService, CreateApiDocumentationDomainService createApiDocumentationDomainService, UpdateApiDocumentationDomainService updateApiDocumentationDomainService, ValidateApiCRDDomainService validateCRDDomainService) {
        this.apiCrudService = apiCrudService;
        this.apiQueryService = apiQueryService;
        this.apiPrimaryOwnerFactory = apiPrimaryOwnerFactory;
        this.validateApiDomainService = validateApiDomainService;
        this.createApiDomainService = createApiDomainService;
        this.createPlanDomainService = createPlanDomainService;
        this.apiStateDomainService = apiStateDomainService;
        this.updateApiDomainService = updateApiDomainService;
        this.planQueryService = planQueryService;
        this.updatePlanDomainService = updatePlanDomainService;
        this.deletePlanDomainService = deletePlanDomainService;
        this.subscriptionQueryService = subscriptionQueryService;
        this.closeSubscriptionDomainService = closeSubscriptionDomainService;
        this.reorderPlanDomainService = reorderPlanDomainService;
        this.membersDomainService = membersDomainService;
        this.apiMetadataDomainService = apiMetadataDomainService;
        this.pageQueryService = pageQueryService;
        this.pageCrudService = pageCrudService;
        this.createApiDocumentationDomainService = createApiDocumentationDomainService;
        this.updateApiDocumentationDomainService = updateApiDocumentationDomainService;
        this.validateCRDDomainService = validateCRDDomainService;
    }

    public Output execute(Input input) {
        Optional<Api> api = this.apiQueryService.findByEnvironmentIdAndCrossId(input.auditInfo.environmentId(), input.spec.getCrossId());
        ApiCRDStatus status = api.map(exiting -> this.update(input, (Api)exiting)).orElseGet(() -> this.create(input));
        return new Output(status);
    }

    private ApiCRDStatus create(Input input) {
        try {
            String environmentId = input.auditInfo.environmentId();
            String organizationId = input.auditInfo.organizationId();
            Validator.Result<Input> validationResult = this.validateCRDDomainService.validateAndSanitize(new ValidateApiCRDDomainService.Input(input.auditInfo(), input.spec())).map(sanitized -> new Input(sanitized.auditInfo(), sanitized.spec()));
            validationResult.severe().ifPresent(errors -> {
                throw new ValidationDomainException(String.format("Unable to import because of errors [%s]", String.join((CharSequence)",", errors.stream().map(Validator.Error::getMessage).toList())));
            });
            List warnings = validationResult.warning().orElseGet(List::of);
            Input sanitizedInput = validationResult.value().orElseThrow(() -> new ValidationDomainException("Unable to sanitize CRD spec"));
            PrimaryOwnerEntity primaryOwner = this.apiPrimaryOwnerFactory.createForNewApi(organizationId, environmentId, sanitizedInput.auditInfo.actor().userId());
            ApiWithFlows createdApi = this.createApiDomainService.create(ApiModelFactory.fromCrd(sanitizedInput.spec, environmentId), primaryOwner, sanitizedInput.auditInfo, api -> this.validateApiDomainService.validateAndSanitizeForCreation((Api)api, primaryOwner, environmentId, organizationId));
            Map<String, String> planNameIdMapping = sanitizedInput.spec.getPlans().entrySet().stream().map(entry -> Map.entry((String)entry.getKey(), this.createPlanDomainService.create(this.initPlanFromCRD((PlanCRD)entry.getValue()), ((PlanCRD)entry.getValue()).getFlows(), createdApi, sanitizedInput.auditInfo).getId())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            this.membersDomainService.updateApiMembers(input.auditInfo, createdApi.getId(), sanitizedInput.spec().getMembers());
            this.createOrUpdatePages(sanitizedInput.spec.getPages(), createdApi.getId(), sanitizedInput.auditInfo);
            this.apiMetadataDomainService.importApiMetadata(createdApi.getId(), sanitizedInput.spec.getMetadata(), sanitizedInput.auditInfo);
            if (ImportApiCRDUseCase.shouldDeploy(sanitizedInput.spec())) {
                this.apiStateDomainService.start(createdApi, sanitizedInput.auditInfo);
            }
            return ApiCRDStatus.builder().id(createdApi.getId()).crossId(createdApi.getCrossId()).environmentId(environmentId).organizationId(organizationId).state(createdApi.getLifecycleState().name()).plans(planNameIdMapping).errors(ApiCRDStatus.Errors.fromErrorList(warnings)).build();
        }
        catch (AbstractDomainException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TechnicalManagementException(e);
        }
    }

    private ApiCRDStatus update(Input input, Api existingApi) {
        try {
            Validator.Result<Input> validationResult = this.validateCRDDomainService.validateAndSanitize(new ValidateApiCRDDomainService.Input(input.auditInfo(), input.spec())).map(sanitized -> new Input(sanitized.auditInfo(), sanitized.spec()));
            List warnings = validationResult.warning().orElseGet(List::of);
            Input sanitizedInput = validationResult.value().orElseThrow(() -> new ValidationDomainException("Unable to sanitize CRD spec"));
            Api updatedApi = this.updateApiDomainService.update(existingApi.getId(), sanitizedInput.spec, sanitizedInput.auditInfo);
            Api api = this.apiCrudService.update((Api)((Api.ApiBuilder)((Api.ApiBuilder)updatedApi.toBuilder().originContext((OriginContext)new OriginContext.Kubernetes(OriginContext.Kubernetes.Mode.valueOf((String)sanitizedInput.spec().getDefinitionContext().getMode().toUpperCase()), sanitizedInput.spec().getDefinitionContext().getSyncFrom().toUpperCase()))).lifecycleState(Api.LifecycleState.valueOf(sanitizedInput.spec().getState()))).build());
            List<Plan> existingPlans = this.planQueryService.findAllByApiId(api.getId());
            Map<String, PlanStatus> existingPlanStatuses = existingPlans.stream().collect(Collectors.toMap(Plan::getId, Plan::getPlanStatus));
            Map<String, String> planKeyIdMapping = sanitizedInput.spec().getPlans().entrySet().stream().map(entry -> {
                String key = (String)entry.getKey();
                PlanCRD plan = (PlanCRD)entry.getValue();
                if (existingPlanStatuses.containsKey(plan.getId())) {
                    return Map.entry(key, this.updatePlanDomainService.update(this.initPlanFromCRD(plan), plan.getFlows(), existingPlanStatuses, api, sanitizedInput.auditInfo).getId());
                }
                return Map.entry(key, this.createPlanDomainService.create(this.initPlanFromCRD(plan), plan.getFlows(), api, sanitizedInput.auditInfo).getId());
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            this.deletePlans(api, existingPlans, planKeyIdMapping, sanitizedInput);
            if (ImportApiCRDUseCase.shouldDeploy(sanitizedInput.spec())) {
                this.apiStateDomainService.deploy(api, "Updated by GKO", input.auditInfo);
            }
            if (api.getLifecycleState() != existingApi.getLifecycleState()) {
                if (api.getLifecycleState() == Api.LifecycleState.STOPPED) {
                    this.apiStateDomainService.stop(api, input.auditInfo);
                } else {
                    this.apiStateDomainService.start(api, input.auditInfo);
                }
            }
            this.membersDomainService.updateApiMembers(input.auditInfo, updatedApi.getId(), sanitizedInput.spec().getMembers());
            this.createOrUpdatePages(sanitizedInput.spec.getPages(), updatedApi.getId(), sanitizedInput.auditInfo);
            this.deleteRemovedPages(sanitizedInput.spec.getPages(), updatedApi.getId());
            this.apiMetadataDomainService.importApiMetadata(api.getId(), sanitizedInput.spec.getMetadata(), sanitizedInput.auditInfo);
            return ApiCRDStatus.builder().id(api.getId()).crossId(api.getCrossId()).environmentId(api.getEnvironmentId()).organizationId(sanitizedInput.auditInfo.organizationId()).state(api.getLifecycleState().name()).plans(planKeyIdMapping).errors(ApiCRDStatus.Errors.fromErrorList(warnings)).build();
        }
        catch (Exception e) {
            throw new TechnicalManagementException(e);
        }
    }

    private void deletePlans(Api api, List<Plan> existingPlans, Map<String, String> planKeyIdMapping, Input input) {
        List<Plan> plansToDelete = existingPlans.stream().filter(plan -> !planKeyIdMapping.containsValue(plan.getId())).filter(plan -> !input.spec.getPlans().containsKey(plan.getId())).toList();
        plansToDelete.forEach(plan -> {
            this.subscriptionQueryService.findActiveSubscriptionsByPlan(plan.getId()).forEach(subscription -> this.closeSubscriptionDomainService.closeSubscription(subscription.getId(), input.auditInfo));
            this.deletePlanDomainService.delete((Plan)plan, input.auditInfo);
        });
        this.reorderPlanDomainService.refreshOrderAfterDelete(api.getId());
    }

    private Plan initPlanFromCRD(PlanCRD planCRD) {
        return ((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)((Plan.PlanBuilder)Plan.builder().id(planCRD.getId())).name(planCRD.getName())).description(planCRD.getDescription())).planDefinitionV4(io.gravitee.definition.model.v4.plan.Plan.builder().security(planCRD.getSecurity()).selectionRule(planCRD.getSelectionRule()).status(planCRD.getStatus()).tags(planCRD.getTags()).mode(planCRD.getMode()).build())).characteristics(planCRD.getCharacteristics())).crossId(planCRD.getCrossId())).excludedGroups(planCRD.getExcludedGroups())).generalConditions(planCRD.getGeneralConditions())).order(planCRD.getOrder())).type(planCRD.getType())).validation(planCRD.getValidation())).build();
    }

    private void deleteRemovedPages(Map<String, PageCRD> pages, String apiId) {
        Set existingPageIds = this.pageQueryService.searchByApiId(apiId).stream().map(Page::getId).collect(Collectors.toSet());
        if (pages != null && !pages.isEmpty()) {
            Set givenPageIds = pages.values().stream().map(PageCRD::getId).collect(Collectors.toSet());
            existingPageIds.removeIf(givenPageIds::contains);
        }
        try {
            for (String id : existingPageIds) {
                this.pageCrudService.delete(id);
            }
        }
        catch (RuntimeException e) {
            log.error("An error as occurred while trying to remove a page with kubernetes origin");
        }
    }

    private void createOrUpdatePages(Map<String, PageCRD> pageCRDs, String apiId, AuditInfo auditInfo) {
        if (pageCRDs == null || pageCRDs.isEmpty()) {
            return;
        }
        Date now = Date.from(TimeProvider.now().toInstant());
        List<Page> pages = pageCRDs.values().stream().map(PageModelFactory::fromCRDSpec).toList();
        pages.forEach(page -> {
            page.setReferenceId(apiId);
            page.setReferenceType(Page.ReferenceType.API);
            if (page.getParentId() != null) {
                this.validatePageParent(pages, page.getParentId());
            }
            this.pageCrudService.findById(page.getId()).ifPresentOrElse(oldPage -> this.updateApiDocumentationDomainService.updatePage(page.toBuilder().createdAt(oldPage.getCreatedAt()).updatedAt(now).build(), (Page)oldPage, auditInfo), () -> this.createApiDocumentationDomainService.createPage(page.toBuilder().createdAt(now).updatedAt(now).build(), auditInfo));
        });
    }

    private void validatePageParent(List<Page> pages, String parentId) {
        pages.stream().filter(page -> parentId.equals(page.getId())).findFirst().ifPresent(parent -> {
            if (!parent.isFolder() && !parent.isRoot()) {
                throw new InvalidPageParentException(parent.getId());
            }
        });
    }

    private static boolean shouldDeploy(ApiCRDSpec spec) {
        return spec.getDefinitionContext().isSyncFromManagement() && Api.LifecycleState.STARTED.name().equalsIgnoreCase(spec.getState()) && spec.getPlans().values().stream().anyMatch(plan -> plan.getStatus() == PlanStatus.PUBLISHED || plan.getStatus() == PlanStatus.DEPRECATED);
    }

    public record Input(AuditInfo auditInfo, ApiCRDSpec spec) {
    }

    public record Output(ApiCRDStatus status) {
    }
}

