/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.category.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.domain_service.ApiAuthorizationDomainService;
import io.gravitee.apim.core.api.exception.ApiNotFoundException;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.ApiQueryCriteria;
import io.gravitee.apim.core.category.crud_service.CategoryApiCrudService;
import io.gravitee.apim.core.category.domain_service.UpdateCategoryApiDomainService;
import io.gravitee.apim.core.category.domain_service.ValidateCategoryDomainService;
import io.gravitee.apim.core.category.model.ApiCategoryOrder;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.util.List;
import java.util.Set;
import lombok.Generated;

@UseCase
public class UpdateCategoryApiOrderUseCase {
    private final ValidateCategoryDomainService validateCategoryDomainService;
    private final ApiAuthorizationDomainService apiAuthorizationDomainService;
    private final UpdateCategoryApiDomainService updateCategoryApiDomainService;
    private final ApiCrudService apiCrudService;
    private final CategoryApiCrudService categoryApiCrudService;

    public Output execute(Input input) {
        String categoryId = this.validateAndGetCategoryId(input.categoryIdOrKey(), input.executionContext().getEnvironmentId());
        this.validateUserHasAccessToApi(input.executionContext(), input.userId(), input.isAdmin(), categoryId, input.apiId());
        ApiCategoryOrder apiCategoryOrder = this.validateAndGetApiCategoryAssociation(categoryId, input.apiId());
        this.updateCategoryApiDomainService.changeOrder(apiCategoryOrder, input.newOrder());
        return new Output(new Result(this.validateAndGetApiCategoryAssociation(categoryId, input.apiId()), this.apiCrudService.get(input.apiId())));
    }

    private void validateUserHasAccessToApi(ExecutionContext executionContext, String userId, boolean isAdmin, String categoryId, String apiId) {
        Set<String> apiIdsInUserScope;
        if (!isAdmin ? (apiIdsInUserScope = this.apiAuthorizationDomainService.findIdsByUser(executionContext, userId, ApiQueryCriteria.builder().ids(List.of(apiId)).category(categoryId).build(), null, false)).contains(apiId) : this.apiCrudService.existsById(apiId)) {
            return;
        }
        throw new ApiNotFoundException(apiId);
    }

    private String validateAndGetCategoryId(String categoryIdOrKey, String environmentId) {
        return this.validateCategoryDomainService.validateCategoryIdOrKey(categoryIdOrKey, environmentId);
    }

    private ApiCategoryOrder validateAndGetApiCategoryAssociation(String categoryId, String apiId) {
        return this.categoryApiCrudService.get(apiId, categoryId);
    }

    @Generated
    public UpdateCategoryApiOrderUseCase(ValidateCategoryDomainService validateCategoryDomainService, ApiAuthorizationDomainService apiAuthorizationDomainService, UpdateCategoryApiDomainService updateCategoryApiDomainService, ApiCrudService apiCrudService, CategoryApiCrudService categoryApiCrudService) {
        this.validateCategoryDomainService = validateCategoryDomainService;
        this.apiAuthorizationDomainService = apiAuthorizationDomainService;
        this.updateCategoryApiDomainService = updateCategoryApiDomainService;
        this.apiCrudService = apiCrudService;
        this.categoryApiCrudService = categoryApiCrudService;
    }

    public record Input(ExecutionContext executionContext, String categoryIdOrKey, String apiId, String userId, boolean isAdmin, int newOrder) {
    }

    public record Output(Result result) {
    }

    public record Result(ApiCategoryOrder apiCategoryOrder, Api api) {
    }
}

