/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.upgrader;

import io.gravitee.node.api.upgrader.Upgrader;
import io.gravitee.repository.management.api.OrganizationRepository;
import io.gravitee.repository.management.model.Organization;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.common.DefaultRoleEntityDefinition;
import io.gravitee.rest.api.service.common.ExecutionContext;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class IntegrationRolesUpgrader
implements Upgrader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntegrationRolesUpgrader.class);
    private final RoleService roleService;
    private final OrganizationRepository organizationRepository;

    @Autowired
    public IntegrationRolesUpgrader(RoleService roleService, @Lazy OrganizationRepository organizationRepository) {
        this.roleService = roleService;
        this.organizationRepository = organizationRepository;
    }

    public boolean upgrade() {
        try {
            this.organizationRepository.findAll().forEach(organization -> {
                ExecutionContext executionContext = new ExecutionContext((Organization)organization);
                this.initializeIntegrationRoles(executionContext);
                this.roleService.createOrUpdateSystemRoles(executionContext, executionContext.getOrganizationId());
            });
        }
        catch (Exception e) {
            log.error("failed to apply {}", (Object)this.getClass().getSimpleName(), (Object)e);
            return false;
        }
        return true;
    }

    private void initializeIntegrationRoles(ExecutionContext executionContext) {
        if (this.shouldCreateIntegrationOwnerRole(executionContext)) {
            log.info("     - <INTEGRATION> OWNER");
            this.roleService.create(executionContext, DefaultRoleEntityDefinition.ROLE_INTEGRATION_OWNER);
        }
        if (this.shouldCreateIntegrationUserRole(executionContext)) {
            log.info("     - <INTEGRATION> USER");
            this.roleService.create(executionContext, DefaultRoleEntityDefinition.ROLE_INTEGRATION_USER);
        }
    }

    private boolean shouldCreateIntegrationOwnerRole(ExecutionContext executionContext) {
        return this.roleService.findByScopeAndName(RoleScope.INTEGRATION, DefaultRoleEntityDefinition.ROLE_INTEGRATION_OWNER.getName(), executionContext.getOrganizationId()).isEmpty();
    }

    private boolean shouldCreateIntegrationUserRole(ExecutionContext executionContext) {
        return this.roleService.findByScopeAndName(RoleScope.INTEGRATION, DefaultRoleEntityDefinition.ROLE_INTEGRATION_USER.getName(), executionContext.getOrganizationId()).isEmpty();
    }

    public int getOrder() {
        return 702;
    }
}

