/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.converter;

import io.gravitee.repository.management.model.ApiKeyMode;
import io.gravitee.repository.management.model.Application;
import io.gravitee.repository.management.model.ApplicationType;
import io.gravitee.rest.api.model.ApplicationEntity;
import io.gravitee.rest.api.model.NewApplicationEntity;
import io.gravitee.rest.api.model.UpdateApplicationEntity;
import io.gravitee.rest.api.model.application.ApplicationSettings;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ApplicationConverter {
    public UpdateApplicationEntity toUpdateApplicationEntity(ApplicationEntity application) {
        UpdateApplicationEntity updateApplicationEntity = new UpdateApplicationEntity();
        updateApplicationEntity.setSettings(application.getSettings());
        updateApplicationEntity.setBackground(application.getBackground());
        updateApplicationEntity.setDescription(application.getDescription());
        updateApplicationEntity.setDomain(application.getDomain());
        updateApplicationEntity.setGroups(application.getGroups());
        updateApplicationEntity.setPicture(application.getPicture());
        updateApplicationEntity.setName(application.getName());
        updateApplicationEntity.setApiKeyMode(application.getApiKeyMode());
        updateApplicationEntity.setDisableMembershipNotifications(application.isDisableMembershipNotifications());
        updateApplicationEntity.setType(application.getType());
        return updateApplicationEntity;
    }

    public Application toApplication(NewApplicationEntity newApplicationEntity) {
        Application application = new Application();
        application.setName(StringUtils.trim((String)newApplicationEntity.getName()));
        application.setDescription(StringUtils.trim((String)newApplicationEntity.getDescription()));
        application.setDomain(newApplicationEntity.getDomain());
        application.setGroups((Collection)newApplicationEntity.getGroups());
        if (newApplicationEntity.getSettings() != null) {
            if (newApplicationEntity.getSettings().getApp() != null) {
                application.setType(ApplicationType.SIMPLE);
            } else {
                application.setType(ApplicationType.valueOf((String)newApplicationEntity.getSettings().getOauth().getApplicationType().toUpperCase()));
            }
        }
        application.setPicture(newApplicationEntity.getPicture());
        application.setBackground(newApplicationEntity.getBackground());
        application.setMetadata(this.toMetadata(newApplicationEntity.getSettings()));
        application.setApiKeyMode(this.toModelApiKeyMode(newApplicationEntity.getApiKeyMode()));
        application.setOrigin(newApplicationEntity.getOrigin());
        application.setDisableMembershipNotifications(newApplicationEntity.isDisableMembershipNotifications());
        return application;
    }

    public Application toApplication(UpdateApplicationEntity updateApplicationEntity) {
        Application application = new Application();
        application.setName(StringUtils.trim((String)updateApplicationEntity.getName()));
        application.setDescription(StringUtils.trim((String)updateApplicationEntity.getDescription()));
        application.setPicture(updateApplicationEntity.getPicture());
        application.setBackground(updateApplicationEntity.getBackground());
        application.setDomain(updateApplicationEntity.getDomain());
        application.setGroups((Collection)updateApplicationEntity.getGroups());
        application.setApiKeyMode(this.toModelApiKeyMode(updateApplicationEntity.getApiKeyMode()));
        application.setMetadata(this.toMetadata(updateApplicationEntity.getSettings()));
        application.setDisableMembershipNotifications(updateApplicationEntity.isDisableMembershipNotifications());
        return application;
    }

    private Map<String, String> toMetadata(ApplicationSettings applicationSettings) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        if (applicationSettings != null && applicationSettings.getApp() != null) {
            if (applicationSettings.getApp().getClientId() != null) {
                metadata.put("client_id", applicationSettings.getApp().getClientId());
            }
            if (applicationSettings.getApp().getType() != null) {
                metadata.put("type", applicationSettings.getApp().getType());
            }
        }
        if (applicationSettings != null && applicationSettings.getTls() != null && applicationSettings.getTls().getClientCertificate() != null) {
            metadata.put("client_certificate", applicationSettings.getTls().getClientCertificate());
        }
        return metadata;
    }

    private ApiKeyMode toModelApiKeyMode(io.gravitee.rest.api.model.ApiKeyMode apiKeyMode) {
        return apiKeyMode != null ? ApiKeyMode.valueOf((String)apiKeyMode.name()) : ApiKeyMode.UNSPECIFIED;
    }
}

