/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.domain_service.UpdateFederatedApiDomainService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.membership.domain_service.ApiPrimaryOwnerDomainService;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import java.util.function.UnaryOperator;
import lombok.Generated;

@UseCase
public class UpdateFederatedApiUseCase {
    private final ApiPrimaryOwnerDomainService apiPrimaryOwnerDomainService;
    private final UpdateFederatedApiDomainService apiUpdateFederatedApiDomainService;

    public Output execute(Input input) {
        Api updateApi = input.apiToUpdate;
        AuditInfo auditInfo = input.auditInfo;
        PrimaryOwnerEntity primaryOwnerEntity = this.apiPrimaryOwnerDomainService.getApiPrimaryOwner(auditInfo.organizationId(), updateApi.getId());
        UnaryOperator<Api> updating = UpdateFederatedApiUseCase.update(input.apiToUpdate);
        Api updated = this.apiUpdateFederatedApiDomainService.update(input.apiToUpdate.getId(), updating, auditInfo, primaryOwnerEntity);
        return new Output(updated, primaryOwnerEntity);
    }

    static UnaryOperator<Api> update(Api newOne) {
        return currentApi -> ((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)((Api.ApiBuilder)currentApi.toBuilder().name(newOne.getName())).description(newOne.getDescription())).version(newOne.getVersion())).apiLifecycleState(newOne.getApiLifecycleState())).visibility(newOne.getVisibility())).labels(newOne.getLabels())).categories(newOne.getCategories())).groups(newOne.getGroups())).build();
    }

    @Generated
    public UpdateFederatedApiUseCase(ApiPrimaryOwnerDomainService apiPrimaryOwnerDomainService, UpdateFederatedApiDomainService apiUpdateFederatedApiDomainService) {
        this.apiPrimaryOwnerDomainService = apiPrimaryOwnerDomainService;
        this.apiUpdateFederatedApiDomainService = apiUpdateFederatedApiDomainService;
    }

    public record Input(Api apiToUpdate, AuditInfo auditInfo) {
        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private Api apiToUpdate;
            @Generated
            private AuditInfo auditInfo;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder apiToUpdate(Api apiToUpdate) {
                this.apiToUpdate = apiToUpdate;
                return this;
            }

            @Generated
            public InputBuilder auditInfo(AuditInfo auditInfo) {
                this.auditInfo = auditInfo;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.apiToUpdate, this.auditInfo);
            }

            @Generated
            public String toString() {
                return "UpdateFederatedApiUseCase.Input.InputBuilder(apiToUpdate=" + this.apiToUpdate + ", auditInfo=" + this.auditInfo + ")";
            }
        }
    }

    public record Output(Api updatedApi, PrimaryOwnerEntity primaryOwnerEntity) {
    }
}

