/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.application.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.application.crud_service.ApplicationCrudService;
import io.gravitee.apim.core.application.domain_service.ImportApplicationCRDDomainService;
import io.gravitee.apim.core.application.domain_service.ValidateApplicationCRDDomainService;
import io.gravitee.apim.core.application.model.crd.ApplicationCRDSpec;
import io.gravitee.apim.core.application.model.crd.ApplicationCRDStatus;
import io.gravitee.apim.core.application.model.crd.ApplicationMetadataCRD;
import io.gravitee.apim.core.application_metadata.crud_service.ApplicationMetadataCrudService;
import io.gravitee.apim.core.application_metadata.query_service.ApplicationMetadataQueryService;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.exception.AbstractDomainException;
import io.gravitee.apim.core.exception.ValidationDomainException;
import io.gravitee.apim.core.member.domain_service.CRDMembersDomainService;
import io.gravitee.apim.core.utils.CollectionUtils;
import io.gravitee.apim.core.validation.Validator;
import io.gravitee.definition.model.Origin;
import io.gravitee.rest.api.model.ApplicationMetadataEntity;
import io.gravitee.rest.api.model.BaseApplicationEntity;
import io.gravitee.rest.api.model.NewApplicationEntity;
import io.gravitee.rest.api.model.NewApplicationMetadataEntity;
import io.gravitee.rest.api.model.UpdateApplicationEntity;
import io.gravitee.rest.api.model.UpdateApplicationMetadataEntity;
import io.gravitee.rest.api.service.exceptions.ApplicationNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseCase
public class ImportApplicationCRDUseCase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImportApplicationCRDUseCase.class);
    private final ApplicationCrudService applicationCrudService;
    private final ImportApplicationCRDDomainService importApplicationCRDDomainService;
    private final ApplicationMetadataCrudService applicationMetadataCrudService;
    private final ApplicationMetadataQueryService applicationMetadataQueryService;
    private final CRDMembersDomainService membersDomainService;
    private final ValidateApplicationCRDDomainService crdValidator;

    public ImportApplicationCRDUseCase(ApplicationCrudService applicationCrudService, ImportApplicationCRDDomainService importApplicationCRDDomainService, ApplicationMetadataCrudService applicationMetadataCrudService, ApplicationMetadataQueryService applicationMetadataQueryService, CRDMembersDomainService membersDomainService, ValidateApplicationCRDDomainService crdValidator) {
        this.applicationCrudService = applicationCrudService;
        this.importApplicationCRDDomainService = importApplicationCRDDomainService;
        this.applicationMetadataCrudService = applicationMetadataCrudService;
        this.applicationMetadataQueryService = applicationMetadataQueryService;
        this.membersDomainService = membersDomainService;
        this.crdValidator = crdValidator;
    }

    public Output execute(Input input) {
        try {
            BaseApplicationEntity application = this.applicationCrudService.findById(input.crd.getId(), input.auditInfo.environmentId());
            return new Output(this.update(input, application));
        }
        catch (ApplicationNotFoundException e) {
            return new Output(this.create(input));
        }
    }

    private ApplicationCRDStatus create(Input input) {
        try {
            Validator.Result<Input> validationResult = this.validateAndSanitize(input);
            List warnings = validationResult.warning().orElseGet(List::of);
            Input sanitizedInput = validationResult.value().orElseThrow(() -> new ValidationDomainException("Unable to sanitize CRD spec"));
            NewApplicationEntity newApplicationEntity = sanitizedInput.crd().toNewApplicationEntity();
            BaseApplicationEntity newApplication = this.importApplicationCRDDomainService.create(newApplicationEntity, sanitizedInput.auditInfo);
            this.createOrUpdateApplicationMetadata(sanitizedInput, newApplication);
            this.membersDomainService.updateApplicationMembers(sanitizedInput.auditInfo, newApplication.getId(), sanitizedInput.crd.getMembers());
            return ApplicationCRDStatus.builder().id(newApplication.getId()).organizationId(sanitizedInput.auditInfo.organizationId()).environmentId(sanitizedInput.auditInfo.environmentId()).errors(ApplicationCRDStatus.Errors.fromErrorList(warnings)).build();
        }
        catch (AbstractDomainException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TechnicalManagementException(e);
        }
    }

    private ApplicationCRDStatus update(Input input, BaseApplicationEntity application) {
        try {
            Validator.Result<Input> validationResult = this.validateAndSanitize(input);
            List warnings = validationResult.warning().orElseGet(List::of);
            Input sanitizedInput = validationResult.value().orElseThrow(() -> new ValidationDomainException("Unable to sanitize CRD spec"));
            UpdateApplicationEntity updateApplicationEntity = sanitizedInput.crd.toUpdateApplicationEntity();
            BaseApplicationEntity updatedApplication = this.importApplicationCRDDomainService.update(application.getId(), updateApplicationEntity, sanitizedInput.auditInfo);
            this.createOrUpdateApplicationMetadata(sanitizedInput, updatedApplication);
            this.membersDomainService.updateApplicationMembers(sanitizedInput.auditInfo, updatedApplication.getId(), sanitizedInput.crd.getMembers());
            return ApplicationCRDStatus.builder().id(updatedApplication.getId()).organizationId(input.auditInfo.organizationId()).environmentId(input.auditInfo.environmentId()).errors(ApplicationCRDStatus.Errors.fromErrorList(warnings)).build();
        }
        catch (AbstractDomainException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TechnicalManagementException(e);
        }
    }

    private Validator.Result<Input> validateAndSanitize(Input input) {
        Validator.Result<Input> validationResult = this.crdValidator.validateAndSanitize(new ValidateApplicationCRDDomainService.Input(input.auditInfo(), input.crd())).map(sanitized -> new Input(sanitized.auditInfo(), sanitized.spec()));
        validationResult.severe().ifPresent(errors -> {
            throw new ValidationDomainException(String.format("Unable to import because of errors [%s]", String.join((CharSequence)",", errors.stream().map(Validator.Error::getMessage).toList())));
        });
        return validationResult;
    }

    private void createOrUpdateApplicationMetadata(Input input, BaseApplicationEntity application) {
        if (!CollectionUtils.isEmpty(input.crd.getMetadata())) {
            String applicationId = application.getId();
            List<ApplicationMetadataEntity> exitingAppMetadata = this.applicationMetadataQueryService.findAllByApplication(applicationId);
            for (ApplicationMetadataCRD metadata : input.crd.getMetadata()) {
                metadata.setApplicationId(applicationId);
                Optional<ApplicationMetadataEntity> applicationMetadataEntity = exitingAppMetadata.stream().filter(ame -> ame.getName().equals(metadata.getName())).findFirst();
                if (applicationMetadataEntity.isPresent()) {
                    exitingAppMetadata.remove(applicationMetadataEntity.get());
                    this.applicationMetadataCrudService.update(this.toUpdateApplicationMetadataEntity(metadata));
                    continue;
                }
                this.applicationMetadataCrudService.create(this.toNewApplicationMetadataEntity(metadata));
            }
            exitingAppMetadata.forEach(this.applicationMetadataCrudService::delete);
        }
    }

    private NewApplicationMetadataEntity toNewApplicationMetadataEntity(ApplicationMetadataCRD crd) {
        NewApplicationMetadataEntity newApplicationMetadataEntity = new NewApplicationMetadataEntity();
        newApplicationMetadataEntity.setApplicationId(crd.getApplicationId());
        newApplicationMetadataEntity.setName(crd.getName());
        newApplicationMetadataEntity.setValue(crd.getValue());
        newApplicationMetadataEntity.setFormat(crd.getFormat());
        newApplicationMetadataEntity.setDefaultValue(crd.getDefaultValue());
        newApplicationMetadataEntity.setOrigin(Origin.KUBERNETES);
        newApplicationMetadataEntity.setHidden(crd.isHidden());
        return newApplicationMetadataEntity;
    }

    private UpdateApplicationMetadataEntity toUpdateApplicationMetadataEntity(ApplicationMetadataCRD crd) {
        UpdateApplicationMetadataEntity updateApplicationMetadataEntity = new UpdateApplicationMetadataEntity();
        updateApplicationMetadataEntity.setApplicationId(crd.getApplicationId());
        updateApplicationMetadataEntity.setName(crd.getName());
        updateApplicationMetadataEntity.setValue(crd.getValue());
        updateApplicationMetadataEntity.setFormat(crd.getFormat());
        updateApplicationMetadataEntity.setDefaultValue(crd.getDefaultValue());
        updateApplicationMetadataEntity.setHidden(crd.isHidden());
        updateApplicationMetadataEntity.setKey(crd.getKey());
        return updateApplicationMetadataEntity;
    }

    public record Input(AuditInfo auditInfo, ApplicationCRDSpec crd) {
    }

    public record Output(ApplicationCRDStatus status) {
    }
}

