/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.query_service.api;

import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.ApiSearchCriteria;
import io.gravitee.apim.core.api.model.Sortable;
import io.gravitee.apim.core.api.query_service.ApiQueryService;
import io.gravitee.apim.infra.adapter.ApiAdapter;
import io.gravitee.apim.infra.adapter.ApiFieldFilterAdapter;
import io.gravitee.apim.infra.adapter.ApiSearchCriteriaAdapter;
import io.gravitee.apim.infra.adapter.SortableAdapter;
import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.search.ApiCriteria;
import io.gravitee.repository.management.api.search.ApiFieldFilter;
import io.gravitee.repository.management.api.search.Sortable;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ApiQueryServiceImpl
extends AbstractService
implements ApiQueryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiQueryServiceImpl.class);
    private final ApiRepository apiRepository;

    public ApiQueryServiceImpl(@Lazy ApiRepository apiRepository) {
        this.apiRepository = apiRepository;
    }

    @Override
    public Page<Api> search(ApiSearchCriteria apiCriteria, io.gravitee.apim.core.api.model.Sortable sortable, Pageable pageable, io.gravitee.apim.core.api.model.ApiFieldFilter apiFieldFilter) {
        return this.apiRepository.search(apiCriteria == null ? null : ApiSearchCriteriaAdapter.INSTANCE.toCriteriaForRepository(apiCriteria), sortable == null ? null : SortableAdapter.INSTANCE.toSortableForRepository(sortable), ApiQueryServiceImpl.convert(pageable), apiFieldFilter == null ? null : ApiFieldFilterAdapter.INSTANCE.toApiFieldFilterForRepository(apiFieldFilter)).map(ApiAdapter.INSTANCE::toCoreModel);
    }

    @Override
    public Stream<Api> search(ApiSearchCriteria apiCriteria, io.gravitee.apim.core.api.model.Sortable sortable, io.gravitee.apim.core.api.model.ApiFieldFilter apiFieldFilter) {
        return ApiAdapter.INSTANCE.toCoreModelStream(this.apiRepository.search(apiCriteria == null ? null : ApiSearchCriteriaAdapter.INSTANCE.toCriteriaForRepository(apiCriteria), sortable == null ? null : SortableAdapter.INSTANCE.toSortableForRepository(sortable), apiFieldFilter == null ? null : ApiFieldFilterAdapter.INSTANCE.toApiFieldFilterForRepository(apiFieldFilter)));
    }

    @Override
    public Optional<Api> findByEnvironmentIdAndCrossId(String environmentId, String crossId) {
        try {
            return this.apiRepository.findByEnvironmentIdAndCrossId(environmentId, crossId).map(ApiAdapter.INSTANCE::toCoreModel);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(e);
        }
    }

    @Override
    public Page<Api> findByIntegrationId(String integrationId, Pageable pageable) {
        ApiCriteria searchCriteria = new ApiCriteria.Builder().integrationId(integrationId).build();
        Sortable sortable = SortableAdapter.INSTANCE.toSortableForRepository(io.gravitee.apim.core.api.model.Sortable.builder().field("updatedAt").order(Sortable.Order.DESC).build());
        ApiFieldFilter fieldFilter = new ApiFieldFilter.Builder().excludeDefinition().excludePicture().build();
        return this.apiRepository.search(searchCriteria, sortable, ApiQueryServiceImpl.convert(pageable), fieldFilter).map(ApiAdapter.INSTANCE::toCoreModel);
    }
}

