/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.PageRevisionRepository;
import io.gravitee.repository.management.api.search.Pageable;
import io.gravitee.repository.management.model.Page;
import io.gravitee.repository.management.model.PageRevision;
import io.gravitee.rest.api.model.PageRevisionEntity;
import io.gravitee.rest.api.model.PageType;
import io.gravitee.rest.api.service.PageRevisionService;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.TransactionalService;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Hex;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class PageRevisionServiceImpl
extends TransactionalService
implements PageRevisionService {
    private static final Logger logger = LoggerFactory.getLogger(PageRevisionServiceImpl.class);
    private static final String HASH_ALGO = "sha-256";
    @Lazy
    @Autowired
    private PageRevisionRepository pageRevisionRepository;

    @Override
    public io.gravitee.common.data.domain.Page<PageRevisionEntity> findAll(Pageable pageable) {
        logger.debug("get all page revisions with pageable {}", (Object)pageable);
        try {
            return this.pageRevisionRepository.findAll(pageable).map(this::convert);
        }
        catch (TechnicalException e) {
            logger.warn("An error occurs while trying to get the page revisions {}", (Object)pageable, (Object)e);
            throw new TechnicalManagementException("An error occurs while trying to get all page revisions", e);
        }
    }

    @Override
    public Optional<PageRevisionEntity> findById(String pageId, int revision) {
        logger.debug("get page revision {}-{}", (Object)pageId, (Object)revision);
        try {
            return this.pageRevisionRepository.findById(pageId, revision).map(this::convert);
        }
        catch (TechnicalException e) {
            logger.warn("An error occurs while trying to get the page revision {}-{}", new Object[]{pageId, revision, e});
            throw new TechnicalManagementException("An error occurs while trying to get a page revision", e);
        }
    }

    @Override
    public Optional<PageRevisionEntity> findLastByPageId(String pageId) {
        logger.debug("get last revision for page {}", (Object)pageId);
        try {
            return this.pageRevisionRepository.findLastByPageId(pageId).map(this::convert);
        }
        catch (TechnicalException e) {
            logger.warn("An error occurs while trying to get the last revision for page {}", (Object)pageId, (Object)e);
            throw new TechnicalManagementException("An error occurs while trying to get the last page revision", e);
        }
    }

    @Override
    public List<PageRevisionEntity> findAllByPageId(String pageId) {
        logger.debug("get all revisions for page {}", (Object)pageId);
        try {
            return this.pageRevisionRepository.findAllByPageId(pageId).stream().map(this::convert).collect(Collectors.toList());
        }
        catch (TechnicalException e) {
            logger.warn("An error occurs while trying to get all the revisions for page {}", (Object)pageId, (Object)e);
            throw new TechnicalManagementException("An error occurs while trying to get all revisions", e);
        }
    }

    @Override
    public PageRevisionEntity create(Page page) {
        try {
            logger.debug("Create page revision for page {}", (Object)page.getId());
            PageType type = PageType.valueOf((String)page.getType());
            if (type != PageType.MARKDOWN && type != PageType.SWAGGER && type != PageType.TRANSLATION) {
                throw new TechnicalManagementException("Invalid page type for revision");
            }
            PageRevision revision = this.pageRevisionRepository.create(this.convert(page));
            return this.convert(revision);
        }
        catch (TechnicalException e) {
            logger.warn("An error occurs while trying to create a revision for page {}", (Object)page.getId(), (Object)e);
            throw new TechnicalManagementException("An error occurs while trying to create a page revision", e);
        }
    }

    private PageRevisionEntity convert(PageRevision revision) {
        PageRevisionEntity entity = new PageRevisionEntity();
        entity.setPageId(revision.getPageId());
        entity.setRevision(revision.getRevision());
        entity.setName(revision.getName());
        entity.setContent(revision.getContent());
        entity.setHash(revision.getHash());
        entity.setContributor(revision.getContributor());
        entity.setModificationDate(revision.getCreatedAt());
        return entity;
    }

    private PageRevision convert(Page page) {
        PageRevision revision = new PageRevision();
        revision.setPageId(page.getId());
        revision.setRevision(this.findLastByPageId(page.getId()).map(rev -> rev.getRevision() + 1).orElse(1).intValue());
        revision.setName(page.getName());
        revision.setContent(page.getContent());
        revision.setContributor(page.getLastContributor());
        revision.setCreatedAt(page.getUpdatedAt());
        revision.setHash(this.computeHash(revision));
        return revision;
    }

    private String computeHash(PageRevision page) {
        try {
            String canonicalRevision = this.canonicalRevision(page);
            MessageDigest md = MessageDigest.getInstance(HASH_ALGO);
            md.update(canonicalRevision.getBytes());
            byte[] digest = md.digest();
            return Hex.encodeHexString((byte[])digest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new TechnicalManagementException("Unable to instantiate MessageDigest", e);
        }
    }

    @NotNull
    private String canonicalRevision(PageRevision page) {
        StringBuilder builder = new StringBuilder();
        builder.append(Optional.ofNullable(page.getName()).map(c -> c.trim()).orElse(""));
        builder.append('\n');
        builder.append(Optional.ofNullable(page.getContent()).map(c -> c.trim()).orElse(""));
        builder.append('\n');
        builder.append(page.getContributor());
        builder.append('\n');
        builder.append(page.getCreatedAt().getTime());
        builder.append('\n');
        return builder.toString();
    }
}

