/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.subscription.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api_key.domain_service.RevokeApiKeyDomainService;
import io.gravitee.apim.core.application.crud_service.ApplicationCrudService;
import io.gravitee.apim.core.audit.domain_service.AuditDomainService;
import io.gravitee.apim.core.audit.model.ApiAuditLogEntity;
import io.gravitee.apim.core.audit.model.ApplicationAuditLogEntity;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.AuditProperties;
import io.gravitee.apim.core.audit.model.event.SubscriptionAuditEvent;
import io.gravitee.apim.core.integration.service_provider.IntegrationAgent;
import io.gravitee.apim.core.notification.domain_service.TriggerNotificationDomainService;
import io.gravitee.apim.core.notification.model.hook.SubscriptionClosedApiHookContext;
import io.gravitee.apim.core.notification.model.hook.SubscriptionClosedApplicationHookContext;
import io.gravitee.apim.core.subscription.crud_service.SubscriptionCrudService;
import io.gravitee.apim.core.subscription.domain_service.RejectSubscriptionDomainService;
import io.gravitee.apim.core.subscription.model.SubscriptionEntity;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.federation.FederatedApi;
import io.gravitee.rest.api.model.BaseApplicationEntity;
import io.gravitee.rest.api.model.context.OriginContext;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.util.Collections;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DomainService
public class CloseSubscriptionDomainService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CloseSubscriptionDomainService.class);
    private final SubscriptionCrudService subscriptionCrudService;
    private final RejectSubscriptionDomainService rejectSubscriptionDomainService;
    private final TriggerNotificationDomainService triggerNotificationDomainService;
    private final AuditDomainService auditDomainService;
    private final ApplicationCrudService applicationCrudService;
    private final RevokeApiKeyDomainService revokeApiKeyDomainService;
    private final ApiCrudService apiCrudService;
    private final IntegrationAgent integrationAgent;

    public CloseSubscriptionDomainService(SubscriptionCrudService subscriptionCrudService, ApplicationCrudService applicationCrudService, AuditDomainService auditDomainService, TriggerNotificationDomainService triggerNotificationDomainService, RejectSubscriptionDomainService rejectSubscriptionDomainService, RevokeApiKeyDomainService revokeApiKeyDomainService, ApiCrudService apiCrudService, IntegrationAgent integrationAgent) {
        this.subscriptionCrudService = subscriptionCrudService;
        this.rejectSubscriptionDomainService = rejectSubscriptionDomainService;
        this.triggerNotificationDomainService = triggerNotificationDomainService;
        this.auditDomainService = auditDomainService;
        this.applicationCrudService = applicationCrudService;
        this.revokeApiKeyDomainService = revokeApiKeyDomainService;
        this.apiCrudService = apiCrudService;
        this.integrationAgent = integrationAgent;
    }

    public SubscriptionEntity closeSubscription(String subscriptionId, AuditInfo auditInfo) {
        SubscriptionEntity subscription = this.subscriptionCrudService.get(subscriptionId);
        Api plan = this.apiCrudService.get(subscription.getApiId());
        return this.closeSubscription(subscription, plan, auditInfo);
    }

    public SubscriptionEntity closeSubscription(String subscriptionId, Api api, AuditInfo auditInfo) {
        SubscriptionEntity subscription = this.subscriptionCrudService.get(subscriptionId);
        return this.closeSubscription(subscription, api, auditInfo);
    }

    public SubscriptionEntity closeSubscription(SubscriptionEntity subscription, Api api, AuditInfo auditInfo) {
        log.debug("Close subscription {}", (Object)subscription.getId());
        return switch (subscription.getStatus()) {
            default -> throw new IncompatibleClassChangeError();
            case SubscriptionEntity.Status.ACCEPTED, SubscriptionEntity.Status.PAUSED -> this.closeAcceptedOrPausedSubscription(subscription, api, auditInfo);
            case SubscriptionEntity.Status.PENDING -> this.rejectSubscriptionDomainService.reject(subscription, "Subscription has been closed.", auditInfo);
            case SubscriptionEntity.Status.CLOSED, SubscriptionEntity.Status.REJECTED -> subscription;
        };
    }

    private SubscriptionEntity closeAcceptedOrPausedSubscription(SubscriptionEntity subscriptionEntity, Api api, AuditInfo auditInfo) {
        OriginContext originContext;
        if (api.getDefinitionVersion() == DefinitionVersion.FEDERATED && (originContext = api.getOriginContext()) instanceof OriginContext.Integration) {
            OriginContext.Integration inte = (OriginContext.Integration)originContext;
            FederatedApi federatedApi = api.getFederatedApiDefinition();
            this.integrationAgent.unsubscribe(inte.integrationId(), federatedApi, subscriptionEntity).blockingAwait();
        }
        SubscriptionEntity closedSubscriptionEntity = this.subscriptionCrudService.update(subscriptionEntity.close());
        this.triggerNotifications(closedSubscriptionEntity, auditInfo);
        this.createAuditLog(subscriptionEntity, closedSubscriptionEntity, auditInfo);
        this.revokeApiKeys(subscriptionEntity, auditInfo);
        return closedSubscriptionEntity;
    }

    private void triggerNotifications(SubscriptionEntity closedSubscriptionEntity, AuditInfo auditInfo) {
        this.triggerNotificationDomainService.triggerApiNotification(auditInfo.organizationId(), auditInfo.environmentId(), new SubscriptionClosedApiHookContext(closedSubscriptionEntity.getApiId(), closedSubscriptionEntity.getApplicationId(), closedSubscriptionEntity.getPlanId()));
        this.triggerNotificationDomainService.triggerApplicationNotification(auditInfo.organizationId(), auditInfo.environmentId(), new SubscriptionClosedApplicationHookContext(closedSubscriptionEntity.getApplicationId(), closedSubscriptionEntity.getApiId(), closedSubscriptionEntity.getPlanId()));
    }

    private void createAuditLog(SubscriptionEntity originalSubscription, SubscriptionEntity closedSubscription, AuditInfo auditInfo) {
        this.auditDomainService.createApiAuditLog(ApiAuditLogEntity.builder().organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).apiId(originalSubscription.getApiId()).event(SubscriptionAuditEvent.SUBSCRIPTION_CLOSED).oldValue(originalSubscription).newValue(closedSubscription).actor(auditInfo.actor()).createdAt(closedSubscription.getUpdatedAt()).properties(Collections.singletonMap(AuditProperties.APPLICATION, originalSubscription.getApplicationId())).build());
        this.auditDomainService.createApplicationAuditLog(ApplicationAuditLogEntity.builder().organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).applicationId(originalSubscription.getApplicationId()).event(SubscriptionAuditEvent.SUBSCRIPTION_CLOSED).oldValue(originalSubscription).newValue(closedSubscription).actor(auditInfo.actor()).createdAt(closedSubscription.getUpdatedAt()).properties(Collections.singletonMap(AuditProperties.API, originalSubscription.getApiId())).build());
    }

    private void revokeApiKeys(SubscriptionEntity subscriptionEntity, AuditInfo auditInfo) {
        BaseApplicationEntity application = this.applicationCrudService.findById(new ExecutionContext(auditInfo.organizationId(), auditInfo.environmentId()), subscriptionEntity.getApplicationId());
        if (!application.hasApiKeySharedMode()) {
            this.revokeApiKeyDomainService.revokeAllSubscriptionsApiKeys(subscriptionEntity, auditInfo);
        }
    }
}

