/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.membership.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.group.model.Group;
import io.gravitee.apim.core.group.query_service.GroupQueryService;
import io.gravitee.apim.core.membership.exception.ApiPrimaryOwnerNotFoundException;
import io.gravitee.apim.core.membership.exception.ApplicationPrimaryOwnerNotFoundException;
import io.gravitee.apim.core.membership.model.Membership;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.apim.core.membership.model.Role;
import io.gravitee.apim.core.membership.query_service.MembershipQueryService;
import io.gravitee.apim.core.membership.query_service.RoleQueryService;
import io.gravitee.apim.core.user.crud_service.UserCrudService;
import io.gravitee.apim.core.user.model.BaseUserEntity;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.service.common.ReferenceContext;
import java.util.Optional;

@DomainService
public class ApplicationPrimaryOwnerDomainService {
    private final GroupQueryService groupQueryService;
    private final MembershipQueryService membershipQueryService;
    private final RoleQueryService roleQueryService;
    private final UserCrudService userCrudService;

    public ApplicationPrimaryOwnerDomainService(GroupQueryService groupQueryService, MembershipQueryService membershipQueryService, RoleQueryService roleQueryService, UserCrudService userCrudService) {
        this.groupQueryService = groupQueryService;
        this.membershipQueryService = membershipQueryService;
        this.roleQueryService = roleQueryService;
        this.userCrudService = userCrudService;
    }

    public PrimaryOwnerEntity getApplicationPrimaryOwner(String organizationId, String applicationId) throws ApiPrimaryOwnerNotFoundException {
        return (PrimaryOwnerEntity)this.findPrimaryOwnerRole(organizationId).flatMap(role -> this.findApplicationPrimaryOwnerMembership(applicationId, (Role)role).flatMap(membership -> switch (membership.getMemberType()) {
            default -> throw new IncompatibleClassChangeError();
            case Membership.Type.USER -> this.findUserPrimaryOwner((Membership)membership);
            case Membership.Type.GROUP -> this.findGroupPrimaryOwner((Membership)membership, role.getId());
        })).orElseThrow(() -> new ApplicationPrimaryOwnerNotFoundException(applicationId));
    }

    private Optional<Role> findPrimaryOwnerRole(String organizationId) {
        return this.roleQueryService.findApplicationRole(SystemRole.PRIMARY_OWNER.name(), ReferenceContext.builder().referenceType(ReferenceContext.Type.ORGANIZATION).referenceId(organizationId).build());
    }

    private Optional<Membership> findApplicationPrimaryOwnerMembership(String apiId, Role role) {
        return this.membershipQueryService.findByReferenceAndRoleId(Membership.ReferenceType.APPLICATION, apiId, role.getId()).stream().findFirst();
    }

    private Optional<PrimaryOwnerEntity> findUserPrimaryOwner(Membership membership) {
        return this.userCrudService.findBaseUserById(membership.getMemberId()).map(user -> PrimaryOwnerEntity.builder().id(user.getId()).displayName(user.displayName()).email(user.getEmail()).type(PrimaryOwnerEntity.Type.USER).build());
    }

    private Optional<PrimaryOwnerEntity> findGroupPrimaryOwner(Membership membership, String primaryOwnerRoleId) {
        Optional<Group> group = this.groupQueryService.findById(membership.getMemberId());
        Optional user = this.findPrimaryOwnerGroupMember(membership.getMemberId(), primaryOwnerRoleId).flatMap(m -> this.userCrudService.findBaseUserById(m.getMemberId()));
        return group.map(value -> PrimaryOwnerEntity.builder().id(value.getId()).displayName(value.getName()).type(PrimaryOwnerEntity.Type.GROUP).email(user.map(BaseUserEntity::getEmail).orElse(null)).build());
    }

    private Optional<Membership> findPrimaryOwnerGroupMember(String groupId, String primaryOwnerRoleId) {
        return this.membershipQueryService.findByReferenceAndRoleId(Membership.ReferenceType.GROUP, groupId, primaryOwnerRoleId).stream().findFirst();
    }
}

