/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.integration.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.environment.crud_service.EnvironmentCrudService;
import io.gravitee.apim.core.environment.model.Environment;
import io.gravitee.apim.core.integration.crud_service.IntegrationCrudService;
import io.gravitee.apim.core.permission.domain_service.PermissionDomainService;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import lombok.Generated;

@UseCase
public class CheckIntegrationUseCase {
    private final IntegrationCrudService integrationCrudService;
    private final EnvironmentCrudService environmentCrudService;
    private final PermissionDomainService permissionDomainService;

    public Output execute(Input input) {
        return this.integrationCrudService.findById(input.integrationId).filter(integration -> {
            Environment environment = this.environmentCrudService.get(integration.getEnvironmentId());
            return environment.getOrganizationId().equals(input.organizationId);
        }).filter(integration -> {
            boolean hasEnvironmentIntegrationPermission = this.permissionDomainService.hasExactPermissions(input.organizationId, input.userId, RolePermission.ENVIRONMENT_INTEGRATION, integration.getEnvironmentId(), RolePermissionAction.CREATE, RolePermissionAction.READ, RolePermissionAction.UPDATE, RolePermissionAction.DELETE);
            boolean hasIntegrationPermission = this.permissionDomainService.hasPermission(input.organizationId, input.userId, RolePermission.INTEGRATION_DEFINITION, integration.getId(), RolePermissionAction.CREATE);
            return hasEnvironmentIntegrationPermission || hasIntegrationPermission;
        }).map(integration -> {
            if (!integration.getProvider().equals(input.provider)) {
                return new Output(false, String.format("Integration [id=%s] does not match. Expected provider [provider=%s]", integration.getId(), integration.getProvider()));
            }
            return new Output(true);
        }).orElse(new Output(false, String.format("Integration [id=%s] not found", input.integrationId)));
    }

    @Generated
    public CheckIntegrationUseCase(IntegrationCrudService integrationCrudService, EnvironmentCrudService environmentCrudService, PermissionDomainService permissionDomainService) {
        this.integrationCrudService = integrationCrudService;
        this.environmentCrudService = environmentCrudService;
        this.permissionDomainService = permissionDomainService;
    }

    public record Input(String organizationId, String userId, String integrationId, String provider) {
        public Input(String integrationId) {
            this(null, null, integrationId, null);
        }
    }

    public record Output(boolean success, String message) {
        public Output(boolean success) {
            this(success, null);
        }
    }
}

