/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.domain_service.parameters;

import io.gravitee.apim.core.parameters.domain_service.ParametersDomainService;
import io.gravitee.repository.management.model.Parameter;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.stereotype.Service;

@Service
public class ParametersDomainServiceImpl
implements ParametersDomainService {
    private final ConfigurableEnvironment environment;
    private final ParameterService parameterService;

    @Override
    public Map<Key, String> getSystemParameters(List<Key> keys) {
        return keys.stream().map(this::getSystemParameter).filter(Objects::nonNull).collect(Collectors.toMap(parameter -> Key.findByKey((String)parameter.getKey()), Parameter::getValue));
    }

    @Override
    public Map<Key, String> getEnvironmentParameters(ExecutionContext executionContext, List<Key> keys) {
        return this.parameterService.findAll(executionContext, keys, Function.identity(), ParameterReferenceType.ENVIRONMENT).entrySet().stream().filter(es -> !((List)es.getValue()).isEmpty()).collect(Collectors.toMap(es -> Key.findByKey((String)((String)es.getKey())), es -> (String)((List)es.getValue()).get(0)));
    }

    private Parameter getSystemParameter(Key key) {
        if (this.environment.containsProperty(key.key())) {
            Parameter parameter = new Parameter();
            parameter.setKey(key.key());
            parameter.setValue(this.environment.getProperty(key.key()));
            return parameter;
        }
        return null;
    }

    @Generated
    public ParametersDomainServiceImpl(ConfigurableEnvironment environment, ParameterService parameterService) {
        this.environment = environment;
        this.parameterService = parameterService;
    }
}

