/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.configuration.identity;

import io.gravitee.rest.api.model.configuration.identity.IdentityProviderActivationReferenceType;
import io.gravitee.rest.api.service.exceptions.AbstractNotFoundException;
import java.util.HashMap;
import java.util.Map;

public class IdentityProviderActivationNotFoundException
extends AbstractNotFoundException {
    private final String identityProviderId;
    private final String referenceId;
    private final IdentityProviderActivationReferenceType referenceType;

    public IdentityProviderActivationNotFoundException(String identityProviderId, String referenceId, IdentityProviderActivationReferenceType referenceType) {
        this.identityProviderId = identityProviderId;
        this.referenceId = referenceId;
        this.referenceType = referenceType;
    }

    @Override
    public String getMessage() {
        return String.format("Identity Provider [{}] is not Activated for {}:{}.", this.identityProviderId, this.referenceType.name(), this.referenceId);
    }

    @Override
    public String getTechnicalCode() {
        return "identityProvider.notActivated";
    }

    @Override
    public Map<String, String> getParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("identityProviderId", this.identityProviderId);
        parameters.put("referenceId", this.referenceId);
        parameters.put("referenceType", this.referenceType.name());
        return parameters;
    }
}

