/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.integration.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.environment.crud_service.EnvironmentCrudService;
import io.gravitee.apim.core.environment.model.Environment;
import io.gravitee.apim.core.integration.crud_service.IntegrationCrudService;
import io.gravitee.apim.core.integration.model.Integration;

@UseCase
public class UpdateAgentStatusUseCase {
    private final IntegrationCrudService integrationCrudService;
    private final EnvironmentCrudService environmentCrudService;

    public UpdateAgentStatusUseCase(IntegrationCrudService integrationCrudService, EnvironmentCrudService environmentCrudService) {
        this.integrationCrudService = integrationCrudService;
        this.environmentCrudService = environmentCrudService;
    }

    public Output execute(Input input) {
        return this.integrationCrudService.findById(input.integrationId).filter(integration -> {
            if (input.agentStatus == Integration.AgentStatus.DISCONNECTED) {
                return true;
            }
            Environment environment = this.environmentCrudService.get(integration.getEnvironmentId());
            return environment.getOrganizationId().equals(input.organizationId);
        }).map(integration -> {
            if (input.agentStatus == Integration.AgentStatus.CONNECTED && !integration.getProvider().equals(input.provider)) {
                return new Output(false, String.format("Integration [id=%s] does not match. Expected provider [provider=%s]", integration.getId(), integration.getProvider()));
            }
            this.integrationCrudService.update(switch (input.agentStatus) {
                default -> throw new IncompatibleClassChangeError();
                case Integration.AgentStatus.CONNECTED -> integration.agentConnected();
                case Integration.AgentStatus.DISCONNECTED -> integration.agentDisconnected();
            });
            return new Output(true);
        }).orElse(new Output(false, String.format("Integration [id=%s] not found", input.integrationId)));
    }

    public record Input(String organizationId, String integrationId, String provider, Integration.AgentStatus agentStatus) {
        public Input(String integrationId, Integration.AgentStatus agentStatus) {
            this(null, integrationId, null, agentStatus);
        }
    }

    public record Output(boolean success, String message) {
        public Output(boolean success) {
            this(success, null);
        }
    }
}

