/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.documentation.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.model.ApiMetadata;
import io.gravitee.apim.core.api.query_service.ApiMetadataQueryService;
import io.gravitee.apim.core.documentation.crud_service.PageCrudService;
import io.gravitee.apim.core.documentation.domain_service.ApiDocumentationDomainService;
import io.gravitee.apim.core.documentation.domain_service.OpenApiDomainService;
import io.gravitee.apim.core.documentation.domain_service.PageSourceDomainService;
import io.gravitee.apim.core.documentation.domain_service.TemplateResolverDomainService;
import io.gravitee.apim.core.documentation.exception.InvalidPageNameException;
import io.gravitee.apim.core.documentation.exception.InvalidPageParentException;
import io.gravitee.apim.core.documentation.model.ApiFreemarkerTemplate;
import io.gravitee.apim.core.documentation.model.Page;
import io.gravitee.apim.core.membership.domain_service.ApiPrimaryOwnerDomainService;
import io.gravitee.apim.core.sanitizer.HtmlSanitizer;
import io.gravitee.apim.core.sanitizer.SanitizeResult;
import io.gravitee.rest.api.service.exceptions.PageContentUnsafeException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

@DomainService
public class DocumentationValidationDomainService {
    private final HtmlSanitizer htmlSanitizer;
    private final TemplateResolverDomainService templateResolverDomainService;
    private final ApiCrudService apiCrudService;
    private final OpenApiDomainService openApiDomainService;
    private final ApiMetadataQueryService apiMetadataQueryService;
    private final ApiPrimaryOwnerDomainService apiPrimaryOwnerDomainService;
    private final ApiDocumentationDomainService apiDocumentationDomainService;
    private final PageCrudService pageCrudService;
    private final PageSourceDomainService pageSourceDomainService;

    public String sanitizeDocumentationName(String name) {
        if (null == name || name.trim().isEmpty()) {
            throw new InvalidPageNameException();
        }
        return name.trim();
    }

    public void validateContent(String content, String apiId, String organizationId) {
        this.validateContentIsSafe(content);
        this.validateTemplate(content, apiId, organizationId);
    }

    public void validateContentIsSafe(String content) {
        SanitizeResult sanitizeInfos = this.htmlSanitizer.isSafe(content);
        if (!sanitizeInfos.isSafe()) {
            throw new PageContentUnsafeException(sanitizeInfos.getRejectedMessage());
        }
    }

    public void validateTemplate(String pageContent, String apiId, String organizationId) {
        Map<String, String> metadata = this.apiMetadataQueryService.findApiMetadata(apiId).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((ApiMetadata)entry.getValue()).getValue() != null ? ((ApiMetadata)entry.getValue()).getValue() : ((ApiMetadata)entry.getValue()).getDefaultValue()));
        ApiFreemarkerTemplate api = new ApiFreemarkerTemplate(this.apiCrudService.get(apiId), metadata, this.apiPrimaryOwnerDomainService.getApiPrimaryOwner(organizationId, apiId));
        this.templateResolverDomainService.resolveTemplate(pageContent, Map.of("api", api));
    }

    public void parseOpenApiContent(String content) {
        if (content != null) {
            this.openApiDomainService.parseOpenApiContent(content);
        }
    }

    public Page validateAndSanitizeForCreation(Page page, String organizationId) {
        return this.validateAndSanitizeForCreation(page, organizationId, true);
    }

    public Page validateAndSanitizeForCreation(Page page, String organizationId, boolean shouldValidateParentId) {
        Page sanitizedPage = page.toBuilder().name(this.sanitizeDocumentationName(page.getName())).build();
        this.pageSourceDomainService.setContentFromSource(sanitizedPage);
        this.validatePageContent(organizationId, sanitizedPage);
        if (shouldValidateParentId) {
            this.validateParentId(sanitizedPage);
        }
        this.validateNameIsUnique(sanitizedPage);
        return sanitizedPage;
    }

    public Page validateAndSanitizeForUpdate(Page page, String organizationId, boolean shouldValidateParentId) {
        this.pageSourceDomainService.setContentFromSource(page);
        this.validatePageContent(organizationId, page);
        if (shouldValidateParentId) {
            this.validateParentId(page);
        }
        return page;
    }

    private void validatePageContent(String organizationId, Page sanitizedPage) {
        if (sanitizedPage.isMarkdown()) {
            this.validateContent(sanitizedPage.getContent(), sanitizedPage.getReferenceId(), organizationId);
        } else if (sanitizedPage.isSwagger()) {
            this.parseOpenApiContent(sanitizedPage.getContent());
        }
    }

    private void validateParentId(Page page) {
        Optional<Page> foundParent;
        String parentId = page.getParentId();
        if (Objects.nonNull(parentId) && !parentId.isEmpty() && (foundParent = this.pageCrudService.findById(parentId)).isPresent()) {
            if (!foundParent.get().isFolder()) {
                throw new InvalidPageParentException(parentId);
            }
            return;
        }
        page.setParentId(null);
    }

    private void validateNameIsUnique(Page page) {
        this.apiDocumentationDomainService.validateNameIsUnique(page.getReferenceId(), page.getParentId(), page.getName(), page.getType());
    }

    @Generated
    public DocumentationValidationDomainService(HtmlSanitizer htmlSanitizer, TemplateResolverDomainService templateResolverDomainService, ApiCrudService apiCrudService, OpenApiDomainService openApiDomainService, ApiMetadataQueryService apiMetadataQueryService, ApiPrimaryOwnerDomainService apiPrimaryOwnerDomainService, ApiDocumentationDomainService apiDocumentationDomainService, PageCrudService pageCrudService, PageSourceDomainService pageSourceDomainService) {
        this.htmlSanitizer = htmlSanitizer;
        this.templateResolverDomainService = templateResolverDomainService;
        this.apiCrudService = apiCrudService;
        this.openApiDomainService = openApiDomainService;
        this.apiMetadataQueryService = apiMetadataQueryService;
        this.apiPrimaryOwnerDomainService = apiPrimaryOwnerDomainService;
        this.apiDocumentationDomainService = apiDocumentationDomainService;
        this.pageCrudService = pageCrudService;
        this.pageSourceDomainService = pageSourceDomainService;
    }
}

