/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.api.model.crd.ApiCRDSpec;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.apim.infra.adapter.ApiAdapterDecorator;
import io.gravitee.apim.infra.adapter.GraviteeJacksonMapper;
import io.gravitee.apim.infra.adapter.PlanAdapter;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.federation.FederatedApi;
import io.gravitee.definition.model.v4.Api;
import io.gravitee.rest.api.model.federation.FederatedApiEntity;
import io.gravitee.rest.api.model.v4.api.ApiEntity;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.model.v4.api.NewApiEntity;
import io.gravitee.rest.api.model.v4.api.UpdateApiEntity;
import java.io.IOException;
import java.util.stream.Stream;
import org.mapstruct.DecoratedWith;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.ValueMapping;
import org.mapstruct.factory.Mappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mapper(uses={PlanAdapter.class})
@DecoratedWith(value=ApiAdapterDecorator.class)
public interface ApiAdapter {
    public static final Logger LOGGER = LoggerFactory.getLogger(ApiAdapter.class);
    public static final ApiAdapter INSTANCE = (ApiAdapter)Mappers.getMapper(ApiAdapter.class);

    @Mappings(value={@Mapping(target="apiDefinitionV4", expression="java(deserializeApiDefinitionV4(source))"), @Mapping(target="apiDefinition", expression="java(deserializeApiDefinitionV2(source))"), @Mapping(target="federatedApiDefinition", expression="java(deserializeFederatedApiDefinition(source))")})
    public io.gravitee.apim.core.api.model.Api toCoreModel(io.gravitee.repository.management.model.Api var1);

    public Stream<io.gravitee.apim.core.api.model.Api> toCoreModelStream(Stream<io.gravitee.repository.management.model.Api> var1);

    @Mapping(target="definition", expression="java(serializeApiDefinition(source))")
    public io.gravitee.repository.management.model.Api toRepository(io.gravitee.apim.core.api.model.Api var1);

    public Stream<io.gravitee.repository.management.model.Api> toRepositoryStream(Stream<io.gravitee.apim.core.api.model.Api> var1);

    @Mappings(value={@Mapping(target="apiVersion", source="version"), @Mapping(target="tags", source="apiDefinitionV4.tags"), @Mapping(target="listeners", source="apiDefinitionV4.listeners"), @Mapping(target="endpointGroups", source="apiDefinitionV4.endpointGroups"), @Mapping(target="analytics", source="apiDefinitionV4.analytics"), @Mapping(target="flowExecution", source="apiDefinitionV4.flowExecution"), @Mapping(target="flows", source="apiDefinitionV4.flows")})
    public NewApiEntity toNewApiEntity(io.gravitee.apim.core.api.model.Api var1);

    @Mapping(target="apiVersion", source="version")
    public Api toApiDefinition(ApiCRDSpec var1);

    @ValueMapping(source="<ANY_REMAINING>", target="<NULL>")
    @Mappings(value={@Mapping(source="version", target="apiVersion"), @Mapping(target="disableMembershipNotifications", expression="java(!spec.isNotifyMembers())")})
    public UpdateApiEntity toUpdateApiEntity(ApiCRDSpec var1);

    @ValueMapping(source="<ANY_REMAINING>", target="<NULL>")
    @Mappings(value={@Mapping(target="id", source="api.id"), @Mapping(target="name", source="api.name"), @Mapping(target="definitionVersion", source="api.definitionVersion"), @Mapping(target="type", source="api.type"), @Mapping(target="tags", source="api.tags"), @Mapping(target="apiVersion", source="api.version"), @Mapping(target="lifecycleState", source="api.apiLifecycleState")})
    public UpdateApiEntity toUpdateApiEntity(io.gravitee.apim.core.api.model.Api var1, Api var2);

    @ValueMapping(source="<ANY_REMAINING>", target="<NULL>")
    @Mappings(value={@Mapping(source="version", target="apiVersion"), @Mapping(target="metadata", ignore=true)})
    public ApiEntity toApiEntity(ApiCRDSpec var1);

    @ValueMapping(source="<ANY_REMAINING>", target="<NULL>")
    @Mappings(value={@Mapping(source="version", target="apiVersion"), @Mapping(target="metadata", ignore=true)})
    public ApiEntity toApiEntity(io.gravitee.apim.core.api.model.Api var1);

    @ValueMapping(source="<ANY_REMAINING>", target="<NULL>")
    @Mappings(value={@Mapping(source="source.version", target="apiVersion"), @Mapping(source="source.id", target="id"), @Mapping(target="primaryOwner", source="primaryOwnerEntity"), @Mapping(target="referenceId", source="source.environmentId"), @Mapping(target="referenceType", constant="ENVIRONMENT"), @Mapping(source="source.apiLifecycleState", target="lifecycleState")})
    public FederatedApiEntity toFederatedApiEntity(io.gravitee.repository.management.model.Api var1, PrimaryOwnerEntity var2);

    @Mappings(value={@Mapping(source="state", target="lifecycleState"), @Mapping(source="lifecycleState", target="apiLifecycleState")})
    @ValueMapping(source="<ANY_REMAINING>", target="<NULL>")
    public io.gravitee.apim.core.api.model.Api fromApiEntity(GenericApiEntity var1);

    default public Api deserializeApiDefinitionV4(io.gravitee.repository.management.model.Api api) {
        if (api.getDefinition() == null) {
            return null;
        }
        if (api.getDefinitionVersion() == DefinitionVersion.V4) {
            try {
                return (Api)GraviteeJacksonMapper.getInstance().readValue(api.getDefinition(), Api.class);
            }
            catch (IOException ioe) {
                LOGGER.error("Unexpected error while deserializing V4 API definition", (Throwable)ioe);
                return null;
            }
        }
        return null;
    }

    default public io.gravitee.definition.model.Api deserializeApiDefinitionV2(io.gravitee.repository.management.model.Api api) {
        if (api.getDefinition() == null) {
            return null;
        }
        if (api.getDefinitionVersion() != DefinitionVersion.V4 && api.getDefinitionVersion() != DefinitionVersion.FEDERATED) {
            try {
                return (io.gravitee.definition.model.Api)GraviteeJacksonMapper.getInstance().readValue(api.getDefinition(), io.gravitee.definition.model.Api.class);
            }
            catch (IOException ioe) {
                LOGGER.error("Unexpected error while deserializing V2 API definition", (Throwable)ioe);
                return null;
            }
        }
        return null;
    }

    default public FederatedApi deserializeFederatedApiDefinition(io.gravitee.repository.management.model.Api api) {
        if (api.getDefinition() == null) {
            return null;
        }
        if (api.getDefinitionVersion() == DefinitionVersion.FEDERATED) {
            try {
                return (FederatedApi)GraviteeJacksonMapper.getInstance().readValue(api.getDefinition(), FederatedApi.class);
            }
            catch (IOException ioe) {
                LOGGER.error("Unexpected error while deserializing Federated API definition", (Throwable)ioe);
                return null;
            }
        }
        return null;
    }

    default public String serializeApiDefinition(io.gravitee.apim.core.api.model.Api api) {
        return switch (api.getDefinitionVersion()) {
            default -> throw new IncompatibleClassChangeError();
            case DefinitionVersion.V1, DefinitionVersion.V2 -> {
                try {
                    String var2_2;
                    yield var2_2 = GraviteeJacksonMapper.getInstance().writeValueAsString((Object)api.getApiDefinition());
                }
                catch (IOException ioe) {
                    LOGGER.error("Unexpected error while serializing V2 API definition", (Throwable)ioe);
                    Object var2_3 = null;
                    yield var2_3;
                }
            }
            case DefinitionVersion.V4 -> {
                try {
                    String var2_4;
                    yield var2_4 = GraviteeJacksonMapper.getInstance().writeValueAsString((Object)api.getApiDefinitionV4());
                }
                catch (IOException ioe) {
                    LOGGER.error("Unexpected error while serializing V4 API definition", (Throwable)ioe);
                    Object var2_5 = null;
                    yield var2_5;
                }
            }
            case DefinitionVersion.FEDERATED -> {
                try {
                    String var2_6;
                    yield var2_6 = GraviteeJacksonMapper.getInstance().writeValueAsString((Object)api.getFederatedApiDefinition());
                }
                catch (IOException ioe) {
                    LOGGER.error("Unexpected error while serializing Federated API definition", (Throwable)ioe);
                    Object var2_7 = null;
                    yield var2_7;
                }
            }
        };
    }
}

