/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.installation.model;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Map;
import lombok.Generated;

public enum InstallationType {
    STANDALONE("standalone"),
    MULTI_TENANT("multi-tenant");

    private static final Map<String, InstallationType> LABELS_MAP;
    @JsonValue
    private final String label;

    public static InstallationType fromLabel(String label) {
        if (label != null) {
            return LABELS_MAP.get(label);
        }
        return null;
    }

    @Generated
    private InstallationType(String label) {
        this.label = label;
    }

    @Generated
    public String getLabel() {
        return this.label;
    }

    static {
        LABELS_MAP = Map.of(InstallationType.STANDALONE.label, STANDALONE, InstallationType.MULTI_TENANT.label, MULTI_TENANT);
    }

    public static class Labels {
        public static final String STANDALONE = "standalone";
        public static final String MULTI_TENANT = "multi-tenant";

        @Generated
        private Labels() {
        }
    }
}

