/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.analytics.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.analytics.query_service.AnalyticsQueryService;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.exception.ApiInvalidDefinitionVersionException;
import io.gravitee.apim.core.api.exception.ApiNotFoundException;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.Api;
import io.gravitee.rest.api.model.v4.analytics.RequestsCount;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseCase
public class SearchRequestsCountAnalyticsUseCase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SearchRequestsCountAnalyticsUseCase.class);
    private final AnalyticsQueryService analyticsQueryService;
    private final ApiCrudService apiCrudService;

    public Output execute(ExecutionContext executionContext, Input input) {
        this.validateApiRequirements(input);
        return this.analyticsQueryService.searchRequestsCount(executionContext, input.apiId()).map(Output::new).orElse(new Output());
    }

    private void validateApiRequirements(Input input) {
        io.gravitee.apim.core.api.model.Api api = this.apiCrudService.get(input.apiId);
        SearchRequestsCountAnalyticsUseCase.validateApiDefinitionVersion(api.getDefinitionVersion(), input.apiId);
        this.validateApiIsNotTcp(api.getApiDefinitionV4());
        SearchRequestsCountAnalyticsUseCase.validateApiMultiTenancyAccess(api, input.environmentId);
    }

    private static void validateApiMultiTenancyAccess(io.gravitee.apim.core.api.model.Api api, String environmentId) {
        if (!api.belongsToEnvironment(environmentId)) {
            throw new ApiNotFoundException(api.getId());
        }
    }

    private static void validateApiDefinitionVersion(DefinitionVersion definitionVersion, String apiId) {
        if (!DefinitionVersion.V4.equals((Object)definitionVersion)) {
            throw new ApiInvalidDefinitionVersionException(apiId);
        }
    }

    private void validateApiIsNotTcp(Api apiDefinitionV4) {
        if (apiDefinitionV4.isTcpProxy()) {
            throw new IllegalArgumentException("Analytics are not supported for TCP Proxy APIs");
        }
    }

    @Generated
    public SearchRequestsCountAnalyticsUseCase(AnalyticsQueryService analyticsQueryService, ApiCrudService apiCrudService) {
        this.analyticsQueryService = analyticsQueryService;
        this.apiCrudService = apiCrudService;
    }

    public record Input(String apiId, String environmentId) {
    }

    public record Output(Optional<RequestsCount> requestsCount) {
        Output(RequestsCount requestsCount) {
            this(Optional.of(requestsCount));
        }

        Output() {
            this(new RequestsCount());
        }
    }
}

