/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.ApiMetadata;
import io.gravitee.apim.core.api.model.crd.ApiCRDSpec;
import io.gravitee.apim.core.metadata.model.Metadata;
import io.gravitee.apim.infra.adapter.ApiAdapter;
import io.gravitee.apim.infra.adapter.PlanAdapter;
import io.gravitee.common.component.Lifecycle;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.ResponseTemplate;
import io.gravitee.definition.model.v4.Api;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.definition.model.v4.analytics.Analytics;
import io.gravitee.definition.model.v4.endpointgroup.EndpointGroup;
import io.gravitee.definition.model.v4.flow.Flow;
import io.gravitee.definition.model.v4.flow.execution.FlowExecution;
import io.gravitee.definition.model.v4.listener.Listener;
import io.gravitee.definition.model.v4.plan.Plan;
import io.gravitee.definition.model.v4.property.Property;
import io.gravitee.definition.model.v4.resource.Resource;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.ApiLifecycleState;
import io.gravitee.repository.management.model.LifecycleState;
import io.gravitee.rest.api.model.ApiMetadataEntity;
import io.gravitee.rest.api.model.MetadataFormat;
import io.gravitee.rest.api.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.federation.FederatedApiEntity;
import io.gravitee.rest.api.model.v4.api.ApiEntity;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.model.v4.api.NewApiEntity;
import io.gravitee.rest.api.model.v4.api.UpdateApiEntity;
import io.gravitee.rest.api.model.v4.api.properties.PropertyEntity;
import io.gravitee.rest.api.model.v4.plan.PlanEntity;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class ApiAdapterImpl_
implements ApiAdapter {
    private final PlanAdapter planAdapter = PlanAdapter.INSTANCE;

    @Override
    public Api toCoreModel(io.gravitee.repository.management.model.Api source) {
        List list;
        Set set1;
        if (source == null) {
            return null;
        }
        Api.ApiBuilder<?, ?> api = Api.builder();
        api.id(source.getId());
        api.environmentId(source.getEnvironmentId());
        api.crossId(source.getCrossId());
        api.name(source.getName());
        api.description(source.getDescription());
        api.version(source.getVersion());
        api.definitionVersion(source.getDefinitionVersion());
        api.type(source.getType());
        if (source.getDeployedAt() != null) {
            api.deployedAt(ZonedDateTime.ofInstant(source.getDeployedAt().toInstant(), ZoneId.systemDefault()));
        }
        if (source.getCreatedAt() != null) {
            api.createdAt(ZonedDateTime.ofInstant(source.getCreatedAt().toInstant(), ZoneId.systemDefault()));
        }
        if (source.getUpdatedAt() != null) {
            api.updatedAt(ZonedDateTime.ofInstant(source.getUpdatedAt().toInstant(), ZoneId.systemDefault()));
        }
        api.visibility(this.visibilityToVisibility(source.getVisibility()));
        api.lifecycleState(this.lifecycleStateToLifecycleState(source.getLifecycleState()));
        api.picture(source.getPicture());
        Set set = source.getGroups();
        if (set != null) {
            api.groups(new LinkedHashSet<String>(set));
        }
        if ((set1 = source.getCategories()) != null) {
            api.categories(new LinkedHashSet<String>(set1));
        }
        if ((list = source.getLabels()) != null) {
            api.labels(new ArrayList<String>(list));
        }
        api.disableMembershipNotifications(source.isDisableMembershipNotifications());
        api.apiLifecycleState(this.apiLifecycleStateToApiLifecycleState(source.getApiLifecycleState()));
        api.background(source.getBackground());
        api.apiDefinitionV4(this.deserializeApiDefinitionV4(source));
        api.apiDefinition(this.deserializeApiDefinitionV2(source));
        api.federatedApiDefinition(this.deserializeFederatedApiDefinition(source));
        return api.build();
    }

    @Override
    public Stream<Api> toCoreModelStream(Stream<io.gravitee.repository.management.model.Api> source) {
        if (source == null) {
            return null;
        }
        return source.map(api -> this.toCoreModel((io.gravitee.repository.management.model.Api)api));
    }

    @Override
    public io.gravitee.repository.management.model.Api toRepository(Api source) {
        List<String> list;
        Set<String> set1;
        if (source == null) {
            return null;
        }
        Api.ApiBuilder api = io.gravitee.repository.management.model.Api.builder();
        api.id(source.getId());
        api.environmentId(source.getEnvironmentId());
        api.crossId(source.getCrossId());
        api.name(source.getName());
        api.description(source.getDescription());
        api.version(source.getVersion());
        api.definitionVersion(source.getDefinitionVersion());
        api.type(source.getType());
        if (source.getDeployedAt() != null) {
            api.deployedAt(Date.from(source.getDeployedAt().toInstant()));
        }
        if (source.getCreatedAt() != null) {
            api.createdAt(Date.from(source.getCreatedAt().toInstant()));
        }
        if (source.getUpdatedAt() != null) {
            api.updatedAt(Date.from(source.getUpdatedAt().toInstant()));
        }
        api.visibility(this.visibilityToVisibility1(source.getVisibility()));
        api.lifecycleState(this.lifecycleStateToLifecycleState1(source.getLifecycleState()));
        api.picture(source.getPicture());
        Set<String> set = source.getGroups();
        if (set != null) {
            api.groups(new LinkedHashSet<String>(set));
        }
        if ((set1 = source.getCategories()) != null) {
            api.categories(new LinkedHashSet<String>(set1));
        }
        if ((list = source.getLabels()) != null) {
            api.labels(new ArrayList<String>(list));
        }
        api.disableMembershipNotifications(source.isDisableMembershipNotifications());
        api.apiLifecycleState(this.apiLifecycleStateToApiLifecycleState1(source.getApiLifecycleState()));
        api.background(source.getBackground());
        api.definition(this.serializeApiDefinition(source));
        return api.build();
    }

    @Override
    public Stream<io.gravitee.repository.management.model.Api> toRepositoryStream(Stream<Api> source) {
        if (source == null) {
            return null;
        }
        return source.map(api -> this.toRepository((Api)api));
    }

    @Override
    public NewApiEntity toNewApiEntity(Api source) {
        List<Flow> flows;
        List<EndpointGroup> endpointGroups;
        List<EndpointGroup> list1;
        List<Listener> listeners;
        List<Listener> list;
        Set<String> tags;
        if (source == null) {
            return null;
        }
        NewApiEntity newApiEntity = new NewApiEntity();
        newApiEntity.setApiVersion(source.getVersion());
        Set<String> set = tags = this.sourceApiDefinitionV4Tags(source);
        if (set != null) {
            newApiEntity.setTags(new LinkedHashSet<String>(set));
        }
        if ((list = (listeners = this.sourceApiDefinitionV4Listeners(source))) != null) {
            newApiEntity.setListeners(new ArrayList<Listener>(list));
        }
        if ((list1 = (endpointGroups = this.sourceApiDefinitionV4EndpointGroups(source))) != null) {
            newApiEntity.setEndpointGroups(new ArrayList<EndpointGroup>(list1));
        }
        newApiEntity.setAnalytics(this.sourceApiDefinitionV4Analytics(source));
        newApiEntity.setFlowExecution(this.sourceApiDefinitionV4FlowExecution(source));
        List<Flow> list2 = flows = this.sourceApiDefinitionV4Flows(source);
        if (list2 != null) {
            newApiEntity.setFlows(new ArrayList<Flow>(list2));
        }
        newApiEntity.setName(source.getName());
        newApiEntity.setDescription(source.getDescription());
        newApiEntity.setDefinitionVersion(source.getDefinitionVersion());
        newApiEntity.setType(source.getType());
        Set<String> set1 = source.getGroups();
        if (set1 != null) {
            newApiEntity.setGroups(new LinkedHashSet<String>(set1));
        }
        return newApiEntity;
    }

    @Override
    public io.gravitee.definition.model.v4.Api toApiDefinition(ApiCRDSpec source) {
        Map<String, Map<String, ResponseTemplate>> map1;
        List<Resource> list3;
        List<EndpointGroup> list1;
        List<Listener> list;
        Set<String> set;
        if (source == null) {
            return null;
        }
        Api.ApiBuilder api = io.gravitee.definition.model.v4.Api.builder();
        api.apiVersion(source.getVersion());
        api.id(source.getId());
        api.name(source.getName());
        if (source.getType() != null) {
            api.type(Enum.valueOf(ApiType.class, source.getType()));
        }
        if (source.getDefinitionVersion() != null) {
            api.definitionVersion(Enum.valueOf(DefinitionVersion.class, source.getDefinitionVersion()));
        }
        if ((set = source.getTags()) != null) {
            api.tags(new LinkedHashSet<String>(set));
        }
        if ((list = source.getListeners()) != null) {
            api.listeners(new ArrayList<Listener>(list));
        }
        if ((list1 = source.getEndpointGroups()) != null) {
            api.endpointGroups(new ArrayList<EndpointGroup>(list1));
        }
        api.analytics(source.getAnalytics());
        List<Property> list2 = source.getProperties();
        if (list2 != null) {
            api.properties(new ArrayList<Property>(list2));
        }
        if ((list3 = source.getResources()) != null) {
            api.resources(new ArrayList<Resource>(list3));
        }
        api.failover(source.getFailover());
        api.plans(this.planAdapter.toApiDefinition(source.getPlans()));
        api.flowExecution(source.getFlowExecution());
        List<Flow> list4 = source.getFlows();
        if (list4 != null) {
            api.flows(new ArrayList<Flow>(list4));
        }
        if ((map1 = source.getResponseTemplates()) != null) {
            api.responseTemplates(new LinkedHashMap<String, Map<String, ResponseTemplate>>(map1));
        }
        return api.build();
    }

    @Override
    public UpdateApiEntity toUpdateApiEntity(ApiCRDSpec spec) {
        Set<String> set4;
        Set<String> set3;
        Set<String> set2;
        Map<String, Map<String, ResponseTemplate>> map;
        List<EndpointGroup> list1;
        List<Listener> list;
        Set<String> set;
        if (spec == null) {
            return null;
        }
        UpdateApiEntity updateApiEntity = new UpdateApiEntity();
        updateApiEntity.setApiVersion(spec.getVersion());
        updateApiEntity.setName(spec.getName());
        updateApiEntity.setDescription(spec.getDescription());
        updateApiEntity.setId(spec.getId());
        updateApiEntity.setCrossId(spec.getCrossId());
        if (spec.getDefinitionVersion() != null) {
            updateApiEntity.setDefinitionVersion(Enum.valueOf(DefinitionVersion.class, spec.getDefinitionVersion()));
        }
        if (spec.getType() != null) {
            updateApiEntity.setType(Enum.valueOf(ApiType.class, spec.getType()));
        }
        if ((set = spec.getTags()) != null) {
            updateApiEntity.setTags(new LinkedHashSet<String>(set));
        }
        if ((list = spec.getListeners()) != null) {
            updateApiEntity.setListeners(new ArrayList<Listener>(list));
        }
        if ((list1 = spec.getEndpointGroups()) != null) {
            updateApiEntity.setEndpointGroups(new ArrayList<EndpointGroup>(list1));
        }
        updateApiEntity.setAnalytics(spec.getAnalytics());
        updateApiEntity.setFailover(spec.getFailover());
        updateApiEntity.setProperties(this.propertyListToPropertyEntityList(spec.getProperties()));
        List<Resource> list3 = spec.getResources();
        if (list3 != null) {
            updateApiEntity.setResources(new ArrayList<Resource>(list3));
        }
        updateApiEntity.setPlans(this.planAdapter.toPlanEntityV4(spec.getPlans()));
        updateApiEntity.setFlowExecution(spec.getFlowExecution());
        List<Flow> list4 = spec.getFlows();
        if (list4 != null) {
            updateApiEntity.setFlows(new ArrayList<Flow>(list4));
        }
        if ((map = spec.getResponseTemplates()) != null) {
            updateApiEntity.setResponseTemplates(new LinkedHashMap<String, Map<String, ResponseTemplate>>(map));
        }
        if ((set2 = spec.getGroups()) != null) {
            updateApiEntity.setGroups(new LinkedHashSet<String>(set2));
        }
        if (spec.getVisibility() != null) {
            updateApiEntity.setVisibility(Enum.valueOf(Visibility.class, spec.getVisibility()));
        }
        if ((set3 = spec.getCategories()) != null) {
            updateApiEntity.setCategories(new LinkedHashSet<String>(set3));
        }
        if ((set4 = spec.getLabels()) != null) {
            updateApiEntity.setLabels(new ArrayList<String>(set4));
        }
        updateApiEntity.setMetadata(this.apiMetadataListToApiMetadataEntityList(spec.getMetadata()));
        if (spec.getLifecycleState() != null) {
            updateApiEntity.setLifecycleState(Enum.valueOf(io.gravitee.rest.api.model.api.ApiLifecycleState.class, spec.getLifecycleState()));
        }
        updateApiEntity.setDisableMembershipNotifications(!spec.isNotifyMembers());
        return updateApiEntity;
    }

    @Override
    public UpdateApiEntity toUpdateApiEntity(Api api, io.gravitee.definition.model.v4.Api apiDefinitionV4) {
        if (api == null && apiDefinitionV4 == null) {
            return null;
        }
        UpdateApiEntity updateApiEntity = new UpdateApiEntity();
        if (api != null) {
            List<String> list5;
            updateApiEntity.setId(api.getId());
            updateApiEntity.setName(api.getName());
            updateApiEntity.setDefinitionVersion(api.getDefinitionVersion());
            updateApiEntity.setType(api.getType());
            Set<String> set = api.getTags();
            if (set != null) {
                updateApiEntity.setTags(new LinkedHashSet<String>(set));
            }
            updateApiEntity.setApiVersion(api.getVersion());
            updateApiEntity.setLifecycleState(this.apiLifecycleStateToApiLifecycleState2(api.getApiLifecycleState()));
            updateApiEntity.setDescription(api.getDescription());
            updateApiEntity.setCrossId(api.getCrossId());
            Set<String> set2 = api.getGroups();
            if (set2 != null) {
                updateApiEntity.setGroups(new LinkedHashSet<String>(set2));
            }
            updateApiEntity.setVisibility(this.visibilityToVisibility2(api.getVisibility()));
            updateApiEntity.setPicture(api.getPicture());
            Set<String> set3 = api.getCategories();
            if (set3 != null) {
                updateApiEntity.setCategories(new LinkedHashSet<String>(set3));
            }
            if ((list5 = api.getLabels()) != null) {
                updateApiEntity.setLabels(new ArrayList<String>(list5));
            }
            updateApiEntity.setDisableMembershipNotifications(api.isDisableMembershipNotifications());
            updateApiEntity.setBackground(api.getBackground());
        }
        if (apiDefinitionV4 != null) {
            Map map;
            List list1;
            List list = apiDefinitionV4.getListeners();
            if (list != null) {
                updateApiEntity.setListeners(new ArrayList(list));
            }
            if ((list1 = apiDefinitionV4.getEndpointGroups()) != null) {
                updateApiEntity.setEndpointGroups(new ArrayList(list1));
            }
            updateApiEntity.setAnalytics(apiDefinitionV4.getAnalytics());
            updateApiEntity.setFailover(apiDefinitionV4.getFailover());
            updateApiEntity.setProperties(this.propertyListToPropertyEntityList(apiDefinitionV4.getProperties()));
            List list3 = apiDefinitionV4.getResources();
            if (list3 != null) {
                updateApiEntity.setResources(new ArrayList(list3));
            }
            updateApiEntity.setPlans(this.planListToPlanEntitySet(apiDefinitionV4.getPlans()));
            updateApiEntity.setFlowExecution(apiDefinitionV4.getFlowExecution());
            List list4 = apiDefinitionV4.getFlows();
            if (list4 != null) {
                updateApiEntity.setFlows(new ArrayList(list4));
            }
            if ((map = apiDefinitionV4.getResponseTemplates()) != null) {
                updateApiEntity.setResponseTemplates(new LinkedHashMap(map));
            }
            updateApiEntity.setServices(apiDefinitionV4.getServices());
        }
        return updateApiEntity;
    }

    @Override
    public ApiEntity toApiEntity(ApiCRDSpec api) {
        Set<String> set4;
        Set<String> set3;
        Set<String> set2;
        Map<String, Map<String, ResponseTemplate>> map;
        List<Resource> list3;
        List<EndpointGroup> list1;
        List<Listener> list;
        if (api == null) {
            return null;
        }
        ApiEntity.ApiEntityBuilder apiEntity = ApiEntity.builder();
        apiEntity.apiVersion(api.getVersion());
        apiEntity.id(api.getId());
        apiEntity.crossId(api.getCrossId());
        apiEntity.name(api.getName());
        if (api.getDefinitionVersion() != null) {
            apiEntity.definitionVersion(Enum.valueOf(DefinitionVersion.class, api.getDefinitionVersion()));
        }
        if (api.getType() != null) {
            apiEntity.type(Enum.valueOf(ApiType.class, api.getType()));
        }
        apiEntity.description(api.getDescription());
        Set<String> set = api.getTags();
        if (set != null) {
            apiEntity.tags(new LinkedHashSet<String>(set));
        }
        if ((list = api.getListeners()) != null) {
            apiEntity.listeners(new ArrayList<Listener>(list));
        }
        if ((list1 = api.getEndpointGroups()) != null) {
            apiEntity.endpointGroups(new ArrayList<EndpointGroup>(list1));
        }
        apiEntity.analytics(api.getAnalytics());
        apiEntity.failover(api.getFailover());
        List<Property> list2 = api.getProperties();
        if (list2 != null) {
            apiEntity.properties(new ArrayList<Property>(list2));
        }
        if ((list3 = api.getResources()) != null) {
            apiEntity.resources(new ArrayList<Resource>(list3));
        }
        apiEntity.plans(this.planAdapter.toPlanEntityV4(api.getPlans()));
        apiEntity.flowExecution(api.getFlowExecution());
        List<Flow> list4 = api.getFlows();
        if (list4 != null) {
            apiEntity.flows(new ArrayList<Flow>(list4));
        }
        if ((map = api.getResponseTemplates()) != null) {
            apiEntity.responseTemplates(new LinkedHashMap<String, Map<String, ResponseTemplate>>(map));
        }
        if ((set2 = api.getGroups()) != null) {
            apiEntity.groups(new LinkedHashSet<String>(set2));
        }
        if (api.getVisibility() != null) {
            apiEntity.visibility(Enum.valueOf(Visibility.class, api.getVisibility()));
        }
        if (api.getState() != null) {
            apiEntity.state(Enum.valueOf(Lifecycle.State.class, api.getState()));
        }
        if ((set3 = api.getCategories()) != null) {
            apiEntity.categories(new LinkedHashSet<String>(set3));
        }
        if ((set4 = api.getLabels()) != null) {
            apiEntity.labels(new ArrayList<String>(set4));
        }
        if (api.getLifecycleState() != null) {
            apiEntity.lifecycleState(Enum.valueOf(io.gravitee.rest.api.model.api.ApiLifecycleState.class, api.getLifecycleState()));
        }
        return apiEntity.build();
    }

    @Override
    public ApiEntity toApiEntity(Api api) {
        List<String> list;
        Set<String> set1;
        if (api == null) {
            return null;
        }
        ApiEntity.ApiEntityBuilder apiEntity = ApiEntity.builder();
        apiEntity.apiVersion(api.getVersion());
        apiEntity.id(api.getId());
        apiEntity.crossId(api.getCrossId());
        apiEntity.name(api.getName());
        apiEntity.definitionVersion(api.getDefinitionVersion());
        apiEntity.type(api.getType());
        if (api.getDeployedAt() != null) {
            apiEntity.deployedAt(Date.from(api.getDeployedAt().toInstant()));
        }
        if (api.getCreatedAt() != null) {
            apiEntity.createdAt(Date.from(api.getCreatedAt().toInstant()));
        }
        if (api.getUpdatedAt() != null) {
            apiEntity.updatedAt(Date.from(api.getUpdatedAt().toInstant()));
        }
        apiEntity.description(api.getDescription());
        Set<String> set = api.getTags();
        if (set != null) {
            apiEntity.tags(new LinkedHashSet<String>(set));
        }
        if ((set1 = api.getGroups()) != null) {
            apiEntity.groups(new LinkedHashSet<String>(set1));
        }
        apiEntity.visibility(this.visibilityToVisibility2(api.getVisibility()));
        apiEntity.picture(api.getPicture());
        Set<String> set2 = api.getCategories();
        if (set2 != null) {
            apiEntity.categories(new LinkedHashSet<String>(set2));
        }
        if ((list = api.getLabels()) != null) {
            apiEntity.labels(new ArrayList<String>(list));
        }
        apiEntity.originContext(api.getOriginContext());
        apiEntity.lifecycleState(this.lifecycleStateToApiLifecycleState(api.getLifecycleState()));
        apiEntity.disableMembershipNotifications(api.isDisableMembershipNotifications());
        apiEntity.background(api.getBackground());
        return apiEntity.build();
    }

    @Override
    public FederatedApiEntity toFederatedApiEntity(io.gravitee.repository.management.model.Api source, io.gravitee.apim.core.membership.model.PrimaryOwnerEntity primaryOwnerEntity) {
        if (source == null && primaryOwnerEntity == null) {
            return null;
        }
        FederatedApiEntity.FederatedApiEntityBuilder federatedApiEntity = FederatedApiEntity.builder();
        if (source != null) {
            List list;
            federatedApiEntity.apiVersion(source.getVersion());
            federatedApiEntity.id(source.getId());
            federatedApiEntity.referenceId(source.getEnvironmentId());
            federatedApiEntity.lifecycleState(this.apiLifecycleStateToApiLifecycleState3(source.getApiLifecycleState()));
            federatedApiEntity.crossId(source.getCrossId());
            federatedApiEntity.name(source.getName());
            federatedApiEntity.definitionVersion(source.getDefinitionVersion());
            federatedApiEntity.deployedAt(source.getDeployedAt());
            federatedApiEntity.createdAt(source.getCreatedAt());
            federatedApiEntity.updatedAt(source.getUpdatedAt());
            federatedApiEntity.description(source.getDescription());
            Set set = source.getGroups();
            if (set != null) {
                federatedApiEntity.groups(new LinkedHashSet(set));
            }
            federatedApiEntity.visibility(this.visibilityToVisibility3(source.getVisibility()));
            federatedApiEntity.picture(source.getPicture());
            Set set1 = source.getCategories();
            if (set1 != null) {
                federatedApiEntity.categories(new LinkedHashSet(set1));
            }
            if ((list = source.getLabels()) != null) {
                federatedApiEntity.labels(new ArrayList(list));
            }
            federatedApiEntity.disableMembershipNotifications(source.isDisableMembershipNotifications());
            federatedApiEntity.background(source.getBackground());
        }
        federatedApiEntity.primaryOwner(this.primaryOwnerEntityToPrimaryOwnerEntity(primaryOwnerEntity));
        federatedApiEntity.referenceType("ENVIRONMENT");
        return federatedApiEntity.build();
    }

    @Override
    public Api fromApiEntity(GenericApiEntity apiEntity) {
        List list;
        Set set1;
        if (apiEntity == null) {
            return null;
        }
        Api.ApiBuilder<?, ?> api = Api.builder();
        api.lifecycleState(this.stateToLifecycleState(apiEntity.getState()));
        api.apiLifecycleState(this.apiLifecycleStateToApiLifecycleState4(apiEntity.getLifecycleState()));
        api.id(apiEntity.getId());
        api.name(apiEntity.getName());
        api.description(apiEntity.getDescription());
        api.originContext(apiEntity.getOriginContext());
        api.definitionVersion(apiEntity.getDefinitionVersion());
        if (apiEntity.getDeployedAt() != null) {
            api.deployedAt(ZonedDateTime.ofInstant(apiEntity.getDeployedAt().toInstant(), ZoneId.systemDefault()));
        }
        if (apiEntity.getCreatedAt() != null) {
            api.createdAt(ZonedDateTime.ofInstant(apiEntity.getCreatedAt().toInstant(), ZoneId.systemDefault()));
        }
        if (apiEntity.getUpdatedAt() != null) {
            api.updatedAt(ZonedDateTime.ofInstant(apiEntity.getUpdatedAt().toInstant(), ZoneId.systemDefault()));
        }
        api.visibility(this.visibilityToVisibility4(apiEntity.getVisibility()));
        api.picture(apiEntity.getPicture());
        Set set = apiEntity.getGroups();
        if (set != null) {
            api.groups(new LinkedHashSet<String>(set));
        }
        if ((set1 = apiEntity.getCategories()) != null) {
            api.categories(new LinkedHashSet<String>(set1));
        }
        if ((list = apiEntity.getLabels()) != null) {
            api.labels(new ArrayList<String>(list));
        }
        api.disableMembershipNotifications(apiEntity.isDisableMembershipNotifications());
        api.background(apiEntity.getBackground());
        return api.build();
    }

    protected Api.Visibility visibilityToVisibility(io.gravitee.repository.management.model.Visibility visibility) {
        if (visibility == null) {
            return null;
        }
        return switch (visibility) {
            case io.gravitee.repository.management.model.Visibility.PUBLIC -> Api.Visibility.PUBLIC;
            case io.gravitee.repository.management.model.Visibility.PRIVATE -> Api.Visibility.PRIVATE;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + visibility);
        };
    }

    protected Api.LifecycleState lifecycleStateToLifecycleState(LifecycleState lifecycleState) {
        if (lifecycleState == null) {
            return null;
        }
        return switch (lifecycleState) {
            case LifecycleState.STARTED -> Api.LifecycleState.STARTED;
            case LifecycleState.STOPPED -> Api.LifecycleState.STOPPED;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + lifecycleState);
        };
    }

    protected Api.ApiLifecycleState apiLifecycleStateToApiLifecycleState(ApiLifecycleState apiLifecycleState) {
        if (apiLifecycleState == null) {
            return null;
        }
        return switch (apiLifecycleState) {
            case ApiLifecycleState.CREATED -> Api.ApiLifecycleState.CREATED;
            case ApiLifecycleState.PUBLISHED -> Api.ApiLifecycleState.PUBLISHED;
            case ApiLifecycleState.UNPUBLISHED -> Api.ApiLifecycleState.UNPUBLISHED;
            case ApiLifecycleState.DEPRECATED -> Api.ApiLifecycleState.DEPRECATED;
            case ApiLifecycleState.ARCHIVED -> Api.ApiLifecycleState.ARCHIVED;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + apiLifecycleState);
        };
    }

    protected io.gravitee.repository.management.model.Visibility visibilityToVisibility1(Api.Visibility visibility) {
        if (visibility == null) {
            return null;
        }
        return switch (visibility) {
            case Api.Visibility.PUBLIC -> io.gravitee.repository.management.model.Visibility.PUBLIC;
            case Api.Visibility.PRIVATE -> io.gravitee.repository.management.model.Visibility.PRIVATE;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + visibility);
        };
    }

    protected LifecycleState lifecycleStateToLifecycleState1(Api.LifecycleState lifecycleState) {
        if (lifecycleState == null) {
            return null;
        }
        return switch (lifecycleState) {
            case Api.LifecycleState.STARTED -> LifecycleState.STARTED;
            case Api.LifecycleState.STOPPED -> LifecycleState.STOPPED;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + lifecycleState);
        };
    }

    protected ApiLifecycleState apiLifecycleStateToApiLifecycleState1(Api.ApiLifecycleState apiLifecycleState) {
        if (apiLifecycleState == null) {
            return null;
        }
        return switch (apiLifecycleState) {
            case Api.ApiLifecycleState.CREATED -> ApiLifecycleState.CREATED;
            case Api.ApiLifecycleState.PUBLISHED -> ApiLifecycleState.PUBLISHED;
            case Api.ApiLifecycleState.UNPUBLISHED -> ApiLifecycleState.UNPUBLISHED;
            case Api.ApiLifecycleState.DEPRECATED -> ApiLifecycleState.DEPRECATED;
            case Api.ApiLifecycleState.ARCHIVED -> ApiLifecycleState.ARCHIVED;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + apiLifecycleState);
        };
    }

    private Set<String> sourceApiDefinitionV4Tags(Api api) {
        if (api == null) {
            return null;
        }
        io.gravitee.definition.model.v4.Api apiDefinitionV4 = api.getApiDefinitionV4();
        if (apiDefinitionV4 == null) {
            return null;
        }
        Set tags = apiDefinitionV4.getTags();
        if (tags == null) {
            return null;
        }
        return tags;
    }

    private List<Listener> sourceApiDefinitionV4Listeners(Api api) {
        if (api == null) {
            return null;
        }
        io.gravitee.definition.model.v4.Api apiDefinitionV4 = api.getApiDefinitionV4();
        if (apiDefinitionV4 == null) {
            return null;
        }
        List listeners = apiDefinitionV4.getListeners();
        if (listeners == null) {
            return null;
        }
        return listeners;
    }

    private List<EndpointGroup> sourceApiDefinitionV4EndpointGroups(Api api) {
        if (api == null) {
            return null;
        }
        io.gravitee.definition.model.v4.Api apiDefinitionV4 = api.getApiDefinitionV4();
        if (apiDefinitionV4 == null) {
            return null;
        }
        List endpointGroups = apiDefinitionV4.getEndpointGroups();
        if (endpointGroups == null) {
            return null;
        }
        return endpointGroups;
    }

    private Analytics sourceApiDefinitionV4Analytics(Api api) {
        if (api == null) {
            return null;
        }
        io.gravitee.definition.model.v4.Api apiDefinitionV4 = api.getApiDefinitionV4();
        if (apiDefinitionV4 == null) {
            return null;
        }
        Analytics analytics = apiDefinitionV4.getAnalytics();
        if (analytics == null) {
            return null;
        }
        return analytics;
    }

    private FlowExecution sourceApiDefinitionV4FlowExecution(Api api) {
        if (api == null) {
            return null;
        }
        io.gravitee.definition.model.v4.Api apiDefinitionV4 = api.getApiDefinitionV4();
        if (apiDefinitionV4 == null) {
            return null;
        }
        FlowExecution flowExecution = apiDefinitionV4.getFlowExecution();
        if (flowExecution == null) {
            return null;
        }
        return flowExecution;
    }

    private List<Flow> sourceApiDefinitionV4Flows(Api api) {
        if (api == null) {
            return null;
        }
        io.gravitee.definition.model.v4.Api apiDefinitionV4 = api.getApiDefinitionV4();
        if (apiDefinitionV4 == null) {
            return null;
        }
        List flows = apiDefinitionV4.getFlows();
        if (flows == null) {
            return null;
        }
        return flows;
    }

    protected PropertyEntity propertyToPropertyEntity(Property property) {
        if (property == null) {
            return null;
        }
        PropertyEntity.PropertyEntityBuilder propertyEntity = PropertyEntity.builder();
        propertyEntity.key(property.getKey());
        propertyEntity.value(property.getValue());
        propertyEntity.encrypted(property.isEncrypted());
        propertyEntity.dynamic(property.isDynamic());
        return propertyEntity.build();
    }

    protected List<PropertyEntity> propertyListToPropertyEntityList(List<Property> list) {
        if (list == null) {
            return null;
        }
        ArrayList<PropertyEntity> list1 = new ArrayList<PropertyEntity>(list.size());
        for (Property property : list) {
            list1.add(this.propertyToPropertyEntity(property));
        }
        return list1;
    }

    protected MetadataFormat metadataFormatToMetadataFormat(Metadata.MetadataFormat metadataFormat) {
        if (metadataFormat == null) {
            return null;
        }
        return switch (metadataFormat) {
            case Metadata.MetadataFormat.STRING -> MetadataFormat.STRING;
            case Metadata.MetadataFormat.NUMERIC -> MetadataFormat.NUMERIC;
            case Metadata.MetadataFormat.BOOLEAN -> MetadataFormat.BOOLEAN;
            case Metadata.MetadataFormat.DATE -> MetadataFormat.DATE;
            case Metadata.MetadataFormat.MAIL -> MetadataFormat.MAIL;
            case Metadata.MetadataFormat.URL -> MetadataFormat.URL;
            default -> null;
        };
    }

    protected ApiMetadataEntity apiMetadataToApiMetadataEntity(ApiMetadata apiMetadata) {
        if (apiMetadata == null) {
            return null;
        }
        ApiMetadataEntity apiMetadataEntity = new ApiMetadataEntity();
        apiMetadataEntity.setKey(apiMetadata.getKey());
        apiMetadataEntity.setName(apiMetadata.getName());
        apiMetadataEntity.setFormat(this.metadataFormatToMetadataFormat(apiMetadata.getFormat()));
        apiMetadataEntity.setValue(apiMetadata.getValue());
        apiMetadataEntity.setDefaultValue(apiMetadata.getDefaultValue());
        apiMetadataEntity.setApiId(apiMetadata.getApiId());
        return apiMetadataEntity;
    }

    protected List<ApiMetadataEntity> apiMetadataListToApiMetadataEntityList(List<ApiMetadata> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ApiMetadataEntity> list1 = new ArrayList<ApiMetadataEntity>(list.size());
        for (ApiMetadata apiMetadata : list) {
            list1.add(this.apiMetadataToApiMetadataEntity(apiMetadata));
        }
        return list1;
    }

    protected io.gravitee.rest.api.model.api.ApiLifecycleState apiLifecycleStateToApiLifecycleState2(Api.ApiLifecycleState apiLifecycleState) {
        if (apiLifecycleState == null) {
            return null;
        }
        return switch (apiLifecycleState) {
            case Api.ApiLifecycleState.CREATED -> io.gravitee.rest.api.model.api.ApiLifecycleState.CREATED;
            case Api.ApiLifecycleState.PUBLISHED -> io.gravitee.rest.api.model.api.ApiLifecycleState.PUBLISHED;
            case Api.ApiLifecycleState.UNPUBLISHED -> io.gravitee.rest.api.model.api.ApiLifecycleState.UNPUBLISHED;
            case Api.ApiLifecycleState.DEPRECATED -> io.gravitee.rest.api.model.api.ApiLifecycleState.DEPRECATED;
            case Api.ApiLifecycleState.ARCHIVED -> io.gravitee.rest.api.model.api.ApiLifecycleState.ARCHIVED;
            default -> null;
        };
    }

    protected PlanEntity planToPlanEntity(Plan plan) {
        if (plan == null) {
            return null;
        }
        PlanEntity.PlanEntityBuilder planEntity = PlanEntity.builder();
        planEntity.id(plan.getId());
        planEntity.name(plan.getName());
        planEntity.mode(plan.getMode());
        planEntity.security(plan.getSecurity());
        planEntity.selectionRule(plan.getSelectionRule());
        Set set = plan.getTags();
        if (set != null) {
            planEntity.tags(new LinkedHashSet(set));
        }
        planEntity.status(plan.getStatus());
        List list = plan.getFlows();
        if (list != null) {
            planEntity.flows(new ArrayList(list));
        }
        return planEntity.build();
    }

    protected Set<PlanEntity> planListToPlanEntitySet(List<Plan> list) {
        if (list == null) {
            return null;
        }
        LinkedHashSet<PlanEntity> set = new LinkedHashSet<PlanEntity>(Math.max((int)((float)list.size() / 0.75f) + 1, 16));
        for (Plan plan : list) {
            set.add(this.planToPlanEntity(plan));
        }
        return set;
    }

    protected Visibility visibilityToVisibility2(Api.Visibility visibility) {
        if (visibility == null) {
            return null;
        }
        return switch (visibility) {
            case Api.Visibility.PUBLIC -> Visibility.PUBLIC;
            case Api.Visibility.PRIVATE -> Visibility.PRIVATE;
            default -> null;
        };
    }

    protected io.gravitee.rest.api.model.api.ApiLifecycleState lifecycleStateToApiLifecycleState(Api.LifecycleState lifecycleState) {
        if (lifecycleState == null) {
            return null;
        }
        switch (lifecycleState) {
            default: 
        }
        io.gravitee.rest.api.model.api.ApiLifecycleState apiLifecycleState = null;
        return apiLifecycleState;
    }

    protected PrimaryOwnerEntity primaryOwnerEntityToPrimaryOwnerEntity(io.gravitee.apim.core.membership.model.PrimaryOwnerEntity primaryOwnerEntity) {
        if (primaryOwnerEntity == null) {
            return null;
        }
        PrimaryOwnerEntity.PrimaryOwnerEntityBuilder primaryOwnerEntity1 = PrimaryOwnerEntity.builder();
        primaryOwnerEntity1.id(primaryOwnerEntity.id());
        primaryOwnerEntity1.email(primaryOwnerEntity.email());
        primaryOwnerEntity1.displayName(primaryOwnerEntity.displayName());
        if (primaryOwnerEntity.type() != null) {
            primaryOwnerEntity1.type(primaryOwnerEntity.type().name());
        }
        return primaryOwnerEntity1.build();
    }

    protected io.gravitee.rest.api.model.api.ApiLifecycleState apiLifecycleStateToApiLifecycleState3(ApiLifecycleState apiLifecycleState) {
        if (apiLifecycleState == null) {
            return null;
        }
        return switch (apiLifecycleState) {
            case ApiLifecycleState.CREATED -> io.gravitee.rest.api.model.api.ApiLifecycleState.CREATED;
            case ApiLifecycleState.PUBLISHED -> io.gravitee.rest.api.model.api.ApiLifecycleState.PUBLISHED;
            case ApiLifecycleState.UNPUBLISHED -> io.gravitee.rest.api.model.api.ApiLifecycleState.UNPUBLISHED;
            case ApiLifecycleState.DEPRECATED -> io.gravitee.rest.api.model.api.ApiLifecycleState.DEPRECATED;
            case ApiLifecycleState.ARCHIVED -> io.gravitee.rest.api.model.api.ApiLifecycleState.ARCHIVED;
            default -> null;
        };
    }

    protected Visibility visibilityToVisibility3(io.gravitee.repository.management.model.Visibility visibility) {
        if (visibility == null) {
            return null;
        }
        return switch (visibility) {
            case io.gravitee.repository.management.model.Visibility.PUBLIC -> Visibility.PUBLIC;
            case io.gravitee.repository.management.model.Visibility.PRIVATE -> Visibility.PRIVATE;
            default -> null;
        };
    }

    protected Api.LifecycleState stateToLifecycleState(Lifecycle.State state) {
        if (state == null) {
            return null;
        }
        return switch (state) {
            case Lifecycle.State.STOPPED -> Api.LifecycleState.STOPPED;
            case Lifecycle.State.STARTED -> Api.LifecycleState.STARTED;
            default -> null;
        };
    }

    protected Api.ApiLifecycleState apiLifecycleStateToApiLifecycleState4(io.gravitee.rest.api.model.api.ApiLifecycleState apiLifecycleState) {
        if (apiLifecycleState == null) {
            return null;
        }
        return switch (apiLifecycleState) {
            case io.gravitee.rest.api.model.api.ApiLifecycleState.CREATED -> Api.ApiLifecycleState.CREATED;
            case io.gravitee.rest.api.model.api.ApiLifecycleState.PUBLISHED -> Api.ApiLifecycleState.PUBLISHED;
            case io.gravitee.rest.api.model.api.ApiLifecycleState.UNPUBLISHED -> Api.ApiLifecycleState.UNPUBLISHED;
            case io.gravitee.rest.api.model.api.ApiLifecycleState.DEPRECATED -> Api.ApiLifecycleState.DEPRECATED;
            case io.gravitee.rest.api.model.api.ApiLifecycleState.ARCHIVED -> Api.ApiLifecycleState.ARCHIVED;
            default -> null;
        };
    }

    protected Api.Visibility visibilityToVisibility4(Visibility visibility) {
        if (visibility == null) {
            return null;
        }
        return switch (visibility) {
            case Visibility.PUBLIC -> Api.Visibility.PUBLIC;
            case Visibility.PRIVATE -> Api.Visibility.PRIVATE;
            default -> null;
        };
    }
}

