/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.search.lucene.transformer;

import io.gravitee.apim.core.documentation.model.Page;
import io.gravitee.apim.core.search.model.IndexablePage;
import io.gravitee.rest.api.model.search.Indexable;
import io.gravitee.rest.api.service.impl.search.lucene.DocumentTransformer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.springframework.stereotype.Component;

@Component
public class IndexablePageDocumentTransformer
implements DocumentTransformer<IndexablePage> {
    @Override
    public Document transform(IndexablePage indexable) {
        Document document = new Document();
        document.add((IndexableField)new StringField("id", indexable.getId(), Field.Store.YES));
        document.add((IndexableField)new StringField("type", "page", Field.Store.YES));
        if (indexable.getReferenceId() != null) {
            document.add((IndexableField)new StringField("reference_type", indexable.getReferenceType().toLowerCase(), Field.Store.NO));
            document.add((IndexableField)new StringField("reference_id", indexable.getReferenceId(), Field.Store.YES));
        }
        Page page = indexable.getPage();
        if (indexable.getPage().getName() != null) {
            document.add((IndexableField)new StringField("name", page.getName(), Field.Store.NO));
            document.add((IndexableField)new StringField("name_lowercase", page.getName().toLowerCase(), Field.Store.NO));
            document.add((IndexableField)new TextField("name_split", page.getName(), Field.Store.NO));
        }
        if (indexable.getPage().getContent() != null) {
            document.add((IndexableField)new TextField("content", page.getContent(), Field.Store.NO));
        }
        return document;
    }

    @Override
    public boolean handle(Class<? extends Indexable> source) {
        return IndexablePage.class.isAssignableFrom(source);
    }
}

