/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.crud_service.access_point;

import io.gravitee.apim.core.access_point.crud_service.AccessPointCrudService;
import io.gravitee.apim.core.access_point.model.AccessPoint;
import io.gravitee.apim.core.access_point.model.AccessPointEvent;
import io.gravitee.apim.infra.adapter.AccessPointAdapter;
import io.gravitee.common.event.EventManager;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.AccessPointRepository;
import io.gravitee.repository.management.api.search.AccessPointCriteria;
import io.gravitee.repository.management.model.AccessPointReferenceType;
import io.gravitee.repository.management.model.AccessPointStatus;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.TransactionalService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class AccessPointCrudServiceImpl
extends TransactionalService
implements AccessPointCrudService {
    private final AccessPointRepository accessPointRepository;
    private EventManager eventManager;

    public AccessPointCrudServiceImpl(@Lazy AccessPointRepository accessPointRepository, EventManager eventManager) {
        this.accessPointRepository = accessPointRepository;
        this.eventManager = eventManager;
    }

    @Override
    public void updateAccessPoints(AccessPoint.ReferenceType referenceType, String referenceId, List<AccessPoint> accessPoints) {
        try {
            AccessPointCriteria accessPointCriteria = AccessPointCriteria.builder().referenceType(AccessPointReferenceType.valueOf((String)referenceType.name())).referenceIds(Set.of(referenceId)).status(AccessPointStatus.CREATED).build();
            List existingAccessPoints = this.accessPointRepository.findByCriteria(accessPointCriteria, null, null);
            ArrayList<io.gravitee.repository.management.model.AccessPoint> apsToCreate = new ArrayList<io.gravitee.repository.management.model.AccessPoint>();
            ArrayList apsToDelete = new ArrayList(existingAccessPoints);
            for (AccessPoint accessPoint : accessPoints) {
                io.gravitee.repository.management.model.AccessPoint newAccessPoint = AccessPointAdapter.INSTANCE.fromEntity(accessPoint);
                List<io.gravitee.repository.management.model.AccessPoint> existingAPsForTarget = existingAccessPoints.stream().filter(existingAccessPoint -> existingAccessPoint.getTarget().equals((Object)newAccessPoint.getTarget())).toList();
                if (existingAPsForTarget.isEmpty()) {
                    apsToCreate.add(newAccessPoint);
                    continue;
                }
                boolean shouldCreateNewAP = true;
                for (io.gravitee.repository.management.model.AccessPoint existingAccessPoint2 : existingAPsForTarget) {
                    if (!existingAccessPoint2.getHost().equalsIgnoreCase(newAccessPoint.getHost()) || existingAccessPoint2.isSecured() != newAccessPoint.isSecured() || existingAccessPoint2.isOverriding() != newAccessPoint.isOverriding()) continue;
                    apsToDelete.remove(existingAccessPoint2);
                    shouldCreateNewAP = false;
                    break;
                }
                if (!shouldCreateNewAP) continue;
                apsToCreate.add(newAccessPoint);
            }
            for (io.gravitee.repository.management.model.AccessPoint apToCreate : apsToCreate) {
                this.createAccessPoint(apToCreate);
            }
            for (io.gravitee.repository.management.model.AccessPoint apToDelete : apsToDelete) {
                this.deleteAccessPoint(apToDelete);
            }
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("An error occurs while updating access points", e);
        }
    }

    @Override
    public void deleteAccessPoints(AccessPoint.ReferenceType referenceType, String referenceId) {
        try {
            AccessPointCriteria accessPointCriteria = AccessPointCriteria.builder().referenceType(AccessPointReferenceType.valueOf((String)referenceType.name())).referenceIds(Set.of(referenceId)).status(AccessPointStatus.CREATED).build();
            List existingAccessPoints = this.accessPointRepository.findByCriteria(accessPointCriteria, null, null);
            for (io.gravitee.repository.management.model.AccessPoint accessPoint : existingAccessPoints) {
                this.deleteAccessPoint(accessPoint);
            }
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("An error occurs while deleting access points", e);
        }
    }

    private void createAccessPoint(io.gravitee.repository.management.model.AccessPoint newAccessPoint) throws TechnicalException {
        if (newAccessPoint.getId() == null) {
            newAccessPoint.setId(UuidString.generateRandom());
        }
        newAccessPoint.setUpdatedAt(new Date());
        newAccessPoint.setStatus(AccessPointStatus.CREATED);
        io.gravitee.repository.management.model.AccessPoint createdAccessPoint = (io.gravitee.repository.management.model.AccessPoint)this.accessPointRepository.create((Object)newAccessPoint);
        this.eventManager.publishEvent((Enum)AccessPointEvent.CREATED, (Object)AccessPointAdapter.INSTANCE.toEntity(createdAccessPoint));
    }

    private void deleteAccessPoint(io.gravitee.repository.management.model.AccessPoint accessPointToDelete) throws TechnicalException {
        accessPointToDelete.setStatus(AccessPointStatus.DELETED);
        accessPointToDelete.setUpdatedAt(new Date());
        io.gravitee.repository.management.model.AccessPoint updatedAccessPoint = (io.gravitee.repository.management.model.AccessPoint)this.accessPointRepository.update((Object)accessPointToDelete);
        this.eventManager.publishEvent((Enum)AccessPointEvent.DELETED, (Object)updatedAccessPoint);
    }
}

