/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.api.model.import_definition.ApiMember;
import io.gravitee.apim.core.api.model.import_definition.ApiMemberRole;
import io.gravitee.apim.infra.adapter.MemberAdapter;
import io.gravitee.rest.api.model.MemberEntity;
import io.gravitee.rest.api.model.RoleEntity;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class MemberAdapterImpl
implements MemberAdapter {
    @Override
    public MemberEntity toEntity(ApiMember member) {
        if (member == null) {
            return null;
        }
        MemberEntity.MemberEntityBuilder memberEntity = MemberEntity.builder();
        memberEntity.id(member.getId());
        memberEntity.displayName(member.getDisplayName());
        memberEntity.roles(this.toEntities(member.getRoles()));
        return memberEntity.build();
    }

    @Override
    public Set<MemberEntity> toEntities(Set<ApiMember> members) {
        if (members == null) {
            return null;
        }
        LinkedHashSet<MemberEntity> set = new LinkedHashSet<MemberEntity>(Math.max((int)((float)members.size() / 0.75f) + 1, 16));
        for (ApiMember apiMember : members) {
            set.add(this.toEntity(apiMember));
        }
        return set;
    }

    @Override
    public RoleEntity toEntity(ApiMemberRole role) {
        if (role == null) {
            return null;
        }
        RoleEntity.RoleEntityBuilder roleEntity = RoleEntity.builder();
        roleEntity.name(role.getName());
        roleEntity.scope(role.getScope());
        return roleEntity.build();
    }

    @Override
    public List<RoleEntity> toEntities(List<ApiMemberRole> roles) {
        if (roles == null) {
            return null;
        }
        ArrayList<RoleEntity> list = new ArrayList<RoleEntity>(roles.size());
        for (ApiMemberRole apiMemberRole : roles) {
            list.add(this.toEntity(apiMemberRole));
        }
        return list;
    }
}

