/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.workflow.model;

import io.gravitee.common.utils.TimeProvider;
import io.gravitee.rest.api.service.common.UuidString;
import java.time.ZonedDateTime;
import lombok.Generated;

public class Workflow {
    private String id;
    private ReferenceType referenceType;
    private String referenceId;
    private Type type;
    private State state;
    private String comment;
    private String user;
    private ZonedDateTime createdAt;

    public static Workflow newApiReviewWorkflow(String apiId, String userId) {
        return Workflow.builder().id(UuidString.generateRandom()).referenceType(ReferenceType.API).referenceId(apiId).type(Type.REVIEW).state(State.DRAFT).comment("").user(userId).createdAt(TimeProvider.now()).build();
    }

    @Generated
    Workflow(String id, ReferenceType referenceType, String referenceId, Type type, State state, String comment, String user, ZonedDateTime createdAt) {
        this.id = id;
        this.referenceType = referenceType;
        this.referenceId = referenceId;
        this.type = type;
        this.state = state;
        this.comment = comment;
        this.user = user;
        this.createdAt = createdAt;
    }

    @Generated
    public static WorkflowBuilder builder() {
        return new WorkflowBuilder();
    }

    @Generated
    public WorkflowBuilder toBuilder() {
        return new WorkflowBuilder().id(this.id).referenceType(this.referenceType).referenceId(this.referenceId).type(this.type).state(this.state).comment(this.comment).user(this.user).createdAt(this.createdAt);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public ReferenceType getReferenceType() {
        return this.referenceType;
    }

    @Generated
    public String getReferenceId() {
        return this.referenceId;
    }

    @Generated
    public Type getType() {
        return this.type;
    }

    @Generated
    public State getState() {
        return this.state;
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @Generated
    public String getUser() {
        return this.user;
    }

    @Generated
    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setReferenceType(ReferenceType referenceType) {
        this.referenceType = referenceType;
    }

    @Generated
    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    @Generated
    public void setType(Type type) {
        this.type = type;
    }

    @Generated
    public void setState(State state) {
        this.state = state;
    }

    @Generated
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Generated
    public void setUser(String user) {
        this.user = user;
    }

    @Generated
    public void setCreatedAt(ZonedDateTime createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Workflow)) {
            return false;
        }
        Workflow other = (Workflow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        ReferenceType this$referenceType = this.getReferenceType();
        ReferenceType other$referenceType = other.getReferenceType();
        if (this$referenceType == null ? other$referenceType != null : !((Object)((Object)this$referenceType)).equals((Object)other$referenceType)) {
            return false;
        }
        String this$referenceId = this.getReferenceId();
        String other$referenceId = other.getReferenceId();
        if (this$referenceId == null ? other$referenceId != null : !this$referenceId.equals(other$referenceId)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        State this$state = this.getState();
        State other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        ZonedDateTime this$createdAt = this.getCreatedAt();
        ZonedDateTime other$createdAt = other.getCreatedAt();
        return !(this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Workflow;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        ReferenceType $referenceType = this.getReferenceType();
        result = result * 59 + ($referenceType == null ? 43 : ((Object)((Object)$referenceType)).hashCode());
        String $referenceId = this.getReferenceId();
        result = result * 59 + ($referenceId == null ? 43 : $referenceId.hashCode());
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        State $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        ZonedDateTime $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Workflow(id=" + this.getId() + ", referenceType=" + this.getReferenceType() + ", referenceId=" + this.getReferenceId() + ", type=" + this.getType() + ", state=" + this.getState() + ", comment=" + this.getComment() + ", user=" + this.getUser() + ", createdAt=" + this.getCreatedAt() + ")";
    }

    @Generated
    public static class WorkflowBuilder {
        @Generated
        private String id;
        @Generated
        private ReferenceType referenceType;
        @Generated
        private String referenceId;
        @Generated
        private Type type;
        @Generated
        private State state;
        @Generated
        private String comment;
        @Generated
        private String user;
        @Generated
        private ZonedDateTime createdAt;

        @Generated
        WorkflowBuilder() {
        }

        @Generated
        public WorkflowBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public WorkflowBuilder referenceType(ReferenceType referenceType) {
            this.referenceType = referenceType;
            return this;
        }

        @Generated
        public WorkflowBuilder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        @Generated
        public WorkflowBuilder type(Type type) {
            this.type = type;
            return this;
        }

        @Generated
        public WorkflowBuilder state(State state) {
            this.state = state;
            return this;
        }

        @Generated
        public WorkflowBuilder comment(String comment) {
            this.comment = comment;
            return this;
        }

        @Generated
        public WorkflowBuilder user(String user) {
            this.user = user;
            return this;
        }

        @Generated
        public WorkflowBuilder createdAt(ZonedDateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Generated
        public Workflow build() {
            return new Workflow(this.id, this.referenceType, this.referenceId, this.type, this.state, this.comment, this.user, this.createdAt);
        }

        @Generated
        public String toString() {
            return "Workflow.WorkflowBuilder(id=" + this.id + ", referenceType=" + this.referenceType + ", referenceId=" + this.referenceId + ", type=" + this.type + ", state=" + this.state + ", comment=" + this.comment + ", user=" + this.user + ", createdAt=" + this.createdAt + ")";
        }
    }

    public static enum ReferenceType {
        API,
        APPLICATION;

    }

    public static enum Type {
        REVIEW;

    }

    public static enum State {
        DRAFT,
        IN_REVIEW,
        REQUEST_FOR_CHANGES,
        REVIEW_OK;

    }
}

