/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.group.model.Group;
import io.gravitee.apim.core.group.query_service.GroupQueryService;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.service.exceptions.InvalidDataException;
import java.util.Set;
import java.util.stream.Collectors;

@DomainService
public class GroupValidationService {
    private final GroupQueryService groupQueryService;

    public GroupValidationService(GroupQueryService groupQueryService) {
        this.groupQueryService = groupQueryService;
    }

    public Set<String> validateAndSanitize(Set<String> groupIds, String environmentId, PrimaryOwnerEntity primaryOwner) {
        if (groupIds == null || groupIds.isEmpty()) {
            return groupIds;
        }
        Set<Group> found = this.groupQueryService.findByIds(groupIds);
        if (found.size() != groupIds.size()) {
            Set foundIds = found.stream().map(Group::getId).collect(Collectors.toSet());
            Set groupsNotFound = groupIds.stream().filter(groupId -> !foundIds.contains(groupId)).collect(Collectors.toSet());
            throw new InvalidDataException("These groupIds [" + groupsNotFound + "] do not exist");
        }
        Set<Group> defaultGroups = this.groupQueryService.findByEvent(environmentId, Group.GroupEvent.API_CREATE);
        found.addAll(defaultGroups);
        Set<String> sanitized = found.stream().filter(group -> group.getApiPrimaryOwner() == null).map(Group::getId).collect(Collectors.toSet());
        if (primaryOwner != null && PrimaryOwnerEntity.Type.GROUP.equals((Object)primaryOwner.type())) {
            sanitized.add(primaryOwner.id());
        }
        return sanitized;
    }
}

