/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.query_service.audit;

import io.gravitee.apim.core.audit.model.AuditEntity;
import io.gravitee.apim.core.audit.query_service.AuditMetadataQueryService;
import io.gravitee.apim.infra.adapter.UserAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.ApplicationRepository;
import io.gravitee.repository.management.api.GroupRepository;
import io.gravitee.repository.management.api.MetadataRepository;
import io.gravitee.repository.management.api.PageRepository;
import io.gravitee.repository.management.api.PlanRepository;
import io.gravitee.repository.management.api.UserRepository;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.Application;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Group;
import io.gravitee.repository.management.model.Metadata;
import io.gravitee.repository.management.model.MetadataReferenceType;
import io.gravitee.repository.management.model.Page;
import io.gravitee.repository.management.model.Plan;
import io.gravitee.repository.management.model.User;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class AuditMetadataQueryServiceImpl
implements AuditMetadataQueryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuditMetadataQueryServiceImpl.class);
    private final ApiRepository apiRepository;
    private final ApplicationRepository applicationRepository;
    private final GroupRepository groupRepository;
    private final MetadataRepository metadataRepository;
    private final PageRepository pageRepository;
    private final PlanRepository planRepository;
    private final UserRepository userRepository;

    public AuditMetadataQueryServiceImpl(@Lazy ApiRepository apiRepository, @Lazy ApplicationRepository applicationRepository, @Lazy GroupRepository groupRepository, @Lazy MetadataRepository metadataRepository, @Lazy PageRepository pageRepository, @Lazy PlanRepository planRepository, @Lazy UserRepository userRepository) {
        this.apiRepository = apiRepository;
        this.applicationRepository = applicationRepository;
        this.groupRepository = groupRepository;
        this.metadataRepository = metadataRepository;
        this.pageRepository = pageRepository;
        this.planRepository = planRepository;
        this.userRepository = userRepository;
    }

    @Override
    public String fetchUserNameMetadata(String userId) {
        try {
            return this.userRepository.findById((Object)userId).map(user -> UserAdapter.INSTANCE.fromUser((User)user).displayName()).orElse(userId);
        }
        catch (TechnicalException e) {
            log.error("Error finding user audit metadata {}", (Object)userId);
            return userId;
        }
    }

    @Override
    public String fetchApiNameMetadata(String apiId) {
        try {
            return this.apiRepository.findById((Object)apiId).map(Api::getName).orElse(apiId);
        }
        catch (TechnicalException e) {
            log.error("Error finding api audit metadata {}", (Object)apiId);
            return apiId;
        }
    }

    @Override
    public String fetchPropertyMetadata(AuditEntity audit, String propertyName, String propertyValue) {
        try {
            switch (Audit.AuditProperties.valueOf((String)propertyName)) {
                case API: {
                    return this.apiRepository.findById((Object)propertyValue).map(Api::getName).orElse(propertyValue);
                }
                case APPLICATION: {
                    return this.applicationRepository.findById((Object)propertyValue).map(Application::getName).orElse(propertyValue);
                }
                case GROUP: {
                    return this.groupRepository.findById((Object)propertyValue).map(Group::getName).orElse(propertyValue);
                }
                case METADATA: {
                    MetadataReferenceType refType = MetadataReferenceType.parse((String)audit.getReferenceType().name());
                    return this.metadataRepository.findById(propertyValue, audit.getReferenceId(), refType).map(Metadata::getName).orElse(propertyValue);
                }
                case PAGE: {
                    return this.pageRepository.findById(propertyValue).map(Page::getName).orElse(propertyValue);
                }
                case PLAN: {
                    return this.planRepository.findById((Object)propertyValue).map(Plan::getName).orElse(propertyValue);
                }
                case USER: {
                    return this.userRepository.findById((Object)propertyValue).map(user -> UserAdapter.INSTANCE.fromUser((User)user).displayName()).orElse(propertyValue);
                }
            }
            return propertyValue;
        }
        catch (TechnicalException e) {
            log.error("Error finding Audit metadata {}:{}", (Object)propertyName, (Object)propertyValue);
            return propertyValue;
        }
    }
}

