/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.plan.PlanStatus;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.EventLatestRepository;
import io.gravitee.repository.management.api.search.EventCriteria;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Event;
import io.gravitee.repository.management.model.EventType;
import io.gravitee.repository.management.model.LifecycleState;
import io.gravitee.rest.api.model.EventEntity;
import io.gravitee.rest.api.model.EventQuery;
import io.gravitee.rest.api.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.model.api.ApiDeploymentEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.model.v4.plan.GenericPlanEntity;
import io.gravitee.rest.api.service.ApiMetadataService;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.EventService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.converter.ApiConverter;
import io.gravitee.rest.api.service.exceptions.AbstractManagementException;
import io.gravitee.rest.api.service.exceptions.ApiNotDeployableException;
import io.gravitee.rest.api.service.exceptions.ApiNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.processor.SynchronizationService;
import io.gravitee.rest.api.service.v4.ApiNotificationService;
import io.gravitee.rest.api.service.v4.ApiSearchService;
import io.gravitee.rest.api.service.v4.ApiStateService;
import io.gravitee.rest.api.service.v4.PlanSearchService;
import io.gravitee.rest.api.service.v4.PrimaryOwnerService;
import io.gravitee.rest.api.service.v4.mapper.ApiMapper;
import io.gravitee.rest.api.service.v4.mapper.GenericApiMapper;
import io.gravitee.rest.api.service.v4.validation.ApiValidationService;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ApiStateServiceImpl
implements ApiStateService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiStateServiceImpl.class);
    private final ApiSearchService apiSearchService;
    private final ApiRepository apiRepository;
    private final ApiMapper apiMapper;
    private final GenericApiMapper genericApiMapper;
    private final ApiNotificationService apiNotificationService;
    private final PrimaryOwnerService primaryOwnerService;
    private final AuditService auditService;
    private final EventService eventService;
    private final EventLatestRepository eventLatestRepository;
    private final ObjectMapper objectMapper;
    private final ApiMetadataService apiMetadataService;
    private final ApiValidationService apiValidationService;
    private final PlanSearchService planSearchService;
    private final ApiConverter apiConverter;
    private final SynchronizationService synchronizationService;

    public ApiStateServiceImpl(@Lazy ApiSearchService apiSearchService, @Lazy ApiRepository apiRepository, ApiMapper apiMapper, GenericApiMapper genericApiMapper, @Lazy ApiNotificationService apiNotificationService, @Lazy PrimaryOwnerService primaryOwnerService, AuditService auditService, @Lazy EventService eventService, @Lazy EventLatestRepository eventLatestRepository, ObjectMapper objectMapper, @Lazy ApiMetadataService apiMetadataService, @Lazy ApiValidationService apiValidationService, PlanSearchService planSearchService, ApiConverter apiConverter, SynchronizationService synchronizationService) {
        this.apiSearchService = apiSearchService;
        this.apiRepository = apiRepository;
        this.apiMapper = apiMapper;
        this.genericApiMapper = genericApiMapper;
        this.apiNotificationService = apiNotificationService;
        this.primaryOwnerService = primaryOwnerService;
        this.auditService = auditService;
        this.eventService = eventService;
        this.eventLatestRepository = eventLatestRepository;
        this.objectMapper = objectMapper;
        this.apiMetadataService = apiMetadataService;
        this.apiValidationService = apiValidationService;
        this.planSearchService = planSearchService;
        this.apiConverter = apiConverter;
        this.synchronizationService = synchronizationService;
    }

    @Override
    public GenericApiEntity deploy(ExecutionContext executionContext, String apiId, String authenticatedUser, ApiDeploymentEntity apiDeploymentEntity) {
        Api api = this.apiSearchService.findRepositoryApiById(executionContext, apiId);
        return this.deploy(executionContext, api, api, authenticatedUser, apiDeploymentEntity);
    }

    @Override
    public GenericApiEntity deploy(ExecutionContext executionContext, Api apiToDeploy, String authenticatedUser, ApiDeploymentEntity apiDeploymentEntity) {
        Api api = this.apiSearchService.findRepositoryApiById(executionContext, apiToDeploy.getId());
        return this.deploy(executionContext, api, apiToDeploy, authenticatedUser, apiDeploymentEntity);
    }

    private GenericApiEntity deploy(ExecutionContext executionContext, Api apiFromDb, Api apiToDeploy, String authenticatedUser, ApiDeploymentEntity apiDeploymentEntity) {
        log.debug("Deploy API: {}", (Object)apiToDeploy.getId());
        if (!this.apiValidationService.canDeploy(executionContext, apiToDeploy.getId())) {
            throw new ApiNotDeployableException("The api {" + apiToDeploy.getId() + "} can not be deployed without at least one published plan");
        }
        this.updateDeploymentDate(apiFromDb);
        this.deployApi(executionContext, authenticatedUser, apiDeploymentEntity, apiToDeploy);
        PrimaryOwnerEntity primaryOwner = this.primaryOwnerService.getPrimaryOwner(executionContext.getOrganizationId(), apiToDeploy.getId());
        GenericApiEntity deployedApi = this.genericApiMapper.toGenericApi(apiToDeploy, primaryOwner);
        GenericApiEntity apiWithMetadata = this.apiMetadataService.fetchMetadataForApi(executionContext, deployedApi);
        this.apiNotificationService.triggerDeployNotification(executionContext, apiWithMetadata);
        return deployedApi;
    }

    private void updateDeploymentDate(Api api) {
        try {
            api.setUpdatedAt(new Date());
            api.setDeployedAt(api.getUpdatedAt());
            this.apiRepository.update((Object)api);
        }
        catch (TechnicalException e) {
            log.error("An error occurs while trying to deploy API: {}", (Object)api.getId(), (Object)e);
            throw new TechnicalManagementException("An error occurs while trying to deploy API: " + api.getId(), e);
        }
    }

    private void deployApi(ExecutionContext executionContext, String authenticatedUser, ApiDeploymentEntity apiDeploymentEntity, Api api) {
        api.setPicture(null);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(Event.EventProperties.USER.getValue(), authenticatedUser);
        this.addDeploymentLabelToProperties(executionContext, api.getId(), properties, apiDeploymentEntity);
        this.eventService.createApiEvent(executionContext, Collections.singleton(executionContext.getEnvironmentId()), executionContext.getOrganizationId(), io.gravitee.rest.api.model.EventType.PUBLISH_API, api, properties);
    }

    private void addDeploymentLabelToProperties(ExecutionContext executionContext, String apiId, Map<String, String> properties, ApiDeploymentEntity apiDeploymentEntity) {
        EventCriteria criteria = EventCriteria.builder().types(Set.of(EventType.PUBLISH_API)).property(Event.EventProperties.API_ID.getValue(), (Object)apiId).build();
        String lastDeployNumber = this.eventLatestRepository.search(criteria, Event.EventProperties.DEPLOYMENT_NUMBER, Long.valueOf(0L), Long.valueOf(1L)).stream().findFirst().map(eventEntity -> eventEntity.getProperties().getOrDefault(Event.EventProperties.DEPLOYMENT_NUMBER.getValue(), "0")).orElse("0");
        String newDeployNumber = Long.toString(Long.parseLong(lastDeployNumber) + 1L);
        properties.put(Event.EventProperties.DEPLOYMENT_NUMBER.getValue(), newDeployNumber);
        if (apiDeploymentEntity != null && StringUtils.isNotEmpty((CharSequence)apiDeploymentEntity.getDeploymentLabel())) {
            properties.put(Event.EventProperties.DEPLOYMENT_LABEL.getValue(), apiDeploymentEntity.getDeploymentLabel());
        }
    }

    @Override
    public GenericApiEntity start(ExecutionContext executionContext, String apiId, String userId) {
        if (!this.apiValidationService.canDeploy(executionContext, apiId)) {
            throw new ApiNotDeployableException("The API {" + apiId + "} can not be started without at least one published plan");
        }
        try {
            log.debug("Start API {}", (Object)apiId);
            GenericApiEntity api = this.updateLifecycle(executionContext, apiId, LifecycleState.STARTED, userId);
            GenericApiEntity genericApiEntity = this.apiMetadataService.fetchMetadataForApi(executionContext, api);
            this.apiNotificationService.triggerStartNotification(executionContext, genericApiEntity);
            return api;
        }
        catch (TechnicalException ex) {
            log.error("An error occurs while trying to start API {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to start API " + apiId, ex);
        }
    }

    @Override
    public GenericApiEntity stop(ExecutionContext executionContext, String apiId, String userId) {
        try {
            log.debug("Stop API {}", (Object)apiId);
            GenericApiEntity apiEntity = this.updateLifecycle(executionContext, apiId, LifecycleState.STOPPED, userId);
            GenericApiEntity genericApiEntity = this.apiMetadataService.fetchMetadataForApi(executionContext, apiEntity);
            this.apiNotificationService.triggerStopNotification(executionContext, genericApiEntity);
            return apiEntity;
        }
        catch (TechnicalException ex) {
            log.error("An error occurs while trying to stop API {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to stop API " + apiId, ex);
        }
    }

    private GenericApiEntity updateLifecycle(ExecutionContext executionContext, String apiId, LifecycleState lifecycleState, String username) throws TechnicalException {
        Optional optApi = this.apiRepository.findById((Object)apiId);
        if (optApi.isPresent()) {
            Api api = (Api)optApi.get();
            Api previousApi = new Api(api);
            api.setUpdatedAt(new Date());
            api.setLifecycleState(lifecycleState);
            Api updateApi = (Api)this.apiRepository.update((Object)api);
            io.gravitee.rest.api.model.v4.api.ApiEntity apiEntity = this.apiMapper.toEntity(updateApi, this.primaryOwnerService.getPrimaryOwner(executionContext.getOrganizationId(), api.getId()));
            this.auditService.createApiAuditLog(executionContext, apiId, Collections.emptyMap(), (Audit.AuditEvent)Api.AuditEvent.API_UPDATED, api.getUpdatedAt(), previousApi, api);
            io.gravitee.rest.api.model.EventType eventType = null;
            switch (lifecycleState) {
                case STARTED: {
                    eventType = io.gravitee.rest.api.model.EventType.START_API;
                    break;
                }
                case STOPPED: {
                    eventType = io.gravitee.rest.api.model.EventType.STOP_API;
                    break;
                }
            }
            GenericApiEntity deployedApi = this.deployLastPublishedAPI(executionContext, apiId, username, eventType);
            if (deployedApi != null) {
                return deployedApi;
            }
            return apiEntity;
        }
        throw new ApiNotFoundException(apiId);
    }

    private GenericApiEntity deployLastPublishedAPI(ExecutionContext executionContext, String apiId, String userId, io.gravitee.rest.api.model.EventType eventType) throws TechnicalException {
        EventQuery query = new EventQuery();
        query.setApi(apiId);
        query.setTypes(Collections.singleton(io.gravitee.rest.api.model.EventType.PUBLISH_API));
        if (executionContext.hasOrganizationId()) {
            query.setOrganizationIds(Set.of(executionContext.getOrganizationId()));
        }
        if (executionContext.hasEnvironmentId()) {
            query.setEnvironmentIds(Set.of(executionContext.getEnvironmentId()));
        }
        Optional<EventEntity> optEvent = this.eventService.search(executionContext, query).stream().max(Comparator.comparing(EventEntity::getCreatedAt));
        try {
            if (optEvent.isPresent()) {
                EventEntity event = optEvent.get();
                JsonNode node = this.objectMapper.readTree(event.getPayload());
                Api lastPublishedAPI = (Api)this.objectMapper.convertValue((Object)node, Api.class);
                lastPublishedAPI.setLifecycleState(this.convert(eventType));
                lastPublishedAPI.setUpdatedAt(new Date());
                lastPublishedAPI.setDeployedAt(new Date());
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put(Event.EventProperties.USER.getValue(), userId);
                lastPublishedAPI.setPicture(null);
                this.eventService.createApiEvent(executionContext, Collections.singleton(executionContext.getEnvironmentId()), executionContext.getOrganizationId(), eventType, lastPublishedAPI, properties);
                return null;
            }
            return this.deploy(executionContext, apiId, userId, new ApiDeploymentEntity());
        }
        catch (AbstractManagementException e) {
            log.info("Unable to deploy last published API {} due to : {}", (Object)apiId, (Object)e.getMessage());
            throw e;
        }
        catch (Exception e) {
            log.error("An error occurs while trying to deploy last published API {}", (Object)apiId, (Object)e);
            throw new TechnicalException("An error occurs while trying to deploy last published API " + apiId, (Throwable)e);
        }
    }

    private LifecycleState convert(io.gravitee.rest.api.model.EventType eventType) {
        return switch (eventType) {
            case io.gravitee.rest.api.model.EventType.START_API -> LifecycleState.STARTED;
            case io.gravitee.rest.api.model.EventType.STOP_API -> LifecycleState.STOPPED;
            default -> throw new IllegalArgumentException("Unknown EventType " + eventType + " to convert EventType into Lifecycle");
        };
    }

    @Override
    public boolean isSynchronized(ExecutionContext executionContext, GenericApiEntity genericApiEntity) {
        try {
            if (genericApiEntity.getOriginContext().isOriginKubernetes()) {
                return true;
            }
            List events = this.eventLatestRepository.search(EventCriteria.builder().types(List.of(EventType.PUBLISH_API, EventType.UNPUBLISH_API)).properties(Map.of(Event.EventProperties.API_ID.getValue(), genericApiEntity.getId())).build(), Event.EventProperties.API_ID, Long.valueOf(0L), Long.valueOf(1L));
            if (!events.isEmpty()) {
                Event lastEvent = (Event)events.get(0);
                boolean sync = false;
                if (EventType.PUBLISH_API.equals((Object)lastEvent.getType())) {
                    Api payloadEntity = (Api)this.objectMapper.readValue(lastEvent.getPayload(), Api.class);
                    if (genericApiEntity.getDefinitionVersion() == DefinitionVersion.V2 || genericApiEntity.getDefinitionVersion() == DefinitionVersion.V1) {
                        apiEntity = (ApiEntity)SerializationUtils.clone((Serializable)((ApiEntity)genericApiEntity));
                        ApiEntity deployedApiEntity = (ApiEntity)SerializationUtils.clone((Serializable)this.apiConverter.toApiEntity(executionContext, payloadEntity, null, false));
                        this.removePathsRuleDescriptionFromApiV1(deployedApiEntity);
                        this.removePathsRuleDescriptionFromApiV1(apiEntity);
                        this.removeFlowsIdsFromApiV2(deployedApiEntity);
                        this.removeFlowsIdsFromApiV2(apiEntity);
                        sync = this.synchronizationService.checkSynchronization(ApiEntity.class, deployedApiEntity, apiEntity);
                    } else {
                        apiEntity = (io.gravitee.rest.api.model.v4.api.ApiEntity)genericApiEntity;
                        io.gravitee.rest.api.model.v4.api.ApiEntity deployedApiEntity = this.apiMapper.toEntity(executionContext, payloadEntity, null, false);
                        sync = this.synchronizationService.checkSynchronization(io.gravitee.rest.api.model.v4.api.ApiEntity.class, deployedApiEntity, apiEntity);
                    }
                    if (sync) {
                        Set<GenericPlanEntity> plans = this.planSearchService.findByApi(executionContext, genericApiEntity.getId());
                        sync = plans.stream().noneMatch(plan -> plan.getPlanStatus() != PlanStatus.STAGING && plan.getNeedRedeployAt().after(genericApiEntity.getDeployedAt()));
                    }
                }
                return sync;
            }
        }
        catch (Exception e) {
            String errorMsg = String.format("An error occurs while trying to check API synchronization state '%s'", genericApiEntity.getId());
            log.error(errorMsg, (Object)genericApiEntity.getId(), (Object)e);
        }
        return false;
    }

    private void removePathsRuleDescriptionFromApiV1(ApiEntity api) {
        if (api.getPaths() != null) {
            api.getPaths().forEach((s, rules) -> {
                if (rules != null) {
                    rules.forEach(rule -> rule.setDescription(""));
                }
            });
        }
    }

    private void removeFlowsIdsFromApiV2(ApiEntity api) {
        api.getFlows().forEach(flow -> flow.setId(null));
        api.getPlans().forEach(plan -> plan.getFlows().forEach(flow -> flow.setId(null)));
    }
}

