/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.crud_service.category;

import io.gravitee.apim.core.category.crud_service.CategoryApiCrudService;
import io.gravitee.apim.core.category.exception.ApiAndCategoryNotAssociatedException;
import io.gravitee.apim.core.category.model.ApiCategoryOrder;
import io.gravitee.apim.infra.adapter.CategoryAdapter;
import io.gravitee.repository.management.api.ApiCategoryOrderRepository;
import java.util.Objects;
import java.util.Optional;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class CategoryApiCrudServiceImpl
implements CategoryApiCrudService {
    private final ApiCategoryOrderRepository apiCategoryOrderRepository;

    public CategoryApiCrudServiceImpl(@Lazy ApiCategoryOrderRepository apiCategoryOrderRepository) {
        this.apiCategoryOrderRepository = apiCategoryOrderRepository;
    }

    @Override
    public Optional<ApiCategoryOrder> findById(String apiId, String categoryId) {
        if (Objects.isNull(apiId) || Objects.isNull(categoryId)) {
            throw new ApiAndCategoryNotAssociatedException(apiId, categoryId);
        }
        return this.apiCategoryOrderRepository.findById(apiId, categoryId).map(CategoryAdapter.INSTANCE::toCoreModel);
    }

    @Override
    public ApiCategoryOrder get(String apiId, String categoryId) {
        return this.findById(apiId, categoryId).orElseThrow(() -> new ApiAndCategoryNotAssociatedException(apiId, categoryId));
    }
}

