/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.template;

import freemarker.core.TemplateClassResolver;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import io.gravitee.apim.core.template.TemplateProcessor;
import io.gravitee.apim.core.template.TemplateProcessorException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;

@Service
public class FreemarkerTemplateProcessor
implements TemplateProcessor {
    @Override
    public String processInlineTemplate(String template, Map<String, Object> params) throws TemplateProcessorException {
        Configuration configuration = new Configuration(Configuration.VERSION_2_3_22);
        configuration.setNewBuiltinClassResolver(TemplateClassResolver.SAFER_RESOLVER);
        try {
            Template freemarkerTemplate = new Template("", (Reader)new StringReader(template), configuration);
            return FreeMarkerTemplateUtils.processTemplateIntoString((Template)freemarkerTemplate, params);
        }
        catch (TemplateException | IOException e) {
            throw new TemplateProcessorException(template, e);
        }
    }
}

