/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.analytics.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.analytics.query_service.AnalyticsQueryService;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.exception.ApiInvalidDefinitionVersionException;
import io.gravitee.apim.core.api.exception.ApiNotFoundException;
import io.gravitee.apim.core.api.exception.TcpProxyNotSupportedException;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.rest.api.model.v4.analytics.ResponseStatusRanges;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseCase
public class SearchResponseStatusRangesUseCase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SearchResponseStatusRangesUseCase.class);
    private final AnalyticsQueryService analyticsQueryService;
    private final ApiCrudService apiCrudService;

    public Output execute(ExecutionContext executionContext, Input input) {
        this.validateApiRequirements(input);
        return this.analyticsQueryService.searchResponseStatusRanges(executionContext, input.apiId()).map(Output::new).orElse(new Output());
    }

    private void validateApiRequirements(Input input) {
        Api api = this.apiCrudService.get(input.apiId);
        SearchResponseStatusRangesUseCase.validateApiDefinitionVersion(api.getDefinitionVersion(), input.apiId);
        SearchResponseStatusRangesUseCase.validateApiMultiTenancyAccess(api, input.environmentId);
        this.validateApiIsNotTcp(api);
    }

    private void validateApiIsNotTcp(Api api) {
        if (api.getApiDefinitionV4().isTcpProxy()) {
            throw new TcpProxyNotSupportedException(api.getId());
        }
    }

    private static void validateApiMultiTenancyAccess(Api api, String environmentId) {
        if (!api.belongsToEnvironment(environmentId)) {
            throw new ApiNotFoundException(api.getId());
        }
    }

    private static void validateApiDefinitionVersion(DefinitionVersion definitionVersion, String apiId) {
        if (!DefinitionVersion.V4.equals((Object)definitionVersion)) {
            throw new ApiInvalidDefinitionVersionException(apiId);
        }
    }

    @Generated
    public SearchResponseStatusRangesUseCase(AnalyticsQueryService analyticsQueryService, ApiCrudService apiCrudService) {
        this.analyticsQueryService = analyticsQueryService;
        this.apiCrudService = apiCrudService;
    }

    public record Input(String apiId, String environmentId) {
    }

    public record Output(Optional<ResponseStatusRanges> responseStatusRanges) {
        Output(ResponseStatusRanges responseStatusRanges) {
            this(Optional.of(responseStatusRanges));
        }

        Output() {
            this(new ResponseStatusRanges());
        }
    }
}

