/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.query_service.analytics;

import io.gravitee.apim.core.analytics.query_service.AnalyticsQueryService;
import io.gravitee.repository.log.v4.api.AnalyticsRepository;
import io.gravitee.repository.log.v4.model.analytics.AverageConnectionDurationQuery;
import io.gravitee.repository.log.v4.model.analytics.AverageMessagesPerRequestQuery;
import io.gravitee.repository.log.v4.model.analytics.RequestsCountQuery;
import io.gravitee.repository.log.v4.model.analytics.ResponseStatusRangesQuery;
import io.gravitee.rest.api.model.v4.analytics.AverageConnectionDuration;
import io.gravitee.rest.api.model.v4.analytics.AverageMessagesPerRequest;
import io.gravitee.rest.api.model.v4.analytics.RequestsCount;
import io.gravitee.rest.api.model.v4.analytics.ResponseStatusRanges;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class AnalyticsQueryServiceImpl
implements AnalyticsQueryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnalyticsQueryServiceImpl.class);
    private final AnalyticsRepository analyticsRepository;

    public AnalyticsQueryServiceImpl(@Lazy AnalyticsRepository analyticsRepository) {
        this.analyticsRepository = analyticsRepository;
    }

    @Override
    public Optional<RequestsCount> searchRequestsCount(ExecutionContext executionContext, String apiId) {
        return this.analyticsRepository.searchRequestsCount(executionContext.getQueryContext(), RequestsCountQuery.builder().apiId(apiId).build()).map(countAggregate -> RequestsCount.builder().total(Long.valueOf(countAggregate.getTotal())).countsByEntrypoint(countAggregate.getCountBy()).build());
    }

    @Override
    public Optional<AverageMessagesPerRequest> searchAverageMessagesPerRequest(ExecutionContext executionContext, String apiId) {
        return this.analyticsRepository.searchAverageMessagesPerRequest(executionContext.getQueryContext(), AverageMessagesPerRequestQuery.builder().apiId(apiId).build()).map(averageAggregate -> AverageMessagesPerRequest.builder().globalAverage(Double.valueOf(averageAggregate.getAverage())).averagesByEntrypoint(averageAggregate.getAverageBy()).build());
    }

    @Override
    public Optional<ResponseStatusRanges> searchResponseStatusRanges(ExecutionContext executionContext, String apiId) {
        Optional queryResult = this.analyticsRepository.searchResponseStatusRanges(executionContext.getQueryContext(), ResponseStatusRangesQuery.builder().apiId(apiId).build());
        return queryResult.map(analytics -> ResponseStatusRanges.builder().ranges(analytics.getRanges()).statusRangesCountByEntrypoint(analytics.getStatusRangesCountByEntrypoint()).build());
    }

    @Override
    public Optional<AverageConnectionDuration> searchAverageConnectionDuration(ExecutionContext executionContext, String apiId) {
        return this.analyticsRepository.searchAverageConnectionDuration(executionContext.getQueryContext(), AverageConnectionDurationQuery.builder().apiId(apiId).build()).map(averageAggregate -> AverageConnectionDuration.builder().globalAverage(Double.valueOf(averageAggregate.getAverage())).averagesByEntrypoint(averageAggregate.getAverageBy()).build());
    }
}

