/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.rest.api.model.AccessControlReferenceType;
import io.gravitee.rest.api.model.GroupEntity;
import io.gravitee.rest.api.model.MemberEntity;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.PageType;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.api.ApiLifecycleState;
import io.gravitee.rest.api.model.permissions.ApiPermission;
import io.gravitee.rest.api.model.permissions.Permission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.service.AccessControlService;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.v4.ApiAuthorizationService;
import io.gravitee.rest.api.service.v4.ApiSearchService;
import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AccessControlServiceImpl
extends AbstractService
implements AccessControlService {
    private final Logger logger = LoggerFactory.getLogger(AccessControlServiceImpl.class);
    @Autowired
    private MembershipService membershipService;
    @Autowired
    private GroupService groupService;
    @Autowired
    private ApiSearchService apiSearchService;
    @Autowired
    private ApiAuthorizationService apiAuthorizationService;
    @Autowired
    private RoleService roleService;

    @Override
    public boolean canAccessApiFromPortal(ExecutionContext executionContext, GenericApiEntity genericApiEntity) {
        if (!ApiLifecycleState.PUBLISHED.equals((Object)genericApiEntity.getLifecycleState())) {
            return false;
        }
        if (Visibility.PUBLIC.equals((Object)genericApiEntity.getVisibility())) {
            return true;
        }
        if (this.isAuthenticated()) {
            return this.apiAuthorizationService.canConsumeApi(executionContext, this.getAuthenticatedUsername(), genericApiEntity);
        }
        return false;
    }

    @Override
    public boolean canAccessApiFromPortal(ExecutionContext executionContext, String apiId) {
        GenericApiEntity genericApi = this.apiSearchService.findGenericById(executionContext, apiId);
        return this.canAccessApiFromPortal(executionContext, genericApi);
    }

    private boolean canAccessPage(ExecutionContext executionContext, GenericApiEntity genericApiEntity, PageEntity pageEntity) {
        if (!pageEntity.isPublished()) {
            return false;
        }
        if (Visibility.PUBLIC.equals((Object)pageEntity.getVisibility())) {
            return true;
        }
        if (!this.isAuthenticated()) {
            return false;
        }
        Set accessControls = pageEntity.getAccessControls();
        if (accessControls == null || accessControls.isEmpty()) {
            return true;
        }
        Set<GroupEntity> userGroups = this.groupService.findByUser(this.getAuthenticatedUsername());
        Set<RoleEntity> contextualUserRoles = this.getContextualUserRoles(executionContext, genericApiEntity, executionContext.getEnvironmentId());
        return accessControls.stream().anyMatch(acl -> {
            if (AccessControlReferenceType.ROLE.name().equals(acl.getReferenceType())) {
                boolean roleMatched = contextualUserRoles.stream().anyMatch(role -> role.getId().equals(acl.getReferenceId()));
                return pageEntity.isExcludedAccessControls() != roleMatched;
            }
            if (AccessControlReferenceType.GROUP.name().equals(acl.getReferenceType())) {
                boolean groupMatched = userGroups.stream().anyMatch(group -> group.getId().equals(acl.getReferenceId()));
                return pageEntity.isExcludedAccessControls() != groupMatched;
            }
            this.logger.warn("ACL reference type [{}] not found", (Object)acl.getReferenceType());
            return false;
        });
    }

    @Override
    public boolean canAccessPageFromPortal(ExecutionContext executionContext, PageEntity pageEntity) {
        return this.canAccessPageFromPortal(executionContext, null, pageEntity);
    }

    @Override
    public boolean canAccessPageFromPortal(ExecutionContext executionContext, String apiId, PageEntity pageEntity) {
        if (PageType.SYSTEM_FOLDER.name().equals(pageEntity.getType()) || PageType.MARKDOWN_TEMPLATE.name().equals(pageEntity.getType())) {
            return false;
        }
        if (apiId != null) {
            GenericApiEntity genericApiEntity = this.apiSearchService.findGenericById(executionContext, apiId);
            return this.canAccessPage(executionContext, genericApiEntity, pageEntity);
        }
        return this.canAccessPage(executionContext, null, pageEntity);
    }

    @Override
    public boolean canAccessApiPageFromPortal(ExecutionContext executionContext, GenericApiEntity apiEntity, PageEntity pageEntity) {
        return this.canAccessPage(executionContext, apiEntity, pageEntity);
    }

    @Override
    public boolean canAccessPageFromConsole(ExecutionContext executionContext, GenericApiEntity genericApiEntity, PageEntity pageEntity) {
        if (this.canAccessPage(executionContext, genericApiEntity, pageEntity)) {
            return true;
        }
        return this.canEditApiPage(executionContext, genericApiEntity);
    }

    private boolean canEditApiPage(ExecutionContext executionContext, GenericApiEntity genericApiEntity) {
        if (genericApiEntity == null) {
            return false;
        }
        boolean canEditApiPage = false;
        MemberEntity member = this.membershipService.getUserMember(executionContext, MembershipReferenceType.API, genericApiEntity.getId(), this.getAuthenticatedUsername());
        if (member == null && genericApiEntity.getGroups() != null) {
            Iterator groupIdIterator = genericApiEntity.getGroups().iterator();
            while (!canEditApiPage && groupIdIterator.hasNext()) {
                String groupId = (String)groupIdIterator.next();
                member = this.membershipService.getUserMember(executionContext, MembershipReferenceType.GROUP, groupId, this.getAuthenticatedUsername());
                canEditApiPage = this.canEditApiPage(member);
            }
        } else {
            canEditApiPage = this.canEditApiPage(member);
        }
        return canEditApiPage;
    }

    private boolean canEditApiPage(MemberEntity member) {
        if (member == null) {
            return false;
        }
        return this.roleService.hasPermission(member.getPermissions(), (Permission)ApiPermission.DOCUMENTATION, new RolePermissionAction[]{RolePermissionAction.UPDATE, RolePermissionAction.CREATE, RolePermissionAction.DELETE});
    }

    private Set<RoleEntity> getContextualUserRoles(ExecutionContext executionContext, GenericApiEntity genericApiEntity, String environmentId) {
        if (genericApiEntity != null) {
            Set<RoleEntity> roles = this.membershipService.getRoles(MembershipReferenceType.API, genericApiEntity.getId(), MembershipMemberType.USER, this.getAuthenticatedUsername());
            if (genericApiEntity.getGroups() != null && !genericApiEntity.getGroups().isEmpty()) {
                genericApiEntity.getGroups().forEach(groupId -> {
                    MemberEntity member = this.membershipService.getUserMember(executionContext, MembershipReferenceType.GROUP, (String)groupId, this.getAuthenticatedUsername());
                    if (member != null) {
                        roles.addAll(member.getRoles());
                    }
                });
            }
            return roles;
        }
        return this.membershipService.getRoles(MembershipReferenceType.ENVIRONMENT, environmentId, MembershipMemberType.USER, this.getAuthenticatedUsername());
    }
}

