/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.documentation.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.documentation.crud_service.PageCrudService;
import io.gravitee.apim.core.documentation.model.Page;
import io.gravitee.apim.core.documentation.query_service.PageQueryService;
import java.util.Optional;

@DomainService
public class HomepageDomainService {
    private final PageQueryService pageQueryService;
    private final PageCrudService pageCrudService;

    public HomepageDomainService(PageQueryService pageQueryService, PageCrudService pageCrudService) {
        this.pageQueryService = pageQueryService;
        this.pageCrudService = pageCrudService;
    }

    public void setPreviousHomepageToFalse(String apiId, String currentHomepageId) {
        Optional<Page> pages = this.pageQueryService.findHomepageByApiId(apiId);
        pages.stream().filter(p -> !p.getId().equals(currentHomepageId)).forEach(p -> {
            p.setHomepage(false);
            this.pageCrudService.updateDocumentationPage((Page)p);
        });
    }
}

