/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.gravitee.apim.core.theme.model.ThemeType;
import io.gravitee.apim.infra.adapter.GraviteeJacksonMapper;
import io.gravitee.repository.management.model.Theme;
import io.gravitee.rest.api.model.theme.portal.ThemeDefinition;
import io.gravitee.rest.api.model.theme.portal.ThemeEntity;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.factory.Mappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mapper
public interface ThemeAdapter {
    public static final Logger LOGGER = LoggerFactory.getLogger(ThemeAdapter.class);
    public static final ThemeAdapter INSTANCE = (ThemeAdapter)Mappers.getMapper(ThemeAdapter.class);

    @Mapping(target="definition", expression="java(serializeDefinition(theme))")
    public Theme map(io.gravitee.apim.core.theme.model.Theme var1);

    @Mappings(value={@Mapping(target="definitionPortal", expression="java(deserializeDefinitionPortal(theme))"), @Mapping(target="definitionPortalNext", expression="java(deserializeDefinitionPortalNext(theme))")})
    public io.gravitee.apim.core.theme.model.Theme map(Theme var1);

    @Mapping(target="definitionPortal", source="definition")
    public io.gravitee.apim.core.theme.model.Theme map(ThemeEntity var1);

    public List<io.gravitee.apim.core.theme.model.Theme> map(List<Theme> var1);

    public Set<io.gravitee.apim.core.theme.model.Theme> map(Set<Theme> var1);

    default public ThemeDefinition deserializeDefinitionPortal(Theme theme) {
        if (Objects.nonNull(theme.getDefinition()) && io.gravitee.repository.management.model.ThemeType.PORTAL.equals((Object)theme.getType())) {
            try {
                return (ThemeDefinition)GraviteeJacksonMapper.getInstance().readValue(theme.getDefinition(), ThemeDefinition.class);
            }
            catch (IOException ioe) {
                LOGGER.error("Unexpected error while deserializing PORTAL theme definition", (Throwable)ioe);
            }
        }
        return null;
    }

    default public io.gravitee.rest.api.model.theme.portalnext.ThemeDefinition deserializeDefinitionPortalNext(Theme theme) {
        if (Objects.nonNull(theme.getDefinition()) && io.gravitee.repository.management.model.ThemeType.PORTAL_NEXT.equals((Object)theme.getType())) {
            try {
                return (io.gravitee.rest.api.model.theme.portalnext.ThemeDefinition)GraviteeJacksonMapper.getInstance().readValue(theme.getDefinition(), io.gravitee.rest.api.model.theme.portalnext.ThemeDefinition.class);
            }
            catch (IOException ioe) {
                LOGGER.error("Unexpected error while deserializing PORTAL_NEXT theme definition", (Throwable)ioe);
            }
        }
        return null;
    }

    default public String serializeDefinition(io.gravitee.apim.core.theme.model.Theme theme) {
        ThemeDefinition definition = ThemeType.PORTAL.equals((Object)theme.getType()) ? theme.getDefinitionPortal() : theme.getDefinitionPortalNext();
        return Optional.ofNullable(definition).map((? super T def) -> {
            try {
                return GraviteeJacksonMapper.getInstance().writeValueAsString(def);
            }
            catch (JsonProcessingException e) {
                LOGGER.error("Unable to serialize definition: {}", definition);
                return "";
            }
        }).orElse("");
    }
}

