/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.configuration.dictionary;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.common.component.Lifecycle;
import io.gravitee.common.utils.IdGenerator;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.DictionaryRepository;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Dictionary;
import io.gravitee.repository.management.model.DictionaryProvider;
import io.gravitee.repository.management.model.DictionaryTrigger;
import io.gravitee.repository.management.model.LifecycleState;
import io.gravitee.rest.api.model.EventType;
import io.gravitee.rest.api.model.configuration.dictionary.DictionaryEntity;
import io.gravitee.rest.api.model.configuration.dictionary.DictionaryProviderEntity;
import io.gravitee.rest.api.model.configuration.dictionary.DictionaryTriggerEntity;
import io.gravitee.rest.api.model.configuration.dictionary.DictionaryType;
import io.gravitee.rest.api.model.configuration.dictionary.NewDictionaryEntity;
import io.gravitee.rest.api.model.configuration.dictionary.UpdateDictionaryEntity;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.EventService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.configuration.dictionary.DictionaryService;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.impl.configuration.dictionary.DictionaryAlreadyExistsException;
import io.gravitee.rest.api.service.impl.configuration.dictionary.DictionaryNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class DictionaryServiceImpl
extends AbstractService
implements DictionaryService {
    private final Logger LOGGER = LoggerFactory.getLogger(DictionaryServiceImpl.class);
    @Lazy
    @Autowired
    private DictionaryRepository dictionaryRepository;
    @Autowired
    private AuditService auditService;
    @Autowired
    private EventService eventService;
    @Autowired
    private ObjectMapper mapper;

    @Override
    public Set<DictionaryEntity> findAll(ExecutionContext executionContext) {
        try {
            return this.dictionaryRepository.findAllByEnvironments(Collections.singleton(executionContext.getEnvironmentId())).stream().map(this::convert).collect(Collectors.toSet());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to retrieve dictionaries", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to retrieve dictionaries", ex);
        }
    }

    @Override
    public DictionaryEntity deploy(ExecutionContext executionContext, String id) {
        try {
            this.LOGGER.debug("Deploy dictionary {}", (Object)id);
            Dictionary dictionary = this.dictionaryRepository.findById((Object)id).filter(d -> d.getEnvironmentId().equalsIgnoreCase(executionContext.getEnvironmentId())).orElseThrow(() -> new DictionaryNotFoundException(id));
            dictionary.setUpdatedAt(new Date());
            dictionary.setDeployedAt(dictionary.getUpdatedAt());
            dictionary = (Dictionary)this.dictionaryRepository.update((Object)dictionary);
            this.eventService.createDictionaryEvent(executionContext, Collections.singleton(executionContext.getEnvironmentId()), executionContext.getOrganizationId(), EventType.PUBLISH_DICTIONARY, dictionary);
            return this.convert(dictionary);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to deploy dictionary {}", (Object)id, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to deploy " + id, ex);
        }
    }

    @Override
    public DictionaryEntity undeploy(ExecutionContext executionContext, String id) {
        try {
            this.LOGGER.debug("Undeploy dictionary {}", (Object)id);
            Dictionary dictionary = this.dictionaryRepository.findById((Object)id).filter(d -> d.getEnvironmentId().equalsIgnoreCase(executionContext.getEnvironmentId())).orElseThrow(() -> new DictionaryNotFoundException(id));
            dictionary.setUpdatedAt(new Date());
            dictionary.setDeployedAt(dictionary.getUpdatedAt());
            dictionary = (Dictionary)this.dictionaryRepository.update((Object)dictionary);
            this.eventService.createDictionaryEvent(executionContext, Collections.singleton(executionContext.getEnvironmentId()), executionContext.getOrganizationId(), EventType.UNPUBLISH_DICTIONARY, dictionary);
            return this.convert(dictionary);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to undeploy dictionary {}", (Object)id, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to undeploy " + id, ex);
        }
    }

    @Override
    public DictionaryEntity start(ExecutionContext executionContext, String id) {
        try {
            this.LOGGER.debug("Start dictionary {}", (Object)id);
            Dictionary dictionary = this.dictionaryRepository.findById((Object)id).filter(d -> d.getEnvironmentId().equalsIgnoreCase(executionContext.getEnvironmentId())).orElseThrow(() -> new DictionaryNotFoundException(id));
            dictionary.setUpdatedAt(new Date());
            dictionary.setState(LifecycleState.STARTED);
            Dictionary updatedDictionary = (Dictionary)this.dictionaryRepository.update((Object)dictionary);
            this.eventService.createDynamicDictionaryEvent(executionContext, Collections.singleton(executionContext.getEnvironmentId()), executionContext.getOrganizationId(), EventType.START_DICTIONARY, id);
            this.createAuditLog(executionContext, (Audit.AuditEvent)Dictionary.AuditEvent.DICTIONARY_UPDATED, updatedDictionary.getUpdatedAt(), dictionary, updatedDictionary);
            return this.convert(updatedDictionary);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to undeploy dictionary {}", (Object)id, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to undeploy " + id, ex);
        }
    }

    @Override
    public DictionaryEntity stop(ExecutionContext executionContext, String id) {
        try {
            this.LOGGER.debug("Stop dictionary {}", (Object)id);
            Dictionary dictionary = this.dictionaryRepository.findById((Object)id).filter(d -> d.getEnvironmentId().equalsIgnoreCase(executionContext.getEnvironmentId())).orElseThrow(() -> new DictionaryNotFoundException(id));
            dictionary.setUpdatedAt(new Date());
            dictionary.setState(LifecycleState.STOPPED);
            Dictionary updatedDictionary = (Dictionary)this.dictionaryRepository.update((Object)dictionary);
            this.eventService.createDynamicDictionaryEvent(executionContext, Collections.singleton(executionContext.getEnvironmentId()), executionContext.getOrganizationId(), EventType.STOP_DICTIONARY, id);
            this.createAuditLog(executionContext, (Audit.AuditEvent)Dictionary.AuditEvent.DICTIONARY_UPDATED, updatedDictionary.getUpdatedAt(), dictionary, updatedDictionary);
            return this.convert(updatedDictionary);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to undeploy dictionary {}", (Object)id, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to undeploy " + id, ex);
        }
    }

    @Override
    public DictionaryEntity create(ExecutionContext executionContext, NewDictionaryEntity newDictionaryEntity) {
        try {
            this.LOGGER.debug("Create dictionary {}", (Object)newDictionaryEntity);
            Optional optDictionary = this.dictionaryRepository.findById((Object)IdGenerator.generate((String)newDictionaryEntity.getName()));
            if (optDictionary.isPresent()) {
                throw new DictionaryAlreadyExistsException(newDictionaryEntity.getName());
            }
            Dictionary dictionary = this.convert(newDictionaryEntity);
            dictionary.setEnvironmentId(executionContext.getEnvironmentId());
            dictionary.setCreatedAt(new Date());
            dictionary.setState(LifecycleState.STOPPED);
            dictionary.setUpdatedAt(dictionary.getCreatedAt());
            Dictionary createdDictionary = (Dictionary)this.dictionaryRepository.create((Object)dictionary);
            this.createAuditLog(executionContext, (Audit.AuditEvent)Dictionary.AuditEvent.DICTIONARY_CREATED, dictionary.getCreatedAt(), null, dictionary);
            return this.convert(createdDictionary);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to create dictionary {}", (Object)newDictionaryEntity, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to create " + newDictionaryEntity, ex);
        }
    }

    @Override
    public DictionaryEntity update(ExecutionContext executionContext, String id, UpdateDictionaryEntity updateDictionaryEntity) {
        try {
            this.LOGGER.debug("Update dictionary {}", (Object)updateDictionaryEntity);
            Dictionary dictionaryToUpdate = this.dictionaryRepository.findById((Object)id).filter(d -> d.getEnvironmentId().equalsIgnoreCase(executionContext.getEnvironmentId())).orElseThrow(() -> new DictionaryNotFoundException(updateDictionaryEntity.getName()));
            Dictionary dictionary = this.convert(updateDictionaryEntity);
            dictionary.setId(id);
            dictionary.setCreatedAt(dictionaryToUpdate.getCreatedAt());
            dictionary.setEnvironmentId(dictionaryToUpdate.getEnvironmentId());
            dictionary.setUpdatedAt(new Date());
            dictionary.setState(dictionaryToUpdate.getState());
            Dictionary updatedDictionary = (Dictionary)this.dictionaryRepository.update((Object)dictionary);
            if (updatedDictionary.getType() == io.gravitee.repository.management.model.DictionaryType.DYNAMIC && updatedDictionary.getState() == LifecycleState.STARTED) {
                this.eventService.createDynamicDictionaryEvent(executionContext, Collections.singleton(executionContext.getEnvironmentId()), executionContext.getOrganizationId(), EventType.START_DICTIONARY, id);
            }
            this.createAuditLog(executionContext, (Audit.AuditEvent)Dictionary.AuditEvent.DICTIONARY_UPDATED, updatedDictionary.getUpdatedAt(), dictionaryToUpdate, updatedDictionary);
            return this.convert(updatedDictionary);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to update dictionary {}", (Object)updateDictionaryEntity, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to update " + updateDictionaryEntity, ex);
        }
    }

    @Override
    public DictionaryEntity updateProperties(ExecutionContext executionContext, String id, Map<String, String> properties) {
        try {
            this.LOGGER.debug("Update dictionary properties {}", (Object)id);
            Optional optDictionary = this.dictionaryRepository.findById((Object)id);
            if (optDictionary.isEmpty()) {
                throw new DictionaryNotFoundException(id);
            }
            Dictionary dictionary = (Dictionary)optDictionary.get();
            dictionary.setProperties(properties);
            dictionary.setUpdatedAt(new Date());
            dictionary.setDeployedAt(dictionary.getUpdatedAt());
            Dictionary updatedDictionary = (Dictionary)this.dictionaryRepository.update((Object)dictionary);
            this.eventService.createDictionaryEvent(executionContext, Collections.singleton(executionContext.getEnvironmentId()), executionContext.getOrganizationId(), EventType.PUBLISH_DICTIONARY, dictionary);
            this.createAuditLog(executionContext, (Audit.AuditEvent)Dictionary.AuditEvent.DICTIONARY_UPDATED, updatedDictionary.getUpdatedAt(), (Dictionary)optDictionary.get(), updatedDictionary);
            return this.convert(updatedDictionary);
        }
        catch (TechnicalException ex) {
            throw new TechnicalManagementException("An error occurs while trying to update dictionary '" + id + "' properties", ex);
        }
    }

    @Override
    public DictionaryEntity findById(ExecutionContext executionContext, String id) {
        try {
            this.LOGGER.debug("Find dictionary by ID: {}", (Object)id);
            Optional<Dictionary> byId = this.dictionaryRepository.findById((Object)id);
            if (executionContext.hasEnvironmentId()) {
                byId = byId.filter(d -> d.getEnvironmentId().equalsIgnoreCase(executionContext.getEnvironmentId()));
            }
            return byId.map(this::convert).orElseThrow(() -> new DictionaryNotFoundException(id));
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to delete a dictionary using its ID {}", (Object)id, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete a dictionary using its ID " + id, ex);
        }
    }

    @Override
    public void delete(ExecutionContext executionContext, String id) {
        try {
            this.LOGGER.debug("Delete dictionary: {}", (Object)id);
            Dictionary dictionary = this.dictionaryRepository.findById((Object)id).filter(d -> d.getEnvironmentId().equalsIgnoreCase(executionContext.getEnvironmentId())).orElseThrow(() -> new DictionaryNotFoundException(id));
            if (dictionary.getType() == io.gravitee.repository.management.model.DictionaryType.DYNAMIC) {
                this.stop(executionContext, id);
            }
            this.dictionaryRepository.delete((Object)id);
            this.eventService.createDictionaryEvent(executionContext, Collections.singleton(executionContext.getEnvironmentId()), executionContext.getOrganizationId(), EventType.UNPUBLISH_DICTIONARY, dictionary);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to delete a dictionary using its ID {}", (Object)id, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete a dictionary using its ID " + id, ex);
        }
    }

    private void createAuditLog(ExecutionContext executionContext, Audit.AuditEvent event, Date createdAt, Dictionary oldValue, Dictionary newValue) {
        String dictionaryName = oldValue != null ? oldValue.getName() : newValue.getName();
        this.auditService.createAuditLog(executionContext, Collections.singletonMap(Audit.AuditProperties.DICTIONARY, dictionaryName), event, createdAt, oldValue, newValue);
    }

    private DictionaryEntity convert(Dictionary dictionary) {
        DictionaryEntity.DictionaryEntityBuilder dictionaryEntityBuilder = DictionaryEntity.builder().id(dictionary.getId()).name(dictionary.getName()).description(dictionary.getDescription()).createdAt(dictionary.getCreatedAt()).updatedAt(dictionary.getUpdatedAt()).deployedAt(dictionary.getDeployedAt()).type(DictionaryType.valueOf((String)dictionary.getType().name())).properties(dictionary.getProperties()).state(Lifecycle.State.valueOf((String)dictionary.getState().name()));
        if (dictionary.getType() == io.gravitee.repository.management.model.DictionaryType.DYNAMIC) {
            dictionaryEntityBuilder.provider(this.convert(dictionary.getProvider())).trigger(this.convert(dictionary.getTrigger()));
        }
        return dictionaryEntityBuilder.build();
    }

    private Dictionary convert(UpdateDictionaryEntity updateDictionaryEntity) {
        Dictionary dictionary = new Dictionary();
        dictionary.setName(updateDictionaryEntity.getName());
        dictionary.setDescription(updateDictionaryEntity.getDescription());
        dictionary.setProperties(updateDictionaryEntity.getProperties());
        DictionaryType type = updateDictionaryEntity.getType();
        if (type != null) {
            dictionary.setType(io.gravitee.repository.management.model.DictionaryType.valueOf((String)type.name()));
        }
        if (type == DictionaryType.DYNAMIC) {
            dictionary.setProvider(this.convert(updateDictionaryEntity.getProvider()));
            dictionary.setTrigger(this.convert(updateDictionaryEntity.getTrigger()));
        }
        return dictionary;
    }

    private Dictionary convert(NewDictionaryEntity newDictionaryEntity) {
        Dictionary dictionary = new Dictionary();
        dictionary.setId(IdGenerator.generate((String)newDictionaryEntity.getName()));
        dictionary.setName(newDictionaryEntity.getName());
        dictionary.setDescription(newDictionaryEntity.getDescription());
        DictionaryType type = newDictionaryEntity.getType();
        if (type != null) {
            dictionary.setType(io.gravitee.repository.management.model.DictionaryType.valueOf((String)type.name()));
        }
        if (type == DictionaryType.MANUAL) {
            dictionary.setProperties(newDictionaryEntity.getProperties());
        } else {
            dictionary.setProvider(this.convert(newDictionaryEntity.getProvider()));
            dictionary.setTrigger(this.convert(newDictionaryEntity.getTrigger()));
        }
        return dictionary;
    }

    private DictionaryProvider convert(DictionaryProviderEntity providerEntity) {
        DictionaryProvider provider = null;
        if (providerEntity != null && providerEntity.getType() != null && providerEntity.getConfiguration() != null) {
            provider = new DictionaryProvider();
            provider.setType(providerEntity.getType());
            provider.setConfiguration(providerEntity.getConfiguration().toString());
        }
        return provider;
    }

    private DictionaryProviderEntity convert(DictionaryProvider provider) {
        DictionaryProviderEntity entity = null;
        if (provider != null) {
            entity = new DictionaryProviderEntity();
            entity.setType(provider.getType());
            try {
                entity.setConfiguration(this.mapper.readTree(provider.getConfiguration()));
            }
            catch (IOException e) {
                this.LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return entity;
    }

    private DictionaryTrigger convert(DictionaryTriggerEntity triggerEntity) {
        DictionaryTrigger trigger = null;
        if (triggerEntity != null) {
            trigger = new DictionaryTrigger();
            trigger.setRate(triggerEntity.getRate());
            trigger.setUnit(triggerEntity.getUnit());
        }
        return trigger;
    }

    private DictionaryTriggerEntity convert(DictionaryTrigger trigger) {
        DictionaryTriggerEntity entity = null;
        if (trigger != null) {
            entity = new DictionaryTriggerEntity();
            entity.setRate(trigger.getRate());
            entity.setUnit(trigger.getUnit());
        }
        return entity;
    }
}

